/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.util.iterable;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.persistence.jpa.jpql.util.iterator.ArrayIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterable<E>
implements Iterable<E> {
    final E[] array;
    final int start;
    final int length;

    public ArrayIterable(E ... array) {
        this(array, 0, array.length);
    }

    public ArrayIterable(E[] array, int start) {
        this(array, start, array.length - start);
    }

    public ArrayIterable(E[] array, int start, int length) {
        if (start < 0 || start > array.length) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (length < 0 || length > array.length - start) {
            throw new IllegalArgumentException("length: " + length);
        }
        this.array = array;
        this.start = start;
        this.length = length;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator(this.array, this.start, this.length);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

