/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

public final class ComparisonExpressionFactory
extends ExpressionFactory {
    public static final String ID = "comparison";

    public ComparisonExpressionFactory() {
        super(ID, "<>", "=", ">", ">=", "<", "<=");
    }

    protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        String operator = null;
        block0 : switch (wordParser.character()) {
            case '<': {
                switch (wordParser.character(wordParser.position() + 1)) {
                    case '=': {
                        operator = "<=";
                        break block0;
                    }
                    case '>': {
                        operator = "<>";
                        break block0;
                    }
                }
                operator = "<";
                break;
            }
            case '>': {
                switch (wordParser.character(wordParser.position() + 1)) {
                    case '=': {
                        operator = ">=";
                        break block0;
                    }
                }
                operator = ">";
                break;
            }
            case '=': {
                operator = "=";
            }
        }
        if (operator == null) {
            String[] stringArray = this.identifiers();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String identifier = stringArray[n2];
                if (wordParser.startsWith(identifier)) {
                    operator = identifier;
                    break;
                }
                ++n2;
            }
        }
        if (operator != null) {
            ComparisonExpression comparisonExpression = new ComparisonExpression(parent, operator);
            comparisonExpression.parse(wordParser, tolerant);
            if (expression != null) {
                comparisonExpression.setLeftExpression(expression);
            }
            return comparisonExpression;
        }
        return null;
    }
}

