/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateFunction
extends AbstractSingleEncapsulatedExpression {
    private String distinctIdentifier;
    private boolean hasSpaceAfterDistinct;

    protected AggregateFunction(AbstractExpression parent) {
        super(parent);
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        if (this.distinctIdentifier != null) {
            children.add(this.buildStringExpression("DISTINCT"));
        }
        if (this.hasSpaceAfterDistinct) {
            children.add(this.buildStringExpression(' '));
        }
        super.addOrderedEncapsulatedExpressionTo(children);
    }

    protected AbstractExpression buildEncapsulatedExpression(WordParser wordParser, String word) {
        return new StateFieldPathExpression((AbstractExpression)this, word);
    }

    @Override
    public String encapsulatedExpressionBNF() {
        return "internal_aggregate_function";
    }

    public String getActualDistinctIdentifier() {
        return this.distinctIdentifier != null ? this.distinctIdentifier : "";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("aggregate_expression");
    }

    public final boolean hasDistinct() {
        return this.distinctIdentifier != null;
    }

    public final boolean hasSpaceAfterDistinct() {
        return this.hasSpaceAfterDistinct;
    }

    @Override
    protected final void parseEncapsulatedExpression(WordParser wordParser, int whitespaceCount, boolean tolerant) {
        if (wordParser.startsWithIdentifier("DISTINCT")) {
            this.distinctIdentifier = wordParser.moveForward("DISTINCT");
            this.hasSpaceAfterDistinct = wordParser.skipLeadingWhitespace() > 0;
        }
        super.parseEncapsulatedExpression(wordParser, whitespaceCount, tolerant);
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        if (this.distinctIdentifier != null) {
            writer.append(actual ? this.distinctIdentifier : "DISTINCT");
        }
        if (this.hasSpaceAfterDistinct) {
            writer.append(' ');
        }
        super.toParsedTextEncapsulatedExpression(writer, actual);
    }
}

