/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectClause
extends AbstractExpression {
    private String distinctIdentifier;
    private boolean hasSpaceAfterDistinct;
    private boolean hasSpaceAfterSelect;
    private String identifier;
    private AbstractExpression selectExpression;

    protected AbstractSelectClause(AbstractExpression parent) {
        super(parent, "SELECT");
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getSelectExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getSelectExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("SELECT"));
        if (this.hasSpaceAfterSelect) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.distinctIdentifier != null) {
            children.add(this.buildStringExpression("DISTINCT"));
        }
        if (this.hasSpaceAfterDistinct) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.selectExpression != null) {
            children.add(this.selectExpression);
        }
    }

    public final String getActualDistinctIdentifier() {
        return this.distinctIdentifier;
    }

    public final String getActualIdentifier() {
        return this.identifier;
    }

    public final Expression getSelectExpression() {
        if (this.selectExpression == null) {
            this.selectExpression = this.buildNullExpression();
        }
        return this.selectExpression;
    }

    public final boolean hasDistinct() {
        return this.distinctIdentifier != null;
    }

    public final boolean hasSelectExpression() {
        return this.selectExpression != null && !this.selectExpression.isNull();
    }

    public final boolean hasSpaceAfterDistinct() {
        return this.hasSpaceAfterDistinct;
    }

    public final boolean hasSpaceAfterSelect() {
        return this.hasSpaceAfterSelect;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("SELECT");
        boolean bl = this.hasSpaceAfterSelect = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("DISTINCT")) {
            this.distinctIdentifier = wordParser.moveForward("DISTINCT");
            this.hasSpaceAfterDistinct = wordParser.skipLeadingWhitespace() > 0;
        }
        this.selectExpression = this.parse(wordParser, this.selectItemBNF(), tolerant);
    }

    public abstract String selectItemBNF();

    @Override
    protected boolean shouldSkipLiteral(AbstractExpression expression) {
        return false;
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : "SELECT");
        if (this.hasSpaceAfterSelect) {
            writer.append(' ');
        }
        if (this.distinctIdentifier != null) {
            writer.append(actual ? this.distinctIdentifier : "DISTINCT");
        }
        if (this.hasSpaceAfterDistinct) {
            writer.append(' ');
        }
        if (this.selectExpression != null) {
            this.selectExpression.toParsedText(writer, actual);
        }
    }
}

