/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.model.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.model.Problem;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractListHolderStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.AbstractSelectStatementStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.CollectionMemberDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.DeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.model.query.VariableDeclarationStateObject;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.util.CollectionTools;
import org.eclipse.persistence.jpa.jpql.util.iterable.ListIterable;
import org.eclipse.persistence.jpa.jpql.util.iterable.SnapshotCloneIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFromClauseStateObject
extends AbstractListHolderStateObject<VariableDeclarationStateObject>
implements DeclarationStateObject {
    public static final String VARIABLE_DECLARATIONS_LIST = "variableDeclarations";

    protected AbstractFromClauseStateObject(AbstractSelectStatementStateObject parent) {
        super(parent);
    }

    public CollectionMemberDeclarationStateObject addCollectionDeclaration() {
        CollectionMemberDeclarationStateObject stateObject = new CollectionMemberDeclarationStateObject(this);
        this.addItem(stateObject);
        return stateObject;
    }

    public CollectionMemberDeclarationStateObject addCollectionDeclaration(String collectionValuedPath, String identificationVariable) {
        CollectionMemberDeclarationStateObject stateObject = new CollectionMemberDeclarationStateObject(this);
        stateObject.setPath(collectionValuedPath);
        stateObject.setIdentificationVariable(identificationVariable);
        this.addItem(stateObject);
        return stateObject;
    }

    @Override
    protected void addProblems(List<Problem> currentProblems) {
        super.addProblems(currentProblems);
    }

    public IdentificationVariableDeclarationStateObject addRangeDeclaration() {
        IdentificationVariableDeclarationStateObject stateObject = new IdentificationVariableDeclarationStateObject(this);
        this.addItem(stateObject);
        return stateObject;
    }

    public IdentificationVariableDeclarationStateObject addRangeDeclaration(IEntity entity, String identificationVariable) {
        IdentificationVariableDeclarationStateObject stateObject = new IdentificationVariableDeclarationStateObject(this, entity, identificationVariable);
        this.addItem(stateObject);
        return stateObject;
    }

    public IdentificationVariableDeclarationStateObject addRangeDeclaration(String entityName, String identificationVariable) {
        IdentificationVariableDeclarationStateObject stateObject = new IdentificationVariableDeclarationStateObject(this, entityName, identificationVariable);
        this.addItem(stateObject);
        return stateObject;
    }

    protected abstract String declarationBNF();

    @Override
    public ListIterable<? extends VariableDeclarationStateObject> declarations() {
        return this.items();
    }

    @Override
    public IdentificationVariableStateObject findIdentificationVariable(String variable) {
        for (IdentificationVariableStateObject identificationVariable : this.identificationVariables()) {
            if (!ExpressionTools.stringsAreEqualIgnoreCase(identificationVariable.getText(), variable)) continue;
            return identificationVariable;
        }
        return null;
    }

    @Override
    public DeclarationStateObject getDeclaration() {
        return this;
    }

    @Override
    public AbstractFromClause getExpression() {
        return (AbstractFromClause)super.getExpression();
    }

    @Override
    public IManagedType getManagedType(StateObject stateObject) {
        for (VariableDeclarationStateObject variableDeclarationStateObject : this.declarations()) {
            IManagedType managedType = variableDeclarationStateObject.getManagedType(stateObject);
            if (managedType == null) continue;
            return managedType;
        }
        return null;
    }

    @Override
    public AbstractSelectStatementStateObject getParent() {
        return (AbstractSelectStatementStateObject)super.getParent();
    }

    public Iterable<IdentificationVariableStateObject> identificationVariables() {
        ArrayList stateObjects = new ArrayList();
        for (VariableDeclarationStateObject stateObject : this.items()) {
            CollectionTools.addAll(stateObjects, stateObject.identificationVariables());
        }
        return new SnapshotCloneIterable<IdentificationVariableStateObject>(stateObjects);
    }

    @Override
    public boolean isEquivalent(StateObject stateObject) {
        return super.isEquivalent(stateObject) && this.areChildrenEquivalent((AbstractListHolderStateObject)stateObject);
    }

    @Override
    protected String listName() {
        return VARIABLE_DECLARATIONS_LIST;
    }

    public void parse(String jpqlFragment) {
        this.buildStateObjects(jpqlFragment, this.declarationBNF());
    }

    @Override
    protected void toTextInternal(Appendable writer) throws IOException {
        writer.append("FROM");
        writer.append(' ');
        this.toStringItems(writer, true);
    }
}

