/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.rs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class MOXyJsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final String CHARSET = "charset";
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";
    @Context
    protected Providers providers;
    private String attributePrefix = null;
    private Map<Class<?>, javax.xml.bind.JAXBContext> contextCache = new HashMap();
    private boolean formattedOutput = false;
    private boolean includeRoot = false;
    private boolean marshalEmptyCollections = true;
    private Map<String, String> namespacePrefixMapper;
    private char namespaceSeperator = (char)46;
    private String valueWrapper;

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    protected Class<?> getDomainClass(Type genericType) {
        if (genericType instanceof Class && genericType != JAXBElement.class) {
            Class clazz = (Class)genericType;
            if (clazz.isArray()) {
                return this.getDomainClass(clazz.getComponentType());
            }
            return clazz;
        }
        if (genericType instanceof ParameterizedType) {
            Type type = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (type instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type).getRawType();
                if (rawType == JAXBElement.class) {
                    return this.getDomainClass(type);
                }
            } else if (type instanceof WildcardType) {
                Type upperType;
                Type[] upperTypes = ((WildcardType)type).getUpperBounds();
                if (upperTypes.length > 0 && (upperType = upperTypes[0]) instanceof Class) {
                    return (Class)upperType;
                }
            } else if (JAXBElement.class == type) {
                return Object.class;
            }
            return (Class)type;
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            return this.getDomainClass(genericArrayType.getGenericComponentType());
        }
        return Object.class;
    }

    protected javax.xml.bind.JAXBContext getJAXBContext(Class<?> domainClass, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, ?> httpHeaders) throws JAXBException {
        javax.xml.bind.JAXBContext jaxbContext = this.contextCache.get(domainClass);
        if (jaxbContext != null) {
            return jaxbContext;
        }
        ContextResolver resolver = this.providers.getContextResolver(javax.xml.bind.JAXBContext.class, mediaType);
        if (resolver == null || (jaxbContext = (javax.xml.bind.JAXBContext)resolver.getContext(domainClass)) == null) {
            jaxbContext = JAXBContextFactory.createContext(new Class[]{domainClass}, null);
            this.contextCache.put(domainClass, jaxbContext);
            return jaxbContext;
        }
        if (jaxbContext instanceof JAXBContext) {
            return jaxbContext;
        }
        jaxbContext = JAXBContextFactory.createContext(new Class[]{domainClass}, null);
        this.contextCache.put(domainClass, jaxbContext);
        return jaxbContext;
    }

    public Map<String, String> getNamespacePrefixMapper() {
        return this.namespacePrefixMapper;
    }

    public char getNamespaceSeparator() {
        return this.namespaceSeperator;
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public String getValueWrapper() {
        return this.valueWrapper;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public boolean isIncludeRoot() {
        return this.includeRoot;
    }

    public boolean isMarshalEmptyCollections() {
        return this.marshalEmptyCollections;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.supportsMediaType(mediaType)) {
            return false;
        }
        if (ClassConstants.APBYTE == type || ClassConstants.STRING == type) {
            return false;
        }
        if (File.class.isAssignableFrom(type)) {
            return false;
        }
        if (DataSource.class.isAssignableFrom(type)) {
            return false;
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return false;
        }
        return !Reader.class.isAssignableFrom(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.supportsMediaType(mediaType)) {
            return false;
        }
        if (ClassConstants.APBYTE == type || ClassConstants.STRING == type) {
            return false;
        }
        if (File.class.isAssignableFrom(type)) {
            return false;
        }
        if (DataSource.class.isAssignableFrom(type)) {
            return false;
        }
        return !StreamingOutput.class.isAssignableFrom(type);
    }

    protected void preReadFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, Unmarshaller unmarshaller) throws JAXBException {
    }

    protected void preWriteTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, Marshaller marshaller) throws JAXBException {
    }

    public final Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            StreamSource jsonSource;
            Class<?> domainClass = this.getDomainClass(genericType);
            javax.xml.bind.JAXBContext jaxbContext = this.getJAXBContext(domainClass, annotations, mediaType, httpHeaders);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            unmarshaller.setProperty("eclipselink.json.attribute-prefix", (Object)this.attributePrefix);
            unmarshaller.setProperty("eclipselink.json.include-root", (Object)this.includeRoot);
            unmarshaller.setProperty("eclipselink.namespace-prefix-mapper", this.namespacePrefixMapper);
            unmarshaller.setProperty("eclipselink.json.namespace-separator", (Object)Character.valueOf(this.namespaceSeperator));
            if (this.valueWrapper != null) {
                unmarshaller.setProperty("eclipselink.json.value-wrapper", (Object)this.valueWrapper);
            }
            this.preReadFrom(type, genericType, annotations, mediaType, httpHeaders, unmarshaller);
            Map mediaTypeParameters = mediaType.getParameters();
            if (mediaTypeParameters.containsKey(CHARSET)) {
                String charSet = (String)mediaTypeParameters.get(CHARSET);
                InputStreamReader entityReader = new InputStreamReader(entityStream, charSet);
                jsonSource = new StreamSource(entityReader);
            } else {
                jsonSource = new StreamSource(entityStream);
            }
            JAXBElement jaxbElement = unmarshaller.unmarshal((Source)jsonSource, domainClass);
            if (type.isAssignableFrom(JAXBElement.class)) {
                return jaxbElement;
            }
            Object value = jaxbElement.getValue();
            if (value instanceof ArrayList) {
                Type actualType;
                if (type.isArray()) {
                    Object array;
                    ArrayList arrayList = (ArrayList)value;
                    int arrayListSize = arrayList.size();
                    if (genericType instanceof GenericArrayType) {
                        array = Array.newInstance(JAXBElement.class, arrayListSize);
                        int x = 0;
                        while (x < arrayListSize) {
                            Array.set(array, x, arrayList.get(x));
                            ++x;
                        }
                    } else {
                        array = Array.newInstance(domainClass, arrayListSize);
                        int x = 0;
                        while (x < arrayListSize) {
                            Array.set(array, x, ((JAXBElement)arrayList.get(x)).getValue());
                            ++x;
                        }
                    }
                    return array;
                }
                CollectionContainerPolicy containerPolicy = type.isAssignableFrom(List.class) || type.isAssignableFrom(ArrayList.class) || type.isAssignableFrom(Collection.class) ? new CollectionContainerPolicy(ArrayList.class) : (type.isAssignableFrom(Set.class) ? new CollectionContainerPolicy(HashSet.class) : (type.isAssignableFrom(Deque.class) || type.isAssignableFrom(Queue.class) ? new CollectionContainerPolicy(LinkedList.class) : (type.isAssignableFrom(NavigableSet.class) || type.isAssignableFrom(SortedSet.class) ? new CollectionContainerPolicy(TreeSet.class) : new CollectionContainerPolicy(type))));
                Object container = containerPolicy.containerInstance();
                boolean wrapItemInJAXBElement = false;
                if (genericType instanceof ParameterizedType && (actualType = ((ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof ParameterizedType) {
                    Type rawType = ((ParameterizedType)actualType).getRawType();
                    wrapItemInJAXBElement = rawType == JAXBElement.class;
                }
                for (Object element : (Collection)value) {
                    if (wrapItemInJAXBElement) {
                        if (!(element instanceof JAXBElement)) {
                            element = new JAXBElement(new QName(""), domainClass, element);
                        }
                        containerPolicy.addInto(element, container, (AbstractSession)null);
                        continue;
                    }
                    containerPolicy.addInto(JAXBIntrospector.getValue(element), container, (AbstractSession)null);
                }
                return container;
            }
            return value;
        }
        catch (UnmarshalException unmarshalException) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            throw new WebApplicationException(builder.build());
        }
        catch (JAXBException jaxbException) {
            throw new WebApplicationException((Throwable)jaxbException);
        }
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public void setIncludeRoot(boolean includeRoot) {
        this.includeRoot = includeRoot;
    }

    public void setMarshalEmptyCollections(boolean marshalEmptyCollections) {
        this.marshalEmptyCollections = marshalEmptyCollections;
    }

    public void setNamespacePrefixMapper(Map<String, String> namespacePrefixMapper) {
        this.namespacePrefixMapper = namespacePrefixMapper;
    }

    public void setNamespaceSeparator(char namespaceSeparator) {
        this.namespaceSeperator = namespaceSeparator;
    }

    public void setValueWrapper(String valueWrapper) {
        this.valueWrapper = valueWrapper;
    }

    protected boolean supportsMediaType(MediaType mediaType) {
        String subtype = mediaType.getSubtype();
        return subtype.equals(JSON) || subtype.endsWith(PLUS_JSON);
    }

    public final void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            Class<?> domainClass = this.getDomainClass(genericType);
            javax.xml.bind.JAXBContext jaxbContext = this.getJAXBContext(domainClass, annotations, mediaType, httpHeaders);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)this.formattedOutput);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            marshaller.setProperty("eclipselink.json.attribute-prefix", (Object)this.attributePrefix);
            marshaller.setProperty("eclipselink.json.include-root", (Object)this.includeRoot);
            marshaller.setProperty("eclipselink.json.marshal-empty-collections", (Object)this.marshalEmptyCollections);
            marshaller.setProperty("eclipselink.json.namespace-separator", (Object)Character.valueOf(this.namespaceSeperator));
            if (this.valueWrapper != null) {
                marshaller.setProperty("eclipselink.json.value-wrapper", (Object)this.valueWrapper);
            }
            marshaller.setProperty("eclipselink.namespace-prefix-mapper", this.namespacePrefixMapper);
            Map mediaTypeParameters = mediaType.getParameters();
            if (mediaTypeParameters.containsKey(CHARSET)) {
                String charSet = (String)mediaTypeParameters.get(CHARSET);
                marshaller.setProperty("jaxb.encoding", (Object)charSet);
            }
            this.preWriteTo(object, type, genericType, annotations, mediaType, httpHeaders, marshaller);
            marshaller.marshal(object, entityStream);
        }
        catch (JAXBException jaxbException) {
            throw new WebApplicationException((Throwable)jaxbException);
        }
    }
}

