/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.HashMap;

public class AnnotationHelper {
    private HashMap<AnnotatedElement, HashMap<Class, Annotation>> allAnnotationsMap = new HashMap();

    public Annotation getAnnotation(AnnotatedElement elem, Class annotationClass) {
        if (this.allAnnotationsMap.get(elem) == null) {
            this.getAnnotationsFromElement(elem);
        }
        return this.allAnnotationsMap.get(elem).get(annotationClass);
    }

    public Annotation[] getAnnotations(AnnotatedElement elem) {
        if (this.allAnnotationsMap.get(elem) == null) {
            this.getAnnotationsFromElement(elem);
        }
        Collection<Annotation> annos = this.allAnnotationsMap.get(elem).values();
        return annos.toArray(new Annotation[annos.size()]);
    }

    public boolean isAnnotationPresent(AnnotatedElement elem, Class annotationClass) {
        if (this.allAnnotationsMap.get(elem) == null) {
            this.getAnnotationsFromElement(elem);
        }
        return this.allAnnotationsMap.get(elem).keySet().contains(annotationClass);
    }

    private void getAnnotationsFromElement(AnnotatedElement elem) {
        Annotation[] annotations;
        HashMap<Class<? extends Annotation>, Annotation> annotationsMap = new HashMap<Class<? extends Annotation>, Annotation>();
        Annotation[] annotationArray = annotations = elem.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            annotationsMap.put(annotation.annotationType(), annotation);
            ++n2;
        }
        this.allAnnotationsMap.put(elem, annotationsMap);
    }
}

