/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.IdentityMapAccessor;

public class RepeatableWriteUnitOfWork
extends UnitOfWorkImpl {
    protected UnitOfWorkChangeSet cumulativeUOWChangeSet;
    protected boolean shouldTerminateTransaction = true;
    protected boolean shouldStoreBypassCache;
    protected transient String flushClearCache;
    protected boolean isWithinFlush;
    protected transient Set<ClassDescriptor> classesToBeInvalidated;
    protected boolean discoverUnregisteredNewObjectsWithoutPersist;

    public RepeatableWriteUnitOfWork(AbstractSession parentSession, ReferenceMode referenceMode) {
        super(parentSession, referenceMode);
        this.shouldNewObjectsBeCached = true;
        this.isWithinFlush = false;
        this.discoverUnregisteredNewObjectsWithoutPersist = false;
    }

    public boolean shouldDiscoverUnregisteredNewObjectsWithoutPersist() {
        return this.discoverUnregisteredNewObjectsWithoutPersist;
    }

    public void setDiscoverUnregisteredNewObjectsWithoutPersist(boolean discoverUnregisteredNewObjectsWithoutPersist) {
        this.discoverUnregisteredNewObjectsWithoutPersist = discoverUnregisteredNewObjectsWithoutPersist;
    }

    @Override
    public void clear(boolean shouldClearCache) {
        super.clear(shouldClearCache);
        if (this.cumulativeUOWChangeSet != null) {
            if (this.flushClearCache == "Drop") {
                this.cumulativeUOWChangeSet = null;
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
            } else if (this.flushClearCache == "DropInvalidate") {
                Set<ClassDescriptor> updatedObjectsClasses = this.cumulativeUOWChangeSet.findUpdatedObjectsClasses();
                if (updatedObjectsClasses != null) {
                    if (this.classesToBeInvalidated == null) {
                        this.classesToBeInvalidated = updatedObjectsClasses;
                    } else {
                        this.classesToBeInvalidated.addAll(updatedObjectsClasses);
                    }
                }
                if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && !this.unregisteredDeletedObjectsCloneToBackupAndOriginal.isEmpty()) {
                    if (this.classesToBeInvalidated == null) {
                        this.classesToBeInvalidated = new HashSet<ClassDescriptor>();
                    }
                    Iterator enumDeleted = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.keySet().iterator();
                    while (enumDeleted.hasNext()) {
                        this.classesToBeInvalidated.add(this.getDescriptor(enumDeleted.next().getClass()));
                    }
                }
                this.cumulativeUOWChangeSet = null;
                this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
            }
        }
    }

    @Override
    public void clearForClose(boolean shouldClearCache) {
        this.cumulativeUOWChangeSet = null;
        this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
        super.clearForClose(shouldClearCache);
    }

    public Set<ClassDescriptor> getClassesToBeInvalidated() {
        return this.classesToBeInvalidated;
    }

    public UnitOfWorkChangeSet getCumulativeUOWChangeSet() {
        return this.cumulativeUOWChangeSet;
    }

    public void setCumulativeUOWChangeSet(UnitOfWorkChangeSet cumulativeUOWChangeSet) {
        this.cumulativeUOWChangeSet = cumulativeUOWChangeSet;
    }

    @Override
    public boolean shouldForceReadFromDB(ObjectBuildingQuery query, Object primaryKey) {
        if (this.wasTransactionBegunPrematurely() && query.getDescriptor() != null) {
            if (this.getFlushClearCache().equals("Merge") && this.getCumulativeUOWChangeSet() != null) {
                Map<ObjectChangeSet, ObjectChangeSet> changeSetMap = this.getCumulativeUOWChangeSet().getObjectChanges().get(query.getDescriptor().getJavaClass());
                Object lookupPrimaryKey = null;
                if (primaryKey == null && query.isReadObjectQuery()) {
                    lookupPrimaryKey = ((ReadObjectQuery)query).getSelectionId();
                }
                if (changeSetMap != null) {
                    if (lookupPrimaryKey == null) {
                        return true;
                    }
                    ObjectChangeSet lookupChangeSet = new ObjectChangeSet(lookupPrimaryKey, query.getDescriptor(), null, null, false);
                    if (changeSetMap.get(lookupChangeSet) != null) {
                        return true;
                    }
                }
            } else if (this.getFlushClearCache().equals("DropInvalidate") && this.getClassesToBeInvalidated() != null && this.getClassesToBeInvalidated().contains(query.getDescriptor())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldClearForCloseOnRelease() {
        return true;
    }

    @Override
    public boolean shouldStoreBypassCache() {
        return this.shouldStoreBypassCache;
    }

    @Override
    protected ClassDescriptor checkHierarchyForDescriptor(Class theClass) {
        ClassDescriptor descriptor = this.getDescriptor(theClass.getSuperclass());
        if (descriptor != null && descriptor.hasInheritance() && descriptor.getInheritancePolicy().getDescribesNonPersistentSubclasses()) {
            return descriptor;
        }
        return null;
    }

    @Override
    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithChangeSet(false);
        if (this.cumulativeUOWChangeSet != null) {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
        this.mergeChangesIntoParent();
    }

    @Override
    public void discoverUnregisteredNewObjects(Map clones, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects) {
        if (this.discoverUnregisteredNewObjectsWithoutPersist) {
            super.discoverUnregisteredNewObjects(clones, newObjects, unregisteredExistingObjects, visitedObjects);
        } else {
            HashSet cascadePersistErrors = new HashSet();
            Iterator clonesEnum = clones.keySet().iterator();
            while (clonesEnum.hasNext()) {
                this.discoverAndPersistUnregisteredNewObjects(clonesEnum.next(), false, newObjects, unregisteredExistingObjects, visitedObjects, cascadePersistErrors);
            }
            if (!cascadePersistErrors.isEmpty()) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("new_object_found_during_commit", cascadePersistErrors.toArray()));
            }
        }
    }

    @Override
    public boolean isAfterWriteChangesButBeforeCommit() {
        return this.getLifecycle() == 2;
    }

    @Override
    public boolean isObjectDeleted(Object object) {
        if (super.isObjectDeleted(object)) {
            return true;
        }
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && this.unregisteredDeletedObjectsCloneToBackupAndOriginal.containsKey(object)) {
            return true;
        }
        if (this.hasObjectsDeletedDuringCommit()) {
            return this.getObjectsDeletedDuringCommit().containsKey(object);
        }
        return false;
    }

    @Override
    public void issueSQLbeforeCompletion() {
        super.issueSQLbeforeCompletion(false);
        if (this.cumulativeUOWChangeSet != null) {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), this, true);
            this.setUnitOfWorkChangeSet(this.cumulativeUOWChangeSet);
        }
        this.commitTransactionAfterWriteChanges();
    }

    @Override
    protected void mergeChangesIntoParent() {
        if (this.classesToBeInvalidated != null) {
            for (ClassDescriptor classToBeInvalidated : this.classesToBeInvalidated) {
                IdentityMapAccessor accessor = this.getParentIdentityMapSession(classToBeInvalidated, false, true).getIdentityMapAccessor();
                accessor.invalidateClass(classToBeInvalidated.getJavaClass(), false);
            }
            this.classesToBeInvalidated = null;
        }
        super.mergeChangesIntoParent();
    }

    @Override
    public Object mergeCloneWithReferences(Object rmiClone, MergeManager manager) {
        Object mergedObject = super.mergeCloneWithReferences(rmiClone, manager);
        IdentityHashMap newObjects = manager.getMergedNewObjects();
        if (!newObjects.isEmpty()) {
            for (Object newObjectClone : newObjects.values()) {
                ClassDescriptor descriptor;
                if (this.assignSequenceNumber(newObjectClone, descriptor = this.getDescriptor(newObjectClone)) == null) continue;
                this.registerNewObjectInIdentityMap(newObjectClone, null, descriptor);
            }
        }
        return mergedObject;
    }

    @Override
    public void updateChangeTrackersIfRequired(Object objectToWrite, ObjectChangeSet changeSetToWrite, UnitOfWorkImpl uow, ClassDescriptor descriptor) {
        descriptor.getObjectChangePolicy().updateWithChanges(objectToWrite, changeSetToWrite, uow, descriptor);
    }

    @Override
    public void writeChanges() {
        boolean hasChanges;
        if (this.isWithinFlush()) {
            this.log(6, "transaction", "nested_entity_manager_flush_not_executed_pre_query_changes_may_be_pending", this.getClass().getSimpleName());
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_flush");
        this.isWithinFlush = true;
        UnitOfWorkChangeSet changeSet = this.unitOfWorkChangeSet;
        boolean bl = hasChanges = this.hasDeletedObjects() || this.hasModifyAllQueries() || this.hasDeferredModifyAllQueries();
        if (this.hasCloneMapping() || hasChanges) {
            if (this.unitOfWorkChangeSet == null) {
                changeSet = this.unitOfWorkChangeSet = new UnitOfWorkChangeSet(this);
            }
            this.calculateChanges(this.getCloneMapping(), changeSet, this.discoverUnregisteredNewObjectsWithoutPersist, true);
            hasChanges = hasChanges || changeSet.hasChanges() || changeSet.hasForcedChanges();
        }
        try {
            if (!hasChanges) {
                this.writesCompleted();
                this.log(2, "transaction", "end_unit_of_work_flush");
                return;
            }
            try {
                this.commitToDatabaseWithPreBuiltChangeSet(changeSet, false, false);
                this.writesCompleted();
            }
            catch (RuntimeException exception) {
                this.clearFlushClearCache();
                this.setLifecycle(3);
                throw exception;
            }
        }
        finally {
            this.isWithinFlush = false;
        }
        if (this.cumulativeUOWChangeSet == null) {
            this.cumulativeUOWChangeSet = changeSet;
        } else {
            this.cumulativeUOWChangeSet.mergeUnitOfWorkChangeSet(changeSet, this, true);
        }
        this.log(2, "transaction", "end_unit_of_work_flush");
        this.resumeUnitOfWork();
        this.log(2, "transaction", "resume_unit_of_work");
    }

    @Override
    public Object registerNewObject(Object newObject) {
        Object workingCopy = super.registerNewObject(newObject);
        if (!this.discoverUnregisteredNewObjectsWithoutPersist) {
            this.assignSequenceNumber(workingCopy);
        }
        return workingCopy;
    }

    @Override
    protected void registerNotRegisteredNewObjectForPersist(Object newObject, ClassDescriptor descriptor) {
        Object[] backupAndOriginal;
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null && (backupAndOriginal = (Object[])this.unregisteredDeletedObjectsCloneToBackupAndOriginal.remove(newObject)) != null) {
            this.getCloneMapping().put(newObject, backupAndOriginal[0]);
            this.registerNewObjectClone(newObject, backupAndOriginal[1], descriptor);
            this.registerNewObjectInIdentityMap(newObject, newObject, descriptor);
            return;
        }
        super.registerNotRegisteredNewObjectForPersist(newObject, descriptor);
    }

    @Override
    public void rollbackTransaction() throws DatabaseException {
        if (this.shouldTerminateTransaction || this.getParent().getTransactionMutex().isNested()) {
            super.rollbackTransaction();
        } else {
            this.setWasTransactionBegunPrematurely(true);
        }
    }

    @Override
    protected void rollbackTransaction(boolean intendedToCommitTransaction) throws DatabaseException {
        this.rollbackTransaction();
    }

    @Override
    public void synchronizeAndResume() {
        this.cumulativeUOWChangeSet = null;
        this.unregisteredDeletedObjectsCloneToBackupAndOriginal = null;
        super.synchronizeAndResume();
    }

    @Override
    public boolean wasDeleted(Object original) {
        return this.getUnregisteredDeletedCloneForOriginal(original) != null;
    }

    @Override
    protected Object cloneAndRegisterNewObject(Object original, boolean isShallowClone) {
        ClassDescriptor descriptor = this.getDescriptor(original);
        if (this.isNestedUnitOfWork() && descriptor.getObjectChangePolicy() instanceof AttributeChangeTrackingPolicy) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object clone = builder.instantiateWorkingCopyClone(original, this);
        Object newOriginal = original;
        this.getNewObjectsOriginalToClone().put(original, clone);
        this.getNewObjectsCloneToOriginal().put(clone, original);
        this.getNewObjectsCloneToMergeOriginal().put(clone, original);
        this.getCloneMapping().put(clone, clone);
        if (isShallowClone) {
            builder.copyInto(original, clone, true);
        } else {
            builder.populateAttributesForClone(original, null, clone, null, this);
        }
        if (!this.discoverUnregisteredNewObjectsWithoutPersist) {
            this.assignSequenceNumber(clone);
            newOriginal = builder.buildNewInstance();
        }
        this.registerNewObjectClone(clone, newOriginal, descriptor);
        Object backupClone = descriptor.getObjectChangePolicy().buildBackupClone(clone, builder, this);
        this.getCloneMapping().put(clone, backupClone);
        return clone;
    }

    public Object getUnregisteredDeletedCloneForOriginal(Object original) {
        if (this.unregisteredDeletedObjectsCloneToBackupAndOriginal != null) {
            Iterator keys = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.keySet().iterator();
            Iterator values = this.unregisteredDeletedObjectsCloneToBackupAndOriginal.values().iterator();
            while (keys.hasNext()) {
                Object deletedObjectClone = keys.next();
                Object[] backupAndOriginal = (Object[])values.next();
                Object currentOriginal = backupAndOriginal[1];
                if (original != currentOriginal) continue;
                return deletedObjectClone;
            }
        }
        return null;
    }

    @Override
    public void commitTransaction() throws DatabaseException {
        if (this.shouldTerminateTransaction || this.getParent().getTransactionMutex().isNested()) {
            super.commitTransaction();
        }
    }

    public void setShouldStoreByPassCache(boolean shouldStoreBypassCache) {
        this.shouldStoreBypassCache = shouldStoreBypassCache;
    }

    public void setShouldTerminateTransaction(boolean shouldTerminateTransaction) {
        this.shouldTerminateTransaction = shouldTerminateTransaction;
    }

    public void clearFlushClearCache() {
        this.classesToBeInvalidated = null;
    }

    public String getFlushClearCache() {
        return this.flushClearCache;
    }

    public void setFlushClearCache(String flushClearCache) {
        this.flushClearCache = flushClearCache;
    }

    public boolean isWithinFlush() {
        return this.isWithinFlush;
    }
}

