/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.deferred;

import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryAttachmentHandler;
import org.eclipse.persistence.internal.oxm.XMLInlineBinaryHandler;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.XMLConverterMapping;
import org.eclipse.persistence.internal.oxm.record.deferred.DeferredContentHandler;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.SAXException;

public class BinaryMappingContentHandler
extends DeferredContentHandler {
    private Mapping mapping;
    private NodeValue nodeValue;
    private XMLConverterMapping converter;
    private boolean isCollection;
    private UnmarshalRecord workingUnmarshalRecord;
    private boolean finished;

    public BinaryMappingContentHandler(UnmarshalRecord parentRecord, NodeValue nodeValue, BinaryDataMapping mapping) {
        super(parentRecord);
        this.mapping = mapping;
        this.converter = mapping;
        this.nodeValue = nodeValue;
        this.isCollection = false;
        this.finished = false;
    }

    public BinaryMappingContentHandler(UnmarshalRecord parentRecord, NodeValue nodeValue, BinaryDataCollectionMapping mapping) {
        super(parentRecord);
        this.mapping = mapping;
        this.converter = mapping;
        this.nodeValue = nodeValue;
        this.isCollection = true;
    }

    @Override
    public void processComplexElement() throws SAXException {
        this.getEvents().remove(0);
        this.workingUnmarshalRecord = new XMLBinaryAttachmentHandler(this.getParent(), this.nodeValue, this.mapping, this.converter, this.isCollection);
        this.executeEvents(this.workingUnmarshalRecord);
    }

    @Override
    public void processSimpleElement() throws SAXException {
        this.getEvents().remove(0);
        this.workingUnmarshalRecord = new XMLInlineBinaryHandler(this.getParent(), this.nodeValue, this.mapping, this.converter, this.isCollection);
        this.executeEvents(this.workingUnmarshalRecord);
    }

    @Override
    public void processEmptyElement() throws SAXException {
        this.processSimpleElement();
    }

    @Override
    protected void executeEvents(UnmarshalRecord unmarshalRecord) throws SAXException {
        super.executeEvents(unmarshalRecord);
        this.finished = true;
    }

    public UnmarshalRecord getWorkingUnmarshalRecord() {
        return this.workingUnmarshalRecord;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

