/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.record.DOMInputSource;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.namespaces.StackUnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;

public class DOMReader
extends XMLReaderAdapter {
    private Node currentNode;
    private DocumentPreservationPolicy docPresPolicy;

    public DOMReader() {
    }

    public DOMReader(XMLUnmarshaller xmlUnmarshaller) {
        super(xmlUnmarshaller);
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        if (input instanceof DOMInputSource) {
            Node node = ((DOMInputSource)input).getNode();
            if (this.contentHandler != null && this.contentHandler.getClass() == SAXUnmarshallerHandler.class) {
                ((SAXUnmarshallerHandler)this.contentHandler).setUnmarshalNamespaceResolver(new StackUnmarshalNamespaceResolver());
            }
            this.parse(node);
        }
    }

    public void parse(Node node, String newURI, String newName) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        Element rootNode = null;
        rootNode = node.getNodeType() == 9 ? ((Document)node).getDocumentElement() : (Element)node;
        this.processParentNamespaces(rootNode);
        this.startDocument();
        this.setupLocator(rootNode.getOwnerDocument());
        this.reportElementEvents(rootNode, newURI, newName);
        this.endDocument();
    }

    public void parse(Node node) throws SAXException {
        this.parse(node, null, null);
    }

    protected void processParentNamespaces(Element element) throws SAXException {
        Node parent = element.getParentNode();
        if (parent != null && parent.getNodeType() == 9) {
            return;
        }
        ArrayList<Node> parentElements = new ArrayList<Node>();
        while (parent != null && parent.getNodeType() != 9) {
            parentElements.add(parent);
            parent = parent.getParentNode();
        }
        Iterator stackIt = parentElements.iterator();
        while (stackIt.hasNext()) {
            NamedNodeMap attrs = ((Node)parentElements.remove(parentElements.size() - 1)).getAttributes();
            if (attrs == null) continue;
            int i = 0;
            int length = attrs.getLength();
            while (i < length) {
                Attr next = (Attr)attrs.item(i);
                String attrPrefix = next.getPrefix();
                if (attrPrefix != null && attrPrefix.equals("xmlns")) {
                    this.contentHandler.startPrefixMapping(next.getLocalName(), next.getValue());
                }
                ++i;
            }
        }
    }

    protected void reportElementEvents(Element elem) throws SAXException {
        this.reportElementEvents(elem, null, null);
    }

    protected void reportElementEvents(Element elem, String newUri, String newName) throws SAXException {
        this.currentNode = elem;
        IndexedAttributeList attributes = this.buildAttributeList(elem);
        String namespaceUri = null;
        String qname = null;
        String lname = null;
        if (newName == null) {
            lname = elem.getLocalName();
            if (lname == null) {
                qname = lname = elem.getNodeName();
                this.handlePrefixedAttribute(elem);
            } else {
                qname = this.getQName(elem);
            }
            namespaceUri = elem.getNamespaceURI();
            if (namespaceUri == null) {
                namespaceUri = "";
            }
        } else {
            namespaceUri = newUri;
            lname = newName;
            qname = newName;
            if (namespaceUri != null && this.isNamespaceAware()) {
                NamespaceResolver tmpNR = new NamespaceResolver();
                tmpNR.setDOM(elem);
                String prefix = tmpNR.resolveNamespaceURI(namespaceUri);
                if (prefix == null || prefix.length() == 0) {
                    String defaultNamespace = elem.getAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
                    if (defaultNamespace == null) {
                        prefix = tmpNR.generatePrefix();
                        this.contentHandler.startPrefixMapping(prefix, namespaceUri);
                    } else if (defaultNamespace != namespaceUri) {
                        prefix = tmpNR.generatePrefix();
                        this.contentHandler.startPrefixMapping(prefix, namespaceUri);
                    } else {
                        prefix = "";
                    }
                }
                if (prefix != null && prefix.length() > 0) {
                    qname = String.valueOf(prefix) + ':' + qname;
                }
            }
        }
        this.contentHandler.startElement(namespaceUri, lname, qname, attributes);
        this.handleChildNodes(elem.getChildNodes());
        this.contentHandler.endElement(namespaceUri, lname, qname);
        this.endPrefixMappings(elem);
    }

    protected IndexedAttributeList buildAttributeList(Element elem) throws SAXException {
        IndexedAttributeList attributes = new IndexedAttributeList();
        NamedNodeMap attrs = elem.getAttributes();
        int i = 0;
        int length = attrs.getLength();
        while (i < length) {
            Attr next = (Attr)attrs.item(i);
            String attrPrefix = next.getPrefix();
            if (attrPrefix != null && attrPrefix.equals("xmlns")) {
                this.contentHandler.startPrefixMapping(next.getLocalName(), next.getValue());
                this.handleXMLNSPrefixedAttribute(elem, next);
            } else if (attrPrefix == null) {
                String name = next.getLocalName();
                if (name == null) {
                    name = next.getNodeName();
                }
                if (name != null && name.equals("xmlns")) {
                    this.contentHandler.startPrefixMapping("", next.getValue());
                }
            }
            if (next.getNamespaceURI() != null && next.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && next.getLocalName().equals("type")) {
                this.handleXsiTypeAttribute(next);
            }
            attributes.addAttribute(next);
            ++i;
        }
        return attributes;
    }

    protected void endPrefixMappings(Element elem) throws SAXException {
        NamedNodeMap attrs = elem.getAttributes();
        int i = 0;
        int numOfAtts = attrs.getLength();
        while (i < numOfAtts) {
            Attr next = (Attr)attrs.item(i);
            String attrPrefix = next.getPrefix();
            if (attrPrefix != null && attrPrefix.equals("xmlns")) {
                this.contentHandler.endPrefixMapping(next.getLocalName());
            } else if (attrPrefix == null) {
                String name = next.getLocalName();
                if (name == null) {
                    name = next.getNodeName();
                }
                if ("xmlns".equals(name)) {
                    this.contentHandler.endPrefixMapping("");
                }
            }
            ++i;
        }
    }

    protected String getQName(Element elem) throws SAXException {
        this.handlePrefixedAttribute(elem);
        String prefix = elem.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            String qname = String.valueOf(prefix) + ':' + elem.getLocalName();
            return qname;
        }
        return elem.getLocalName();
    }

    protected void handleXMLNSPrefixedAttribute(Element elem, Attr attr) {
    }

    protected void handleXsiTypeAttribute(Attr attr) throws SAXException {
    }

    protected void handlePrefixedAttribute(Element elem) throws SAXException {
    }

    protected void handleChildNodes(NodeList children) throws SAXException {
        Node nextChild = null;
        if (children.getLength() > 0) {
            nextChild = children.item(0);
        }
        while (nextChild != null) {
            char[] value;
            if (nextChild.getNodeType() == 3) {
                value = ((Text)nextChild).getNodeValue().toCharArray();
                this.contentHandler.characters(value, 0, value.length);
            } else if (nextChild.getNodeType() == 8) {
                value = ((Comment)nextChild).getNodeValue().toCharArray();
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.comment(value, 0, value.length);
                }
            } else if (nextChild.getNodeType() == 1) {
                Element childElement = (Element)nextChild;
                this.reportElementEvents(childElement);
            } else if (nextChild.getNodeType() == 4) {
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.startCDATA();
                }
                value = ((CDATASection)nextChild).getData().toCharArray();
                this.contentHandler.characters(value, 0, value.length);
                if (this.lexicalHandler != null) {
                    this.lexicalHandler.endCDATA();
                }
            }
            nextChild = nextChild.getNextSibling();
        }
    }

    protected void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    protected void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    @Override
    public void newObjectEvent(Object object, Object parent, Mapping selfRecordMapping) {
        this.docPresPolicy.addObjectToCache(object, this.currentNode, selfRecordMapping);
    }

    @Override
    public Object getCurrentObject(CoreAbstractSession session, Mapping selfRecordMapping) {
        if (session == null && this.docPresPolicy == null) {
            return null;
        }
        if (this.docPresPolicy == null) {
            XMLLogin login = (XMLLogin)session.getDatasourceLogin();
            this.docPresPolicy = login.getDocumentPreservationPolicy();
        }
        return this.docPresPolicy.getObjectForNode(this.currentNode, selfRecordMapping);
    }

    public DocumentPreservationPolicy getDocPresPolicy() {
        return this.docPresPolicy;
    }

    public void setDocPresPolicy(DocumentPreservationPolicy policy) {
        this.docPresPolicy = policy;
    }

    protected void setupLocator(Document doc) {
        LocatorImpl locator = new LocatorImpl();
        try {
            Method getEncoding = PrivilegedAccessHelper.getMethod(doc.getClass(), "getXmlEncoding", new Class[0], true);
            Method getVersion = PrivilegedAccessHelper.getMethod(doc.getClass(), "getXmlVersion", new Class[0], true);
            String encoding = (String)PrivilegedAccessHelper.invokeMethod(getEncoding, doc, new Object[0]);
            String version = (String)PrivilegedAccessHelper.invokeMethod(getVersion, doc, new Object[0]);
            locator.setEncoding(encoding);
            locator.setXMLVersion(version);
        }
        catch (Exception exception) {
            return;
        }
        this.contentHandler.setDocumentLocator(locator);
    }

    protected class IndexedAttributeList
    implements Attributes {
        private List<Attr> attrs = new ArrayList<Attr>();

        public void addAttribute(Attr attribute) {
            this.attrs.add(attribute);
        }

        @Override
        public String getQName(int index) {
            try {
                Attr item = this.attrs.get(index);
                if (item.getName() != null) {
                    return item.getName();
                }
                return "";
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }

        @Override
        public String getType(String namespaceUri, String localName) {
            return "CDATA";
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getType(String qname) {
            return "CDATA";
        }

        @Override
        public int getIndex(String qname) {
            int i = 0;
            int size = this.attrs.size();
            while (i < size) {
                if (this.attrs.get(i).getName().equals(qname)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getIndex(String uri, String localName) {
            int i = 0;
            int size = this.attrs.size();
            while (i < size) {
                Attr item = this.attrs.get(i);
                try {
                    if (item.getNamespaceURI().equals(uri) && item.getLocalName().equals(localName)) {
                        return i;
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            return -1;
        }

        @Override
        public int getLength() {
            return this.attrs.size();
        }

        @Override
        public String getLocalName(int index) {
            try {
                Attr item = this.attrs.get(index);
                if (item.getLocalName() != null) {
                    return item.getLocalName();
                }
                return item.getName();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return null;
            }
        }

        @Override
        public String getURI(int index) {
            String uri = this.attrs.get(index).getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            return uri;
        }

        @Override
        public String getValue(int index) {
            return this.attrs.get(index).getValue();
        }

        @Override
        public String getValue(String qname) {
            int i = 0;
            int size = this.attrs.size();
            while (i < size) {
                Attr item = this.attrs.get(i);
                if (item.getName().equals(qname)) {
                    return item.getValue();
                }
                ++i;
            }
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            int i = 0;
            int size = this.attrs.size();
            while (i < size) {
                Attr item = this.attrs.get(i);
                if (item != null) {
                    String itemName;
                    String itemNS = item.getNamespaceURI();
                    if (item.getNamespaceURI() == null) {
                        itemNS = "";
                    }
                    if ((itemName = item.getLocalName()) == null) {
                        itemName = item.getNodeName();
                    }
                    if (itemNS.equals(uri) && itemName != null && itemName.equals(localName)) {
                        return item.getValue();
                    }
                }
                ++i;
            }
            return null;
        }
    }

    protected class LocatorImpl
    implements Locator2 {
        private String encoding = "UTF-8";
        private String version = "1.0";

        @Override
        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public int getColumnNumber() {
            return 0;
        }

        @Override
        public String getSystemId() {
            return "";
        }

        @Override
        public String getPublicId() {
            return "";
        }

        @Override
        public String getXMLVersion() {
            return this.version;
        }

        @Override
        public int getLineNumber() {
            return 0;
        }

        protected void setEncoding(String enc) {
            this.encoding = enc;
        }

        protected void setXMLVersion(String xmlVersion) {
            this.version = xmlVersion;
        }
    }
}

