/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.Namespace;
import org.eclipse.persistence.internal.oxm.WeakObjectWrapper;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.MediaType;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLObjectBuilder
extends ObjectBuilder {
    private Boolean isXMLDescriptor;
    private boolean xsiTypeIndicatorField;

    public XMLObjectBuilder(ClassDescriptor descriptor) {
        super(descriptor);
    }

    public AbstractRecord buildRow(Object object, AbstractSession session, DatabaseField xmlField, XMLRecord parentRecord) {
        if (this.isXmlDescriptor() && ((XMLDescriptor)this.getDescriptor()).shouldPreserveDocument()) {
            CacheKey cacheKey;
            Object pk = this.extractPrimaryKeyFromObject(object, session);
            if (pk == null || pk instanceof CacheId && ((CacheId)pk).getPrimaryKey().length == 0) {
                pk = new CacheId(new Object[]{new WeakObjectWrapper(object)});
            }
            if ((cacheKey = session.getIdentityMapAccessorInstance().getCacheKeyForObject(pk, this.getDescriptor().getJavaClass(), this.getDescriptor(), false)) != null && cacheKey.getRecord() != null) {
                XMLRecord nestedRecord = (XMLRecord)cacheKey.getRecord();
                nestedRecord.setMarshaller(parentRecord.getMarshaller());
                nestedRecord.setLeafElementType(parentRecord.getLeafElementType());
                parentRecord.setLeafElementType((XPathQName)null);
                return this.buildIntoNestedRow(nestedRecord, object, session);
            }
        }
        Element newNode = XPathEngine.getInstance().createUnownedElement(parentRecord.getDOM(), (XMLField)xmlField);
        DOMRecord nestedRecord = new DOMRecord(newNode);
        nestedRecord.setNamespaceResolver(parentRecord.getNamespaceResolver());
        nestedRecord.setMarshaller(parentRecord.getMarshaller());
        nestedRecord.setLeafElementType(parentRecord.getLeafElementType());
        parentRecord.setLeafElementType((XPathQName)null);
        return this.buildIntoNestedRow(nestedRecord, object, session);
    }

    @Override
    public AbstractRecord createRecord(AbstractSession session) {
        return this.createRecord(this.getDescriptor().getTableName(), session);
    }

    @Override
    public AbstractRecord createRecord(int size, AbstractSession session) {
        return this.createRecord(this.getDescriptor().getTableName(), session);
    }

    public AbstractRecord createRecord(String rootName, AbstractSession session) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord xmlRec = new DOMRecord(rootName, namespaceResolver);
        ((XMLRecord)xmlRec).setSession(session);
        return xmlRec;
    }

    public AbstractRecord createRecord(String rootName, String rootUri, AbstractSession session) {
        DOMRecord xmlRec = new DOMRecord(rootName, rootUri);
        ((XMLRecord)xmlRec).setSession(session);
        return xmlRec;
    }

    public AbstractRecord createRecord(String rootName, Node parent, AbstractSession session) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord xmlRec = new DOMRecord(rootName, namespaceResolver, parent);
        ((XMLRecord)xmlRec).setSession(session);
        return xmlRec;
    }

    public AbstractRecord createRecordFor(Object attributeValue, XMLField xmlField, XMLRecord parentRecord, XMLMapping mapping) {
        DocumentPreservationPolicy policy = parentRecord.getDocPresPolicy();
        Element newNode = null;
        if (policy != null) {
            newNode = (Element)policy.getNodeForObject(attributeValue);
        }
        if (newNode == null) {
            newNode = XPathEngine.getInstance().createUnownedElement(parentRecord.getDOM(), xmlField);
            if (xmlField.isSelfField()) {
                policy.addObjectToCache(attributeValue, (Node)newNode, mapping);
            } else {
                policy.addObjectToCache(attributeValue, newNode);
            }
        }
        DOMRecord nestedRecord = new DOMRecord(newNode);
        nestedRecord.setMarshaller(parentRecord.getMarshaller());
        nestedRecord.setLeafElementType(parentRecord.getLeafElementType());
        parentRecord.setLeafElementType((XPathQName)null);
        nestedRecord.setDocPresPolicy(policy);
        nestedRecord.setXOPPackage(parentRecord.isXOPPackage());
        nestedRecord.setReferenceResolver(((DOMRecord)parentRecord).getReferenceResolver());
        return nestedRecord;
    }

    public AbstractRecord createRecordFor(Object object, DocumentPreservationPolicy docPresPolicy) {
        Element cachedNode = null;
        DOMRecord record = null;
        if (docPresPolicy != null) {
            cachedNode = (Element)docPresPolicy.getNodeForObject(object);
        }
        if (cachedNode == null) {
            record = new DOMRecord(this.getDescriptor().getTableName(), this.getNamespaceResolver());
            docPresPolicy.addObjectToCache(object, ((XMLRecord)record).getDOM());
        } else {
            record = new DOMRecord(cachedNode);
        }
        record.setDocPresPolicy(docPresPolicy);
        return record;
    }

    public AbstractRecord createRecordFor(Object object, DocumentPreservationPolicy docPresPolicy, String rootName, String rootUri) {
        Element cachedNode = null;
        DOMRecord record = null;
        if (docPresPolicy != null) {
            cachedNode = (Element)docPresPolicy.getNodeForObject(object);
        }
        if (cachedNode == null) {
            record = new DOMRecord(rootName, rootUri);
            docPresPolicy.addObjectToCache(object, ((XMLRecord)record).getDOM());
        } else {
            record = new DOMRecord(cachedNode);
        }
        record.setDocPresPolicy(docPresPolicy);
        return record;
    }

    @Override
    protected AbstractRecord createRecordForPKExtraction(int size, AbstractSession session) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        DOMRecord xmlRec = new DOMRecord(this.getDescriptor().getTableName(), namespaceResolver);
        ((XMLRecord)xmlRec).setSession(session);
        return xmlRec;
    }

    @Override
    public Object buildObject(ObjectBuildingQuery query, AbstractRecord databaseRow, JoinedAttributeManager joinManager) throws DatabaseException, QueryException {
        DocumentPreservationPolicy docPresPolicy;
        Object pk;
        XMLRecord row = (XMLRecord)databaseRow;
        row.setSession(query.getSession());
        XMLUnmarshaller unmarshaller = row.getUnmarshaller();
        Object parent = row.getOwningObject();
        if (!this.isXmlDescriptor() && !this.getDescriptor().isDescriptorTypeAggregate()) {
            return super.buildObject(query, databaseRow, joinManager);
        }
        query.getSession().startOperationProfile("Timer:ObjectBuilding", query, Integer.MAX_VALUE);
        ClassDescriptor concreteDescriptor = this.getDescriptor();
        Object domainObject = null;
        if (concreteDescriptor.hasInheritance() && parent == null) {
            QName leafElementType;
            InheritancePolicy inheritancePolicy = concreteDescriptor.getInheritancePolicy();
            Class classValue = inheritancePolicy.classFromRow(databaseRow, query.getSession());
            if (classValue == null && this.isXmlDescriptor() && (leafElementType = ((XMLDescriptor)concreteDescriptor).getDefaultRootElementType()) != null) {
                XPathQName xpathQName = new XPathQName(leafElementType, row.isNamespaceAware());
                Object indicator = inheritancePolicy.getClassIndicatorMapping().get(xpathQName);
                if (indicator != null) {
                    classValue = (Class)indicator;
                }
            }
            if (classValue != null) {
                concreteDescriptor = query.getSession().getDescriptor(classValue);
                if (concreteDescriptor == null && query.hasPartialAttributeExpressions()) {
                    concreteDescriptor = this.getDescriptor();
                }
                if (concreteDescriptor == null) {
                    throw QueryException.noDescriptorForClassFromInheritancePolicy(query, classValue);
                }
            } else if (Modifier.isAbstract(concreteDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(databaseRow, inheritancePolicy.getDescriptor());
            }
        }
        domainObject = concreteDescriptor.getObjectBuilder().buildNewInstance();
        row.setCurrentObject(domainObject);
        if (unmarshaller != null && unmarshaller.getUnmarshalListener() != null) {
            unmarshaller.getUnmarshalListener().beforeUnmarshal(domainObject, parent);
        }
        concreteDescriptor.getObjectBuilder().buildAttributesIntoObject(domainObject, null, databaseRow, query, joinManager, false, query.getSession());
        if (this.isXmlDescriptor() && ((XMLDescriptor)concreteDescriptor).getPrimaryKeyFieldNames().size() > 0 && (pk = this.extractPrimaryKeyFromRow(databaseRow, query.getSession())) != null && ((CacheId)pk).getPrimaryKey().length > 0) {
            DOMRecord domRecord = (DOMRecord)databaseRow;
            domRecord.getReferenceResolver().putValue(concreteDescriptor.getJavaClass(), pk, domainObject);
        }
        if ((docPresPolicy = ((DOMRecord)row).getDocPresPolicy()) != null) {
            ((DOMRecord)row).getDocPresPolicy().addObjectToCache(domainObject, ((DOMRecord)row).getDOM());
        }
        query.getSession().endOperationProfile("Timer:ObjectBuilding", query, Integer.MAX_VALUE);
        if (unmarshaller != null && unmarshaller.getUnmarshalListener() != null) {
            unmarshaller.getUnmarshalListener().afterUnmarshal(domainObject, parent);
        }
        return domainObject;
    }

    public AbstractRecord buildRow(AbstractRecord databaseRow, Object object, AbstractSession session) {
        return this.buildRow(databaseRow, object, session, false);
    }

    public AbstractRecord buildRow(AbstractRecord databaseRow, Object object, AbstractSession session, boolean wasXMLRoot) {
        XMLRecord row = (XMLRecord)databaseRow;
        row.setSession(session);
        XMLMarshaller marshaller = row.getMarshaller();
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().beforeMarshal(object);
        }
        this.addNamespaceDeclarations(row.getDocument());
        this.writeOutMappings(row, object, session);
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(row);
        }
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().afterMarshal(object);
        }
        return row;
    }

    public void writeOutMappings(XMLRecord row, Object object, AbstractSession session) {
        Vector<DatabaseMapping> mappings = this.getDescriptor().getMappings();
        int index = 0;
        while (index < mappings.size()) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(index);
            mapping.writeFromObjectIntoRow(object, row, session, DatabaseMapping.WriteType.UNDEFINED);
            ++index;
        }
    }

    public void addNamespaceDeclarations(Document document) {
        NamespaceResolver namespaceResolver = this.getNamespaceResolver();
        if (namespaceResolver == null) {
            return;
        }
        Element docElement = document.getDocumentElement();
        if (namespaceResolver.getDefaultNamespaceURI() != null) {
            docElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceResolver.getDefaultNamespaceURI());
        }
        Enumeration prefixes = namespaceResolver.getPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            String namespace = namespaceResolver.resolveNamespacePrefix(prefix);
            docElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        }
    }

    @Override
    public void buildAttributesIntoObject(Object domainObject, CacheKey cacheKey, AbstractRecord databaseRow, ObjectBuildingQuery query, JoinedAttributeManager joinManager, boolean forRefresh, AbstractSession targetSession) throws DatabaseException {
        ((XMLRecord)databaseRow).setSession(query.getSession().getExecutionSession(query));
        super.buildAttributesIntoObject(domainObject, cacheKey, databaseRow, query, joinManager, forRefresh, targetSession);
    }

    @Override
    public AbstractRecord extractPrimaryKeyRowFromExpression(Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(true, this.getDescriptor(), primaryKeyRow, translationRow);
        if (!isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return primaryKeyRow;
    }

    @Override
    public Object extractPrimaryKeyFromExpression(boolean requiresExactMatch, Expression expression, AbstractRecord translationRow, AbstractSession session) {
        AbstractRecord primaryKeyRow = this.createRecord(this.getPrimaryKeyMappings().size(), session);
        expression.getBuilder().setSession(session.getRootSession(null));
        boolean isValid = expression.extractPrimaryKeyValues(requiresExactMatch, this.getDescriptor(), primaryKeyRow, translationRow);
        if (requiresExactMatch && !isValid) {
            return null;
        }
        if (primaryKeyRow.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            return null;
        }
        return this.extractPrimaryKeyFromRow(primaryKeyRow, session);
    }

    @Override
    public Object extractPrimaryKeyFromObject(Object domainObject, AbstractSession session) {
        if (this.getDescriptor().hasInheritance() && domainObject.getClass() != this.getDescriptor().getJavaClass() && !domainObject.getClass().getSuperclass().equals(this.getDescriptor().getJavaClass())) {
            return session.getDescriptor(domainObject.getClass()).getObjectBuilder().extractPrimaryKeyFromObject(domainObject, session);
        }
        List<DatabaseField> descriptorPrimaryKeyFields = this.getDescriptor().getPrimaryKeyFields();
        if (descriptorPrimaryKeyFields == null || descriptorPrimaryKeyFields.size() == 0) {
            return null;
        }
        return super.extractPrimaryKeyFromObject(domainObject, session);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord row, Object object, AbstractSession session) {
        return this.buildIntoNestedRow(row, null, object, session, null, null, false);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord row, Object object, AbstractSession session, XMLDescriptor refDesc, XMLField xmlField) {
        return this.buildIntoNestedRow(row, null, object, session, refDesc, xmlField, false);
    }

    public AbstractRecord buildIntoNestedRow(AbstractRecord row, Object originalObject, Object object, AbstractSession session, XMLDescriptor refDesc, XMLField xmlField, boolean wasXMLRoot) {
        XMLRecord record = (XMLRecord)row;
        record.setSession(session);
        XMLMarshaller marshaller = record.getMarshaller();
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().beforeMarshal(object);
        }
        List extraNamespaces = null;
        if (this.isXmlDescriptor()) {
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.getDescriptor();
            extraNamespaces = this.addExtraNamespacesToNamespaceResolver(xmlDescriptor, record, session, false, false);
            this.writeExtraNamespaces(extraNamespaces, record);
            this.addXsiTypeAndClassIndicatorIfRequired(record, xmlDescriptor, refDesc, xmlField, originalObject, object, wasXMLRoot, false);
        }
        this.writeOutMappings(record, object, session);
        if (this.isXmlDescriptor()) {
            XMLDescriptor cfr_ignored_0 = (XMLDescriptor)this.getDescriptor();
            this.removeExtraNamespacesFromNamespaceResolver(record, extraNamespaces, session);
        }
        if (!this.getDescriptor().isAggregateDescriptor()) {
            this.addPrimaryKeyForNonDefaultTable(row);
        }
        if (marshaller != null && marshaller.getMarshalListener() != null) {
            marshaller.getMarshalListener().afterMarshal(object);
        }
        return row;
    }

    protected void writeXsiTypeAttribute(XMLDescriptor xmlDescriptor, XMLRecord row, XMLSchemaReference xmlRef, boolean addToNamespaceResolver) {
        QName contextAsQName = xmlRef.getSchemaContextAsQName();
        if (contextAsQName == null) {
            contextAsQName = xmlRef.getSchemaContextAsQName(row.getNamespaceResolver());
        }
        if (contextAsQName != null) {
            this.writeXsiTypeAttribute(xmlDescriptor, row, contextAsQName.getNamespaceURI(), contextAsQName.getLocalPart(), null, addToNamespaceResolver);
        }
    }

    protected void writeXsiTypeAttribute(XMLDescriptor xmlDescriptor, XMLRecord row, String typeUri, String typeLocal, String typePrefix, boolean addToNamespaceResolver) {
        NamespaceResolver nr;
        if (typeLocal == null) {
            return;
        }
        String typeValue = typeLocal;
        if (row.isNamespaceAware() && typeUri != null && !typeUri.equals("") && !typeUri.equals(row.getNamespaceResolver().getDefaultNamespaceURI())) {
            String prefix = row.getNamespaceResolver().resolveNamespaceURI(typeUri);
            if (prefix != null && !prefix.equals("")) {
                typeValue = String.valueOf(prefix) + row.getNamespaceSeparator() + typeValue;
            } else if (typeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                prefix = row.getNamespaceResolver().generatePrefix("xsd");
                typeValue = String.valueOf(prefix) + row.getNamespaceSeparator() + typeValue;
                row.namespaceDeclaration(prefix, typeUri);
            } else if (typePrefix != null && !typePrefix.equals("")) {
                String existingUri = row.getNamespaceResolver().resolveNamespacePrefix(typePrefix);
                prefix = existingUri != null ? row.getNamespaceResolver().generatePrefix() : typePrefix;
                typeValue = String.valueOf(prefix) + row.getNamespaceSeparator() + typeValue;
                row.namespaceDeclaration(prefix, typeUri);
            } else {
                prefix = row.getNamespaceResolver().generatePrefix();
                typeValue = String.valueOf(prefix) + row.getNamespaceSeparator() + typeValue;
                row.namespaceDeclaration(prefix, typeUri);
            }
        }
        String xsiPrefix = null;
        if (row.isNamespaceAware() && (xsiPrefix = (nr = row.getNamespaceResolver()).resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance")) == null) {
            xsiPrefix = nr.generatePrefix("xsi");
            row.namespaceDeclaration(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            if (addToNamespaceResolver) {
                nr.put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        row.attributeWithoutQName("http://www.w3.org/2001/XMLSchema-instance", "type", xsiPrefix, typeValue);
    }

    public NamespaceResolver getNamespaceResolver() {
        NamespaceResolver namespaceResolver = null;
        if (this.isXmlDescriptor()) {
            namespaceResolver = ((XMLDescriptor)this.getDescriptor()).getNamespaceResolver();
        } else if (this.getDescriptor() instanceof EISDescriptor) {
            namespaceResolver = ((EISDescriptor)this.getDescriptor()).getNamespaceResolver();
        }
        return namespaceResolver;
    }

    protected boolean isXmlDescriptor() {
        if (this.isXMLDescriptor == null) {
            this.isXMLDescriptor = this.getDescriptor() instanceof XMLDescriptor;
        }
        return this.isXMLDescriptor;
    }

    @Override
    public void setDescriptor(ClassDescriptor aDescriptor) {
        super.setDescriptor(aDescriptor);
        this.isXMLDescriptor = null;
    }

    protected List addExtraNamespacesToNamespaceResolver(XMLDescriptor desc, XMLRecord marshalRecord, CoreAbstractSession session, boolean allowOverride, boolean ignoreEqualResolvers) {
        if (marshalRecord.hasEqualNamespaceResolvers() && !ignoreEqualResolvers) {
            return null;
        }
        NamespaceResolver descriptorNamespaceResolver = desc.getNamespaceResolver();
        if (descriptorNamespaceResolver == null || !descriptorNamespaceResolver.hasPrefixesToNamespaces()) {
            return null;
        }
        Map<String, String> prefixesToNamespaces = descriptorNamespaceResolver.getPrefixesToNamespaces();
        if (prefixesToNamespaces.size() == 0) {
            return null;
        }
        ArrayList<Namespace> returnList = new ArrayList<Namespace>(prefixesToNamespaces.size());
        NamespaceResolver marshalRecordNamespaceResolver = marshalRecord.getNamespaceResolver();
        for (Map.Entry<String, String> entry : prefixesToNamespaces.entrySet()) {
            String prefix = marshalRecordNamespaceResolver.resolveNamespaceURI(entry.getValue());
            if (prefix == null || prefix.length() == 0) {
                String newPrefix;
                prefix = entry.getKey();
                if (marshalRecord.hasCustomNamespaceMapper() && (newPrefix = marshalRecord.getMarshaller().getNamespacePrefixMapper().getPreferredPrefix(entry.getValue(), prefix, true)) != null && newPrefix.length() != 0) {
                    prefix = newPrefix;
                }
                String uri = marshalRecordNamespaceResolver.resolveNamespacePrefix(prefix);
                if (!marshalRecord.hasCustomNamespaceMapper() && !allowOverride && uri != null && uri.length() != 0) continue;
                marshalRecordNamespaceResolver.put(entry.getKey(), entry.getValue());
                returnList.add(new Namespace(prefix, entry.getValue()));
                continue;
            }
            if (!allowOverride || prefix.equals(entry.getKey()) || marshalRecord.hasCustomNamespaceMapper()) continue;
            marshalRecordNamespaceResolver.put(entry.getKey(), entry.getValue());
            returnList.add(new Namespace(entry.getKey(), entry.getValue()));
        }
        return returnList;
    }

    public void writeExtraNamespaces(List extraNamespaces, XMLRecord xmlRecord) {
        if (extraNamespaces == null) {
            return;
        }
        if (xmlRecord.getDOM().getNodeType() != 1) {
            return;
        }
        int i = 0;
        while (i < extraNamespaces.size()) {
            Namespace next = (Namespace)extraNamespaces.get(i);
            ((Element)xmlRecord.getDOM()).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + next.getPrefix(), next.getNamespaceURI());
            ++i;
        }
    }

    public void removeExtraNamespacesFromNamespaceResolver(XMLRecord marshalRecord, List extraNamespaces, CoreAbstractSession session) {
        if (extraNamespaces == null) {
            return;
        }
        int i = 0;
        while (i < extraNamespaces.size()) {
            Namespace nextExtraNamespace = (Namespace)extraNamespaces.get(i);
            String uri = marshalRecord.getNamespaceResolver().resolveNamespacePrefix(nextExtraNamespace.getPrefix());
            if (uri != null && uri.equals(nextExtraNamespace.getNamespaceURI())) {
                marshalRecord.getNamespaceResolver().removeNamespace(nextExtraNamespace.getPrefix());
            }
            ++i;
        }
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        XMLField indicatorField;
        DatabaseMapping sequenceMapping;
        this.mappingsByField.clear();
        if (this.readOnlyMappingsByField != null) {
            this.readOnlyMappingsByField.clear();
        }
        if (this.mappingsByAttribute != null) {
            this.mappingsByAttribute.clear();
        }
        this.cloningMappings.clear();
        if (this.eagerMappings != null) {
            this.eagerMappings.clear();
        }
        if (this.relationshipMappings != null) {
            this.relationshipMappings.clear();
        }
        Enumeration<DatabaseMapping> mappings = this.descriptor.getMappings().elements();
        while (mappings.hasMoreElements()) {
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.isWriteOnly() && this.mappingsByAttribute != null) {
                this.getMappingsByAttribute().put(mapping.getAttributeName(), mapping);
            }
            if (mapping.isCloningRequired()) {
                this.getCloningMappings().add(mapping);
            }
            if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).usesIndirection() && !mapping.isLazy()) {
                this.getEagerMappings().add(mapping);
            }
            if (!mapping.isDirectToFieldMapping() && this.relationshipMappings != null) {
                this.relationshipMappings.add(mapping);
            }
            for (DatabaseField field : mapping.getFields()) {
                if (mapping.isReadOnly()) {
                    if (this.readOnlyMappingsByField == null) continue;
                    List<DatabaseMapping> readOnlyMappings = this.getReadOnlyMappingsByField().get(field);
                    if (readOnlyMappings == null) {
                        readOnlyMappings = new ArrayList<DatabaseMapping>();
                        this.getReadOnlyMappingsByField().put(field, readOnlyMappings);
                    }
                    readOnlyMappings.add(mapping);
                    continue;
                }
                if (mapping.isAggregateObjectMapping()) {
                    ObjectBuilder aggregateObjectBuilder = ((AggregateObjectMapping)mapping).getReferenceDescriptor().getObjectBuilder();
                    DatabaseMapping aggregatedFieldMapping = aggregateObjectBuilder.getMappingForField(field);
                    if (aggregatedFieldMapping == null) {
                        List<DatabaseMapping> readOnlyMappings = this.getReadOnlyMappingsByField().get(field);
                        if (readOnlyMappings == null) {
                            readOnlyMappings = new ArrayList<DatabaseMapping>();
                            this.getReadOnlyMappingsByField().put(field, readOnlyMappings);
                        }
                        readOnlyMappings.add(mapping);
                        continue;
                    }
                    this.getMappingsByField().put(field, mapping);
                    continue;
                }
                if (this.getMappingsByField().containsKey(field)) continue;
                this.getMappingsByField().put(field, mapping);
            }
        }
        this.isSimple = this.relationshipMappings == null || this.relationshipMappings.isEmpty();
        this.initializePrimaryKey(session);
        this.initializeJoinedAttributes();
        if (this.descriptor.usesSequenceNumbers() && (sequenceMapping = this.getMappingForField(this.descriptor.getSequenceNumberField())) != null && sequenceMapping.isDirectToFieldMapping()) {
            this.setSequenceMapping((AbstractDirectMapping)sequenceMapping);
        }
        if (this.descriptor.hasInheritance() && (indicatorField = (XMLField)this.descriptor.getInheritancePolicy().getClassIndicatorField()) != null && indicatorField.getLastXPathFragment().getNamespaceURI() != null && indicatorField.getLastXPathFragment().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && indicatorField.getLastXPathFragment().getLocalName().equals("type")) {
            this.xsiTypeIndicatorField = true;
        }
    }

    @Override
    public boolean isXMLObjectBuilder() {
        return true;
    }

    public boolean addXsiTypeAndClassIndicatorIfRequired(XMLRecord record, XMLDescriptor xmlDescriptor, XMLDescriptor referenceDescriptor, XMLField xmlField, Object originalObject, Object obj, boolean wasXMLRoot, boolean isRootElement) {
        if (wasXMLRoot) {
            XMLSchemaReference xmlRef = xmlDescriptor.getSchemaReference();
            if (this.descriptor != null) {
                XMLRoot xr = (XMLRoot)originalObject;
                if (xmlRef == null) {
                    return false;
                }
                String xmlRootLocalName = xr.getLocalName();
                String xmlRootUri = xr.getNamespaceURI();
                XPathQName qName = new XPathQName(xmlRootUri, xmlRootLocalName, record.isNamespaceAware());
                XMLDescriptor xdesc = record.getMarshaller().getXMLContext().getDescriptor(qName);
                if (xdesc != null) {
                    boolean writeTypeAttribute;
                    boolean bl = writeTypeAttribute = xdesc.getJavaClass() != this.descriptor.getJavaClass();
                    if (writeTypeAttribute) {
                        this.writeXsiTypeAttribute(xmlDescriptor, record, xmlRef, isRootElement);
                        return true;
                    }
                    return false;
                }
                if (xr.getDeclaredType() != null && xr.getDeclaredType() == xr.getObject().getClass()) {
                    return false;
                }
                boolean writeTypeAttribute = true;
                int tableSize = this.descriptor.getTableNames().size();
                int i = 0;
                while (i < tableSize) {
                    if (!writeTypeAttribute) {
                        return false;
                    }
                    String defaultRootQualifiedName = (String)xmlDescriptor.getTableNames().get(i);
                    if (defaultRootQualifiedName != null) {
                        String defaultRootLocalName = null;
                        String defaultRootUri = null;
                        int colonIndex = defaultRootQualifiedName.indexOf(58);
                        if (colonIndex > 0) {
                            String defaultRootPrefix = defaultRootQualifiedName.substring(0, colonIndex);
                            defaultRootLocalName = defaultRootQualifiedName.substring(colonIndex + 1);
                            if (xmlDescriptor.getNamespaceResolver() != null) {
                                defaultRootUri = xmlDescriptor.getNamespaceResolver().resolveNamespacePrefix(defaultRootPrefix);
                            }
                        } else {
                            defaultRootLocalName = defaultRootQualifiedName;
                        }
                        if (xmlRootLocalName != null && (defaultRootLocalName == null && xmlRootLocalName == null || defaultRootLocalName.equals(xmlRootLocalName)) && (defaultRootUri == null && xmlRootUri == null || xmlRootUri != null && defaultRootUri != null && defaultRootUri.equals(xmlRootUri))) {
                            return false;
                        }
                    } else if (xmlRootLocalName == null) {
                        return false;
                    }
                    ++i;
                }
                if (writeTypeAttribute && xmlRef != null) {
                    this.writeXsiTypeAttribute(xmlDescriptor, record, xmlRef, isRootElement);
                    return true;
                }
            }
            return false;
        }
        return this.addXsiTypeAndClassIndicatorIfRequired(record, xmlDescriptor, referenceDescriptor, xmlField, isRootElement);
    }

    public boolean addXsiTypeAndClassIndicatorIfRequired(XMLRecord record, XMLDescriptor xmlDescriptor, XMLDescriptor referenceDescriptor, XMLField xmlField, boolean isRootElement) {
        InheritancePolicy inheritancePolicy;
        XMLField indicatorField;
        if (this.descriptor.hasInheritance() && !this.xsiTypeIndicatorField) {
            xmlDescriptor.getInheritancePolicy().addClassIndicatorFieldToRow(record);
            return true;
        }
        QName leafType = null;
        if (xmlField != null) {
            leafType = xmlField.getLeafElementType();
            XMLSchemaReference xmlRef = xmlDescriptor.getSchemaReference();
            if (xmlRef != null) {
                QName ctxQName;
                if (leafType == null) {
                    if (xmlRef.getType() == 3) {
                        return false;
                    }
                    if (referenceDescriptor == null) {
                        this.writeXsiTypeAttribute(xmlDescriptor, record, xmlRef, isRootElement);
                        return true;
                    }
                } else if ((xmlRef.getType() == 1 || xmlRef.getType() == 2) && xmlRef.getSchemaContext() != null && xmlRef.isGlobalDefinition() && !(ctxQName = xmlRef.getSchemaContextAsQName(xmlDescriptor.getNamespaceResolver())).equals(leafType)) {
                    this.writeXsiTypeAttribute(xmlDescriptor, record, xmlRef, isRootElement);
                    return true;
                }
            }
        }
        if (referenceDescriptor != null && referenceDescriptor == xmlDescriptor) {
            return false;
        }
        if (xmlDescriptor.hasInheritance() && !xmlDescriptor.getInheritancePolicy().isRootParentDescriptor() && (indicatorField = (XMLField)(inheritancePolicy = xmlDescriptor.getInheritancePolicy()).getClassIndicatorField()) != null && this.xsiTypeIndicatorField) {
            Object classIndicatorValueObject = inheritancePolicy.getClassIndicatorMapping().get(xmlDescriptor.getJavaClass());
            String classIndicatorUri = null;
            String classIndicatorLocal = null;
            String classIndicatorPrefix = null;
            if (classIndicatorValueObject instanceof QName) {
                QName classIndicatorQName = (QName)classIndicatorValueObject;
                classIndicatorUri = classIndicatorQName.getNamespaceURI();
                classIndicatorLocal = classIndicatorQName.getLocalPart();
                classIndicatorPrefix = classIndicatorQName.getPrefix();
            } else {
                String classIndicatorValue = (String)inheritancePolicy.getClassIndicatorMapping().get(xmlDescriptor.getJavaClass());
                int nsindex = classIndicatorValue.indexOf(58);
                String prefix = null;
                if (nsindex != -1) {
                    classIndicatorLocal = classIndicatorValue.substring(nsindex + 1);
                    prefix = classIndicatorValue.substring(0, nsindex);
                } else {
                    classIndicatorLocal = classIndicatorValue;
                }
                classIndicatorUri = xmlDescriptor.getNonNullNamespaceResolver().resolveNamespacePrefix(prefix);
            }
            if (leafType == null || isRootElement && record.getMarshaller().getMediaType() == MediaType.APPLICATION_JSON && !record.getMarshaller().isIncludeRoot() || !leafType.getLocalPart().equals(classIndicatorLocal) || classIndicatorUri == null && leafType.getNamespaceURI() != null && leafType.getNamespaceURI().length() > 0 || classIndicatorUri != null && !classIndicatorUri.equals(leafType.getNamespaceURI())) {
                if (inheritancePolicy.hasClassExtractor()) {
                    inheritancePolicy.addClassIndicatorFieldToRow(record);
                } else {
                    this.writeXsiTypeAttribute(xmlDescriptor, record, classIndicatorUri, classIndicatorLocal, classIndicatorPrefix, isRootElement);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

