/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.XMLConverterMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.SAXException;

public class XMLInlineBinaryHandler
extends UnmarshalRecord {
    NodeValue nodeValue;
    Mapping mapping;
    boolean isCollection = false;
    XMLConverterMapping converter;
    UnmarshalRecord parent;
    CharSequence characters;

    public XMLInlineBinaryHandler(UnmarshalRecord parent, NodeValue nodeValue, Mapping mapping, XMLConverterMapping converter, boolean isCollection) {
        super(null);
        this.nodeValue = nodeValue;
        this.isCollection = isCollection;
        this.mapping = mapping;
        this.parent = parent;
        this.converter = converter;
        this.setUnmarshaller(parent.getUnmarshaller());
    }

    @Override
    public CharSequence getCharacters() {
        if (this.characters != null) {
            return this.characters;
        }
        return super.getCharacters();
    }

    @Override
    public void characters(char[] ch, int offset, int length) throws SAXException {
        this.getStringBuffer().append(ch, offset, length);
    }

    @Override
    public void characters(CharSequence characters) throws SAXException {
        this.characters = characters;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        AbstractNullPolicy nullPolicy;
        XMLField field = null;
        Object value = this.getCharacters();
        Class attributeClassification = null;
        boolean isSwaRef = false;
        if (this.isCollection) {
            isSwaRef = ((XMLBinaryDataCollectionMapping)this.mapping).isSwaRef();
            field = (XMLField)((XMLBinaryDataCollectionMapping)this.mapping).getField();
            attributeClassification = ((XMLBinaryDataCollectionMapping)this.mapping).getAttributeElementClass();
            nullPolicy = ((XMLBinaryDataCollectionMapping)this.mapping).getNullPolicy();
        } else {
            isSwaRef = ((XMLBinaryDataMapping)this.mapping).isSwaRef();
            field = (XMLField)((XMLBinaryDataMapping)this.mapping).getField();
            attributeClassification = ((XMLBinaryDataMapping)this.mapping).getAttributeClassification();
            nullPolicy = ((XMLBinaryDataMapping)this.mapping).getNullPolicy();
        }
        if (isSwaRef && this.parent.getUnmarshaller().getAttachmentUnmarshaller() != null) {
            value = attributeClassification != null && attributeClassification == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER ? this.parent.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsDataHandler(value.toString()) : (Object)this.parent.getUnmarshaller().getAttachmentUnmarshaller().getAttachmentAsByteArray(value.toString());
        } else {
            Object valueFromReader = this.parent.getXMLReader().getValue(this.getCharacters(), attributeClassification);
            if (this.parent.isNil() && nullPolicy.isNullRepresentedByXsiNil()) {
                value = null;
            } else {
                String valueString;
                value = valueFromReader != null ? valueFromReader : ((valueString = value.toString()).length() == 0 && nullPolicy.isNullRepresentedByEmptyNode() ? null : (Object)XMLConversionManager.getDefaultXMLManager().convertSchemaBase64ToByteArray(valueString));
                value = XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(value, attributeClassification, this.parent.getSession());
            }
        }
        value = this.converter.convertDataValueToObjectValue(value, this.parent.getSession(), this.parent.getUnmarshaller());
        if (this.isCollection) {
            this.parent.addAttributeValue((ContainerValue)((Object)this.nodeValue), value);
        } else {
            this.parent.setAttributeValue(value, this.mapping);
        }
        if (!field.isSelfField()) {
            this.parent.getXMLReader().setContentHandler(this.parent);
            this.parent.endElement(namespaceURI, localName, qName);
        }
        this.resetStringBuffer();
    }

    @Override
    public void resetStringBuffer() {
        super.resetStringBuffer();
        this.characters = null;
    }
}

