/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Map;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.FragmentCollectionMapping;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLFragmentCollectionMappingNodeValue
extends NodeValue
implements ContainerValue {
    private FragmentCollectionMapping xmlFragmentCollectionMapping;
    private int index = -1;

    public XMLFragmentCollectionMappingNodeValue(FragmentCollectionMapping xmlFragmentCollectionMapping) {
        this.xmlFragmentCollectionMapping = xmlFragmentCollectionMapping;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        if (this.xmlFragmentCollectionMapping.isReadOnly()) {
            return false;
        }
        Object cp = this.xmlFragmentCollectionMapping.getContainerPolicy();
        Object collection = this.xmlFragmentCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (collection == null) {
            return false;
        }
        Object iterator = cp.iteratorFor(collection);
        if (!cp.hasNext(iterator)) {
            return false;
        }
        marshalRecord.openStartGroupingElements(namespaceResolver);
        while (cp.hasNext(iterator)) {
            Object objectValue = cp.next(iterator, (CoreAbstractSession)session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        return true;
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
        builder.setOwningRecord(unmarshalRecord);
        try {
            String namespaceURI = "";
            if (xPathFragment.getNamespaceURI() != null) {
                namespaceURI = xPathFragment.getNamespaceURI();
            }
            String qName = xPathFragment.getLocalName();
            if (xPathFragment.getPrefix() != null) {
                qName = String.valueOf(xPathFragment.getPrefix()) + ':' + qName;
            }
            if (!unmarshalRecord.getPrefixesForFragment().isEmpty()) {
                for (Map.Entry<String, String> next : unmarshalRecord.getPrefixesForFragment().entrySet()) {
                    builder.startPrefixMapping(next.getKey(), next.getValue());
                }
            }
            builder.startElement(namespaceURI, xPathFragment.getLocalName(), qName, atts);
            XMLReader xmlReader = unmarshalRecord.getXMLReader();
            xmlReader.setContentHandler(builder);
            xmlReader.setLexicalHandler(null);
        }
        catch (SAXException sAXException) {}
        return true;
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
        Node value = builder.getNodes().remove(builder.getNodes().size() - 1);
        unmarshalRecord.addAttributeValue(this, value);
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlFragmentCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlFragmentCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        if (value instanceof Node) {
            marshalRecord.node((Node)value, namespaceResolver);
        }
        return true;
    }

    @Override
    public FragmentCollectionMapping getMapping() {
        return this.xmlFragmentCollectionMapping;
    }

    @Override
    public boolean getReuseContainer() {
        return this.getMapping().getReuseContainer();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.getMapping().isDefaultEmptyContainer();
    }
}

