/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.core.descriptors.CoreInheritancePolicy;
import org.eclipse.persistence.core.mappings.CoreMapping;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.core.helper.CoreConversionManager;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.oxm.IDResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReferenceResolver {
    private ArrayList<Reference> references = new ArrayList();
    private ReferenceKey lookupKey = new ReferenceKey(null, null);
    private Map<Class, Map<Object, Object>> cache = new HashMap<Class, Map<Object, Object>>();

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    private void createPKVectorsFromMap(Reference reference, CollectionReferenceMapping mapping) {
        Object referenceDescriptor = mapping.getReferenceDescriptor();
        Vector<CacheId> pks = new Vector<CacheId>();
        if (referenceDescriptor == null) {
            CacheId pkVals = (CacheId)reference.getPrimaryKeyMap().get(null);
            if (pkVals == null) {
                return;
            }
            int x = 0;
            while (x < pkVals.getPrimaryKey().length) {
                Object[] values = new Object[]{pkVals.getPrimaryKey()[x]};
                pks.add(new CacheId(values));
                ++x;
            }
        } else {
            List<String> pkFields = ((CoreDescriptor)referenceDescriptor).getPrimaryKeyFieldNames();
            if (pkFields.isEmpty()) {
                return;
            }
            boolean init = true;
            Iterator<String> pkFieldNameIt = pkFields.iterator();
            while (pkFieldNameIt.hasNext()) {
                int i;
                CacheId pkVals = (CacheId)reference.getPrimaryKeyMap().get(pkFieldNameIt.next());
                if (pkVals == null) {
                    return;
                }
                if (init) {
                    i = 0;
                    while (i < pkVals.getPrimaryKey().length) {
                        pks.add(new CacheId(new Object[0]));
                        ++i;
                    }
                    init = false;
                }
                i = 0;
                while (i < pkVals.getPrimaryKey().length) {
                    Object val = pkVals.getPrimaryKey()[i];
                    ((CacheId)pks.get(i)).add(val);
                    ++i;
                }
            }
        }
        reference.setPrimaryKey(pks);
    }

    public Reference getReference(ObjectReferenceMapping mapping, Object sourceObject) {
        int x = 0;
        while (x < this.references.size()) {
            Reference reference = this.references.get(x);
            if (reference.getMapping() == mapping && reference.getSourceObject() == sourceObject) {
                return reference;
            }
            ++x;
        }
        return null;
    }

    public Reference getReference(ObjectReferenceMapping mapping, Object sourceObject, XMLField xmlField) {
        XMLField targetField = (XMLField)mapping.getSourceToTargetKeyFieldAssociations().get(xmlField);
        String tgtXpath = null;
        if (mapping.getReferenceClass() != null && mapping.getReferenceClass() != Object.class && targetField != null) {
            tgtXpath = targetField.getXPath();
        }
        int x = 0;
        while (x < this.references.size()) {
            Reference reference = this.references.get(x);
            if (reference.getMapping() == mapping && reference.getSourceObject() == sourceObject && reference.getPrimaryKeyMap().get(tgtXpath) == null) {
                return reference;
            }
            ++x;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void resolveReferences(CoreAbstractSession session, IDResolver userSpecifiedResolver, ErrorHandler handler) {
        x = 0;
        referencesSize = this.references.size();
        while (x < referencesSize) {
            reference = this.references.get(x);
            referenceSourceObject = reference.getSourceObject();
            if (reference.getMapping() instanceof CollectionReferenceMapping) {
                mapping = (CollectionReferenceMapping)reference.getMapping();
                cPolicy = mapping.getContainerPolicy();
                container = reference.getContainer();
                this.createPKVectorsFromMap(reference, mapping);
                if (reference.getPrimaryKey() != null) {
                    value = null;
                    if (!mapping.isWriteOnly()) {
                        for (CacheId primaryKey : (Vector)reference.getPrimaryKey()) {
                            value = this.getValue(session, reference, primaryKey, handler);
                            if (value == null) continue;
                            cPolicy.addInto(value, container, (CoreAbstractSession)session);
                        }
                    }
                    mapping.setAttributeValueInObject(referenceSourceObject, container);
                    inverseReferenceMapping = mapping.getInverseReferenceMapping();
                    if (inverseReferenceMapping != null && value != null) {
                        backpointerAccessor = inverseReferenceMapping.getAttributeAccessor();
                        backpointerContainerPolicy = inverseReferenceMapping.getContainerPolicy();
                        if (backpointerContainerPolicy == null) {
                            backpointerAccessor.setAttributeValueInObject(value, referenceSourceObject);
                        } else {
                            backpointerContainer = backpointerAccessor.getAttributeValueFromObject(value);
                            if (backpointerContainer == null) {
                                backpointerContainer = backpointerContainerPolicy.containerInstance();
                                backpointerAccessor.setAttributeValueInObject(value, backpointerContainer);
                            }
                            backpointerContainerPolicy.addInto(referenceSourceObject, backpointerContainer, (CoreAbstractSession)session);
                        }
                    }
                }
            } else if (reference.getMapping() instanceof ObjectReferenceMapping) {
                primaryKey = (CacheId)reference.getPrimaryKey();
                value = null;
                if (userSpecifiedResolver != null) {
                    try {
                        if (primaryKey.getPrimaryKey().length > 1) {
                            idWrapper = new HashMap<String, Object>();
                            y = 0;
                            while (y < primaryKey.getPrimaryKey().length) {
                                refMapping = (ObjectReferenceMapping)reference.getMapping();
                                idName = refMapping.getReferenceDescriptor().getPrimaryKeyFieldNames().get(y);
                                idValue = primaryKey.getPrimaryKey()[y];
                                idWrapper.put(idName, idValue);
                                ++y;
                            }
                            c = userSpecifiedResolver.resolve(idWrapper, reference.getTargetClass());
                        } else {
                            c = userSpecifiedResolver.resolve(primaryKey.getPrimaryKey()[0], reference.getTargetClass());
                        }
                        if (c == null) ** GOTO lbl60
                        value = c.call();
                    }
                    catch (Exception e) {
                        throw XMLMarshalException.unmarshalException(e);
                    }
                } else {
                    value = this.getValue(session, reference, primaryKey, handler);
                }
lbl60:
                // 3 sources

                mapping = (ObjectReferenceMapping)reference.getMapping();
                if (value != null) {
                    mapping.setAttributeValueInObject(reference.getSourceObject(), value);
                }
                if (reference.getSetting() != null) {
                    reference.getSetting().setValue(value);
                }
                if ((inverseReferenceMapping = mapping.getInverseReferenceMapping()) != null) {
                    backpointerAccessor = inverseReferenceMapping.getAttributeAccessor();
                    backpointerContainerPolicy = inverseReferenceMapping.getContainerPolicy();
                    if (backpointerContainerPolicy == null) {
                        backpointerAccessor.setAttributeValueInObject(value, referenceSourceObject);
                    } else {
                        backpointerContainer = backpointerAccessor.getAttributeValueFromObject(value);
                        if (backpointerContainer == null) {
                            backpointerContainer = backpointerContainerPolicy.containerInstance();
                            backpointerAccessor.setAttributeValueInObject(value, backpointerContainer);
                        }
                        backpointerContainerPolicy.addInto(reference.getSourceObject(), backpointerContainer, (CoreAbstractSession)session);
                    }
                }
            }
            ++x;
        }
        this.references = new ArrayList<E>();
        this.cache.clear();
    }

    private Object getValue(CoreAbstractSession session, Reference reference, CacheId primaryKey, ErrorHandler handler) {
        CoreMapping mapping;
        Object targetDescriptor;
        Class referenceTargetClass = reference.getTargetClass();
        if (referenceTargetClass == null || referenceTargetClass == CoreClassConstants.OBJECT) {
            for (Object entry : session.getDescriptors().values()) {
                Object value = null;
                XMLDescriptor targetDescriptor2 = (XMLDescriptor)entry;
                List<DatabaseField> pkFields = targetDescriptor2.getPrimaryKeyFields();
                if (pkFields == null || 1 != pkFields.size()) continue;
                XMLField pkField = (XMLField)pkFields.get(0);
                Class targetType = (pkField = (XMLField)targetDescriptor2.getTypedField(pkField)).getType();
                if (targetType == CoreClassConstants.STRING || targetType == CoreClassConstants.OBJECT) {
                    value = this.getValue(targetDescriptor2.getJavaClass(), primaryKey);
                } else {
                    try {
                        Object[] pkValues = primaryKey.getPrimaryKey();
                        Object[] convertedPkValues = new Object[pkValues.length];
                        int x = 0;
                        while (x < pkValues.length) {
                            convertedPkValues[x] = ((CoreConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(pkValues[x], targetType);
                            ++x;
                        }
                        value = this.getValue(targetDescriptor2.getJavaClass(), new CacheId(convertedPkValues));
                    }
                    catch (ConversionException conversionException) {}
                }
                if (value == null) continue;
                return value;
            }
            if (primaryKey.getPrimaryKey()[0] != null) {
                XMLMarshalException e = XMLMarshalException.missingIDForIDRef(Object.class.getName(), primaryKey.getPrimaryKey());
                if (handler != null) {
                    SAXParseException saxParseException = new SAXParseException(e.getLocalizedMessage(), null, e);
                    try {
                        handler.warning(saxParseException);
                    }
                    catch (SAXException sAXException) {
                        throw e;
                    }
                }
            }
            return null;
        }
        Object value = this.getValue(referenceTargetClass, primaryKey);
        if (value == null && ((CoreDescriptor)(targetDescriptor = (mapping = (CoreMapping)((Object)reference.getMapping())).getReferenceDescriptor())).hasInheritance()) {
            Object inheritancePolicy = ((CoreDescriptor)targetDescriptor).getInheritancePolicy();
            List childDescriptors = ((CoreInheritancePolicy)inheritancePolicy).getAllChildDescriptors();
            for (CoreDescriptor childDescriptor : childDescriptors) {
                value = this.getValue(childDescriptor.getJavaClass(), primaryKey);
                if (value == null) continue;
                return value;
            }
        }
        if (value == null && primaryKey.getPrimaryKey()[0] != null) {
            XMLMarshalException e = XMLMarshalException.missingIDForIDRef(referenceTargetClass.getName(), primaryKey.getPrimaryKey());
            if (handler != null) {
                SAXParseException saxParseException = new SAXParseException(e.getLocalizedMessage(), null, e);
                try {
                    handler.warning(saxParseException);
                }
                catch (SAXException sAXException) {
                    throw e;
                }
            }
        }
        return value;
    }

    private Object getValue(Class clazz, CacheId primaryKey) {
        Map<Object, Object> keyToObject = this.cache.get(clazz);
        if (keyToObject != null) {
            return keyToObject.get(primaryKey);
        }
        return null;
    }

    public void putValue(Class clazz, Object key, Object object) {
        Map<Object, Object> keyToObject = this.cache.get(clazz);
        if (keyToObject == null) {
            keyToObject = new HashMap<Object, Object>();
            this.cache.put(clazz, keyToObject);
        }
        keyToObject.put(key, object);
    }

    private class ReferenceKey {
        private Object sourceObject;
        private XMLMapping mapping;

        public ReferenceKey(Object sourceObject, XMLMapping mapping) {
            this.sourceObject = sourceObject;
            this.mapping = mapping;
        }

        public Object getSourceObject() {
            return this.sourceObject;
        }

        public XMLMapping getMapping() {
            return this.mapping;
        }

        public void setSourceObject(Object obj) {
            this.sourceObject = obj;
        }

        public void setMapping(XMLMapping mapping) {
            this.mapping = mapping;
        }

        public int hashCode() {
            return this.mapping.hashCode() ^ this.sourceObject.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ReferenceKey key = (ReferenceKey)obj;
            return this.sourceObject == key.getSourceObject() && this.mapping == key.getMapping();
        }
    }
}

