/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class ForeignKeyMetadata
extends ORMetadata {
    protected Boolean m_disableForeignKey;
    protected String m_name;
    protected String m_foreignKeyDefinition;

    public ForeignKeyMetadata() {
        super("<foreign-key>");
    }

    public ForeignKeyMetadata(ForeignKeyMetadata foreignKey) {
        super(foreignKey);
        this.m_name = foreignKey.getName();
        this.m_foreignKeyDefinition = foreignKey.getForeignKeyDefinition();
        this.m_disableForeignKey = foreignKey.getDisableForeignKey();
    }

    public ForeignKeyMetadata(MetadataAnnotation foreignKey, MetadataAccessor accessor) {
        super(foreignKey, accessor);
        if (foreignKey != null) {
            this.m_name = (String)foreignKey.getAttribute("name");
            this.m_foreignKeyDefinition = (String)foreignKey.getAttribute("foreignKeyDefinition");
            this.m_disableForeignKey = (Boolean)foreignKey.getAttributeBooleanDefaultFalse("disableForeignKey");
        }
    }

    public ForeignKeyMetadata(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ForeignKeyMetadata) {
            ForeignKeyMetadata foreignKey = (ForeignKeyMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, foreignKey.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_foreignKeyDefinition, foreignKey.getForeignKeyDefinition())) {
                return false;
            }
            return this.valuesMatch(this.m_disableForeignKey, foreignKey.getDisableForeignKey());
        }
        return false;
    }

    protected boolean disableForeignKey() {
        return this.m_disableForeignKey != null && this.m_disableForeignKey != false;
    }

    public Boolean getDisableForeignKey() {
        return this.m_disableForeignKey;
    }

    public String getForeignKeyDefinition() {
        return this.m_foreignKeyDefinition;
    }

    public String getName() {
        return this.m_name;
    }

    public void process(DatabaseTable table) {
        this.process(table, false);
    }

    public void process(DatabaseTable table, boolean inverse) {
        if (inverse) {
            table.setInverseForeignKeyName(this.getName());
            table.setInverseForeignKeyDefinition(this.getForeignKeyDefinition());
            table.setInverseDisableForeignKey(this.disableForeignKey());
        } else {
            table.setForeignKeyName(this.getName());
            table.setForeignKeyDefinition(this.getForeignKeyDefinition());
            table.setDisableForeignKey(this.disableForeignKey());
        }
    }

    public void process(ForeignReferenceMapping mapping) {
        mapping.setForeignKeyName(this.getName());
        mapping.setForeignKeyDefinition(this.getForeignKeyDefinition());
        mapping.setDisableForeignKey(this.disableForeignKey());
    }

    public void setDisableForeignKey(Boolean disableForeignKey) {
        this.m_disableForeignKey = disableForeignKey;
    }

    public void setForeignKeyDefinition(String foreignKeyDefinition) {
        this.m_foreignKeyDefinition = foreignKeyDefinition;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

