/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.annotations.Converter;
import org.eclipse.persistence.annotations.Converters;
import org.eclipse.persistence.annotations.HashPartitioning;
import org.eclipse.persistence.annotations.ObjectTypeConverter;
import org.eclipse.persistence.annotations.ObjectTypeConverters;
import org.eclipse.persistence.annotations.Partitioned;
import org.eclipse.persistence.annotations.Partitioning;
import org.eclipse.persistence.annotations.PinnedPartitioning;
import org.eclipse.persistence.annotations.RangePartitioning;
import org.eclipse.persistence.annotations.ReplicationPartitioning;
import org.eclipse.persistence.annotations.RoundRobinPartitioning;
import org.eclipse.persistence.annotations.StructConverter;
import org.eclipse.persistence.annotations.StructConverters;
import org.eclipse.persistence.annotations.TypeConverter;
import org.eclipse.persistence.annotations.TypeConverters;
import org.eclipse.persistence.annotations.UnionPartitioning;
import org.eclipse.persistence.annotations.ValuePartitioning;
import org.eclipse.persistence.descriptors.SingleTableMultitenantPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.AccessMethodsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.HashPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.PartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.PinnedPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.RangePartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ReplicationPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.RoundRobinPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.UnionPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.ValuePartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public abstract class MetadataAccessor
extends ORMetadata {
    private AccessMethodsMetadata m_accessMethods;
    private List<ConverterMetadata> m_converters = new ArrayList<ConverterMetadata>();
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters = new ArrayList<ObjectTypeConverterMetadata>();
    private List<StructConverterMetadata> m_structConverters = new ArrayList<StructConverterMetadata>();
    private List<TypeConverterMetadata> m_typeConverters = new ArrayList<TypeConverterMetadata>();
    private List<PropertyMetadata> m_properties = new ArrayList<PropertyMetadata>();
    private MetadataDescriptor m_descriptor;
    private PartitioningMetadata m_partitioning;
    private ReplicationPartitioningMetadata m_replicationPartitioning;
    private RoundRobinPartitioningMetadata m_roundRobinPartitioning;
    private PinnedPartitioningMetadata m_pinnedPartitioning;
    private RangePartitioningMetadata m_rangePartitioning;
    private ValuePartitioningMetadata m_valuePartitioning;
    private UnionPartitioningMetadata m_unionPartitioning;
    private HashPartitioningMetadata m_hashPartitioning;
    private String m_partitioned;
    private String m_access;
    private String m_name;

    public MetadataAccessor(String xmlElement) {
        super(xmlElement);
    }

    public MetadataAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor, MetadataProject project) {
        super(annotation, accessibleObject, project);
        this.setDescriptor(descriptor);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof MetadataAccessor) {
            MetadataAccessor accessor = (MetadataAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_accessMethods, accessor.getAccessMethods())) {
                return false;
            }
            if (!this.valuesMatch(this.m_converters, accessor.getConverters())) {
                return false;
            }
            if (!this.valuesMatch(this.m_objectTypeConverters, accessor.getObjectTypeConverters())) {
                return false;
            }
            if (!this.valuesMatch(this.m_structConverters, accessor.getStructConverters())) {
                return false;
            }
            if (!this.valuesMatch(this.m_typeConverters, accessor.getTypeConverters())) {
                return false;
            }
            if (!this.valuesMatch(this.m_properties, accessor.getProperties())) {
                return false;
            }
            if (!this.valuesMatch(this.m_access, accessor.getAccess())) {
                return false;
            }
            return this.valuesMatch(this.m_name, accessor.getName());
        }
        return false;
    }

    public String getAccess() {
        return this.m_access;
    }

    @Override
    public MetadataAnnotatedElement getAccessibleObject() {
        return (MetadataAnnotatedElement)super.getAccessibleObject();
    }

    public AccessMethodsMetadata getAccessMethods() {
        return this.m_accessMethods;
    }

    public MetadataAnnotatedElement getAnnotatedElement() {
        return this.getAccessibleObject();
    }

    public String getAnnotatedElementName() {
        return this.getAnnotatedElement().toString();
    }

    public MetadataAnnotation getAnnotation(Class annotation) {
        return this.getAnnotation(annotation.getName());
    }

    protected abstract MetadataAnnotation getAnnotation(String var1);

    public String getAttributeName() {
        return this.getAccessibleObject().getAttributeName();
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    protected String getDefaultAttributeName() {
        return this.getProject().useDelimitedIdentifier() ? this.getAttributeName() : this.getAttributeName().toUpperCase();
    }

    public MetadataDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public MetadataClass getDescriptorJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    public HashPartitioningMetadata getHashPartitioning() {
        return this.m_hashPartitioning;
    }

    @Override
    public String getIdentifier() {
        return this.getName();
    }

    public MetadataClass getJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    protected String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public String getName() {
        return this.m_name;
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public String getPartitioned() {
        return this.m_partitioned;
    }

    public PartitioningMetadata getPartitioning() {
        return this.m_partitioning;
    }

    public PinnedPartitioningMetadata getPinnedPartitioning() {
        return this.m_pinnedPartitioning;
    }

    public List<PropertyMetadata> getProperties() {
        return this.m_properties;
    }

    public RangePartitioningMetadata getRangePartitioning() {
        return this.m_rangePartitioning;
    }

    protected DatabaseField getReferencedField(String referencedColumnName, MetadataDescriptor referenceDescriptor, String context) {
        return this.getReferencedField(referencedColumnName, referenceDescriptor, context, false);
    }

    protected DatabaseField getReferencedField(String referencedColumnName, MetadataDescriptor referenceDescriptor, String context, boolean isForAggregateCollection) {
        DatabaseField referenceField;
        if (referencedColumnName == null || referencedColumnName.equals("")) {
            referenceField = referenceDescriptor.getPrimaryKeyField();
            if (referenceDescriptor.isInheritanceSubclass() && isForAggregateCollection) {
                referenceField = referenceDescriptor.getPrimaryKeyJoinColumnAssociationField(referenceField);
            }
            this.getLogger().logConfigMessage(context, this.getAnnotatedElementName(), (Object)referenceField.getName());
        } else {
            referenceField = referenceDescriptor.getField(referencedColumnName);
            if (referenceField == null) {
                DatabaseField lookupField = new DatabaseField();
                this.setFieldName(lookupField, referencedColumnName);
                referenceField = referenceDescriptor.getField(lookupField.getNameForComparisons());
                if (referenceField == null) {
                    referenceField = lookupField;
                    referenceField.setTable(referenceDescriptor.getPrimaryKeyTable());
                    this.getLogger().logWarningMessage("metadata_warning_reference_column_not_found", referencedColumnName, this.getAnnotatedElement());
                }
            }
        }
        return referenceField;
    }

    public ReplicationPartitioningMetadata getReplicationPartitioning() {
        return this.m_replicationPartitioning;
    }

    public RoundRobinPartitioningMetadata getRoundRobinPartitioning() {
        return this.m_roundRobinPartitioning;
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    public UnionPartitioningMetadata getUnionPartitioning() {
        return this.m_unionPartitioning;
    }

    protected String getUpperCaseShortJavaClassName() {
        return Helper.getShortClassName(this.getJavaClassName()).toUpperCase();
    }

    protected Integer getValue(Integer value, Integer defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    protected String getValue(String value, String defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    public ValuePartitioningMetadata getValuePartitioning() {
        return this.m_valuePartitioning;
    }

    public boolean hasAccess() {
        return this.m_access != null;
    }

    public boolean hasAccessMethods() {
        return this.m_accessMethods != null;
    }

    public void initAccess() {
        MetadataAnnotation access;
        if (this.m_access == null && (access = this.getAnnotation("javax.persistence.Access")) != null) {
            this.setAccess((String)access.getAttribute("value"));
        }
    }

    public void initXMLAccessor(MetadataDescriptor descriptor, MetadataProject project) {
        this.setProject(project);
        this.setDescriptor(descriptor);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_accessMethods, accessibleObject);
        this.initXMLObject(this.m_partitioning, accessibleObject);
        this.initXMLObject(this.m_replicationPartitioning, accessibleObject);
        this.initXMLObject(this.m_roundRobinPartitioning, accessibleObject);
        this.initXMLObject(this.m_pinnedPartitioning, accessibleObject);
        this.initXMLObject(this.m_rangePartitioning, accessibleObject);
        this.initXMLObject(this.m_valuePartitioning, accessibleObject);
        this.initXMLObject(this.m_hashPartitioning, accessibleObject);
        this.initXMLObject(this.m_unionPartitioning, accessibleObject);
        this.initXMLObjects(this.m_converters, accessibleObject);
        this.initXMLObjects(this.m_objectTypeConverters, accessibleObject);
        this.initXMLObjects(this.m_structConverters, accessibleObject);
        this.initXMLObjects(this.m_typeConverters, accessibleObject);
        this.initXMLObjects(this.m_properties, accessibleObject);
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.isAnnotationPresent(annotation.getName());
    }

    public abstract boolean isAnnotationPresent(String var1);

    public abstract boolean isProcessed();

    @Override
    public void merge(ORMetadata metadata) {
        MetadataAccessor accessor = (MetadataAccessor)metadata;
        this.m_access = (String)this.mergeSimpleObjects(this.m_access, accessor.getAccess(), accessor, "@access");
        this.m_accessMethods = (AccessMethodsMetadata)this.mergeORObjects(this.m_accessMethods, accessor.getAccessMethods());
        this.m_converters = this.mergeORObjectLists(this.m_converters, accessor.getConverters());
        this.m_objectTypeConverters = this.mergeORObjectLists(this.m_objectTypeConverters, accessor.getObjectTypeConverters());
        this.m_structConverters = this.mergeORObjectLists(this.m_structConverters, accessor.getStructConverters());
        this.m_typeConverters = this.mergeORObjectLists(this.m_typeConverters, accessor.getTypeConverters());
        this.m_properties = this.mergeORObjectLists(this.m_properties, accessor.getProperties());
        this.m_partitioned = (String)this.mergeSimpleObjects(this.m_partitioned, accessor.getPartitioned(), accessor, "<partitioned>");
        this.m_partitioning = (PartitioningMetadata)this.mergeORObjects(this.m_partitioning, accessor.getPartitioning());
        this.m_replicationPartitioning = (ReplicationPartitioningMetadata)this.mergeORObjects(this.m_replicationPartitioning, accessor.getReplicationPartitioning());
        this.m_roundRobinPartitioning = (RoundRobinPartitioningMetadata)this.mergeORObjects(this.m_roundRobinPartitioning, accessor.getRoundRobinPartitioning());
        this.m_pinnedPartitioning = (PinnedPartitioningMetadata)this.mergeORObjects(this.m_pinnedPartitioning, accessor.getPinnedPartitioning());
        this.m_rangePartitioning = (RangePartitioningMetadata)this.mergeORObjects(this.m_rangePartitioning, accessor.getRangePartitioning());
        this.m_valuePartitioning = (ValuePartitioningMetadata)this.mergeORObjects(this.m_valuePartitioning, accessor.getValuePartitioning());
        this.m_hashPartitioning = (HashPartitioningMetadata)this.mergeORObjects(this.m_hashPartitioning, accessor.getHashPartitioning());
        this.m_unionPartitioning = (UnionPartitioningMetadata)this.mergeORObjects(this.m_unionPartitioning, accessor.getUnionPartitioning());
    }

    public abstract void process();

    public void processConverters() {
        this.processCustomConverters();
        this.processObjectTypeConverters();
        this.processTypeConverters();
        this.processStructConverters();
    }

    protected void processCustomConverters() {
        Object converter;
        for (ConverterMetadata converter2 : this.m_converters) {
            this.getProject().addConverter(converter2);
        }
        MetadataAnnotation converters = this.getAnnotation(Converters.class);
        if (converters != null) {
            Object[] objectArray = converters.getAttributeArray("value");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                converter = objectArray[n2];
                this.getProject().addConverter(new ConverterMetadata((MetadataAnnotation)converter, this));
                ++n2;
            }
        }
        if ((converter = this.getAnnotation(Converter.class)) != null) {
            this.getProject().addConverter(new ConverterMetadata((MetadataAnnotation)converter, this));
        }
    }

    protected void processObjectTypeConverters() {
        for (ObjectTypeConverterMetadata objectTypeConverterMetadata : this.m_objectTypeConverters) {
            this.getProject().addConverter(objectTypeConverterMetadata);
        }
        if (this.isAnnotationPresent(ObjectTypeConverters.class)) {
            Object[] objectArray = this.getAnnotation(ObjectTypeConverters.class).getAttributeArray("value");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.getProject().addConverter(new ObjectTypeConverterMetadata((MetadataAnnotation)object, this));
                ++n2;
            }
        }
        if (this.isAnnotationPresent(ObjectTypeConverter.class)) {
            this.getProject().addConverter(new ObjectTypeConverterMetadata(this.getAnnotation(ObjectTypeConverter.class), this));
        }
    }

    public void processPartitioned(String name) {
        if (this instanceof ClassAccessor) {
            if (this.getDescriptor().getClassDescriptor().getPartitioningPolicy() != null) {
                this.getLogger().logConfigMessage("metadata_warning_ignore_mapped_superclass_annotation", Partitioned.class, (Object)this.getJavaClass(), (Object)this.getDescriptor().getJavaClass());
            }
            this.getDescriptor().getClassDescriptor().setPartitioningPolicyName(name);
        } else if (this instanceof MappingAccessor) {
            ((ForeignReferenceMapping)((MappingAccessor)this).getMapping()).setPartitioningPolicyName(name);
        }
    }

    protected void processPartitioning() {
        MetadataAnnotation annotation;
        boolean found = false;
        if (this.m_replicationPartitioning != null) {
            found = true;
            this.getProject().addPartitioningPolicy(this.m_replicationPartitioning);
        }
        if (this.m_roundRobinPartitioning != null) {
            found = true;
            this.getProject().addPartitioningPolicy(this.m_roundRobinPartitioning);
        }
        if (this.m_partitioning != null) {
            found = true;
            this.getProject().addPartitioningPolicy(this.m_partitioning);
        }
        if (this.m_rangePartitioning != null) {
            found = true;
            this.getProject().addPartitioningPolicy(this.m_rangePartitioning);
        }
        if (this.m_valuePartitioning != null) {
            found = true;
            this.getProject().addPartitioningPolicy(this.m_valuePartitioning);
        }
        if (this.m_hashPartitioning != null) {
            found = true;
            this.getProject().addPartitioningPolicy(this.m_hashPartitioning);
        }
        if (this.m_unionPartitioning != null) {
            found = true;
            this.getProject().addPartitioningPolicy(this.m_unionPartitioning);
        }
        if (this.m_pinnedPartitioning != null) {
            found = true;
            this.getProject().addPartitioningPolicy(this.m_pinnedPartitioning);
        }
        if ((annotation = this.getAnnotation(Partitioning.class)) != null) {
            found = true;
            this.getProject().addPartitioningPolicy(new PartitioningMetadata(annotation, this));
        }
        if ((annotation = this.getAnnotation(ReplicationPartitioning.class)) != null) {
            found = true;
            this.getProject().addPartitioningPolicy(new ReplicationPartitioningMetadata(annotation, this));
        }
        if ((annotation = this.getAnnotation(RoundRobinPartitioning.class)) != null) {
            found = true;
            this.getProject().addPartitioningPolicy(new RoundRobinPartitioningMetadata(annotation, this));
        }
        if ((annotation = this.getAnnotation(UnionPartitioning.class)) != null) {
            found = true;
            this.getProject().addPartitioningPolicy(new UnionPartitioningMetadata(annotation, this));
        }
        if ((annotation = this.getAnnotation(RangePartitioning.class)) != null) {
            found = true;
            this.getProject().addPartitioningPolicy(new RangePartitioningMetadata(annotation, this));
        }
        if ((annotation = this.getAnnotation(ValuePartitioning.class)) != null) {
            found = true;
            this.getProject().addPartitioningPolicy(new ValuePartitioningMetadata(annotation, this));
        }
        if ((annotation = this.getAnnotation(ValuePartitioning.class)) != null) {
            found = true;
            this.getProject().addPartitioningPolicy(new ValuePartitioningMetadata(annotation, this));
        }
        if ((annotation = this.getAnnotation(PinnedPartitioning.class)) != null) {
            found = true;
            this.getProject().addPartitioningPolicy(new PinnedPartitioningMetadata(annotation, this));
        }
        if ((annotation = this.getAnnotation(HashPartitioning.class)) != null) {
            found = true;
            this.getProject().addPartitioningPolicy(new HashPartitioningMetadata(annotation, this));
        }
        boolean processed = false;
        if (this.m_partitioned != null) {
            processed = true;
            this.processPartitioned(this.m_partitioned);
        }
        annotation = this.getAnnotation(Partitioned.class);
        if (!processed && annotation != null) {
            processed = true;
            this.processPartitioned((String)annotation.getAttribute("value"));
        }
        if (found && !processed) {
            this.getLogger().logWarningMessage("metadata_warning_partitioned_not_set", this.getJavaClass(), this.getAccessibleObject());
        }
    }

    protected List<PrimaryKeyJoinColumnMetadata> processPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        if (primaryKeyJoinColumns.isEmpty()) {
            if (this.getDescriptor().hasCompositePrimaryKey()) {
                for (DatabaseField primaryKeyField : this.getDescriptor().getPrimaryKeyFields()) {
                    PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn = new PrimaryKeyJoinColumnMetadata(this.getProject());
                    primaryKeyJoinColumn.setReferencedColumnName(primaryKeyField.getName());
                    primaryKeyJoinColumn.setName(primaryKeyField.getName());
                    primaryKeyJoinColumns.add(primaryKeyJoinColumn);
                }
            } else {
                primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata(this.getProject()));
            }
        } else if (this.getDescriptor().hasSingleTableMultitenant() && primaryKeyJoinColumns.size() != this.getDescriptor().getPrimaryKeyFields().size()) {
            SingleTableMultitenantPolicy policy = (SingleTableMultitenantPolicy)this.getDescriptor().getClassDescriptor().getMultitenantPolicy();
            Map<DatabaseField, String> tenantFields = policy.getTenantDiscriminatorFields();
            for (DatabaseField tenantField : tenantFields.keySet()) {
                if (!tenantField.isPrimaryKey()) continue;
                PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn = new PrimaryKeyJoinColumnMetadata();
                primaryKeyJoinColumn.setName(tenantField.getName());
                primaryKeyJoinColumn.setReferencedColumnName(tenantField.getName());
                primaryKeyJoinColumn.setProject(this.getProject());
                primaryKeyJoinColumns.add(primaryKeyJoinColumn);
            }
        }
        if (this.getDescriptor().hasCompositePrimaryKey()) {
            for (PrimaryKeyJoinColumnMetadata pkJoinColumn : primaryKeyJoinColumns) {
                if (!pkJoinColumn.isPrimaryKeyFieldNotSpecified() && !pkJoinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified(this.getAnnotatedElement());
            }
        } else if (primaryKeyJoinColumns.size() > 1) {
            throw ValidationException.excessivePrimaryKeyJoinColumnsSpecified(this.getAnnotatedElement());
        }
        return primaryKeyJoinColumns;
    }

    protected void processStructConverters() {
        for (StructConverterMetadata structConverterMetadata : this.m_structConverters) {
            this.getProject().addConverter(structConverterMetadata);
        }
        if (this.isAnnotationPresent(StructConverters.class)) {
            Object[] objectArray = this.getAnnotation(StructConverters.class).getAttributeArray("value");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.getProject().addConverter(new StructConverterMetadata((MetadataAnnotation)object, this));
                ++n2;
            }
        }
        if (this.isAnnotationPresent(StructConverter.class)) {
            this.getProject().addConverter(new StructConverterMetadata(this.getAnnotation(StructConverter.class), this));
        }
    }

    protected void processTable(TableMetadata table, String defaultName) {
        this.getProject().processTable(table, defaultName, this.m_descriptor.getDefaultCatalog(), this.m_descriptor.getDefaultSchema(), this);
    }

    protected void processTypeConverters() {
        for (TypeConverterMetadata typeConverterMetadata : this.m_typeConverters) {
            this.getProject().addConverter(typeConverterMetadata);
        }
        if (this.isAnnotationPresent(TypeConverters.class)) {
            Object[] objectArray = this.getAnnotation(TypeConverters.class).getAttributeArray("value");
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.getProject().addConverter(new TypeConverterMetadata((MetadataAnnotation)object, this));
                ++n2;
            }
        }
        if (this.isAnnotationPresent(TypeConverter.class)) {
            this.getProject().addConverter(new TypeConverterMetadata(this.getAnnotation(TypeConverter.class), this));
        }
    }

    public void setAccess(String access) {
        this.m_access = access;
    }

    public void setAccessMethods(AccessMethodsMetadata accessMethods) {
        this.m_accessMethods = accessMethods;
    }

    public void setConverters(List<ConverterMetadata> converters) {
        this.m_converters = converters;
    }

    public void setDescriptor(MetadataDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public void setHashPartitioning(HashPartitioningMetadata hashPartitioning) {
        this.m_hashPartitioning = hashPartitioning;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> objectTypeConverters) {
        this.m_objectTypeConverters = objectTypeConverters;
    }

    public void setPartitioned(String partitioned) {
        this.m_partitioned = partitioned;
    }

    public void setPartitioning(PartitioningMetadata partitioning) {
        this.m_partitioning = partitioning;
    }

    public void setPinnedPartitioning(PinnedPartitioningMetadata pinnedPartitioning) {
        this.m_pinnedPartitioning = pinnedPartitioning;
    }

    public void setProperties(List<PropertyMetadata> properties) {
        this.m_properties = properties;
    }

    public void setRangePartitioning(RangePartitioningMetadata rangePartitioning) {
        this.m_rangePartitioning = rangePartitioning;
    }

    public void setReplicationPartitioning(ReplicationPartitioningMetadata replicationPartitioning) {
        this.m_replicationPartitioning = replicationPartitioning;
    }

    public void setRoundRobinPartitioning(RoundRobinPartitioningMetadata roundRobinPartitioning) {
        this.m_roundRobinPartitioning = roundRobinPartitioning;
    }

    public void setStructConverters(List<StructConverterMetadata> structConverters) {
        this.m_structConverters = structConverters;
    }

    public void setTypeConverters(List<TypeConverterMetadata> typeConverters) {
        this.m_typeConverters = typeConverters;
    }

    public void setUnionPartitioning(UnionPartitioningMetadata unionPartitioning) {
        this.m_unionPartitioning = unionPartitioning;
    }

    public void setValuePartitioning(ValuePartitioningMetadata valuePartitioning) {
        this.m_valuePartitioning = valuePartitioning;
    }
}

