/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.DeclarationResolver;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.ITypeHelper;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.SemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

final class EclipseLinkSemanticValidatorHelper
implements SemanticValidatorHelper {
    private final JPQLQueryContext queryContext;

    EclipseLinkSemanticValidatorHelper(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private void addIdentificationVariable(IdentificationVariable identificationVariable, Map<String, List<IdentificationVariable>> identificationVariables) {
        String variableName;
        String string = variableName = identificationVariable != null ? identificationVariable.getVariableName() : null;
        if (ExpressionTools.stringIsNotEmpty(variableName)) {
            List<IdentificationVariable> variables = identificationVariables.get(variableName);
            if (variables == null) {
                variables = new ArrayList<IdentificationVariable>();
                identificationVariables.put(variableName, variables);
            }
            variables.add(identificationVariable);
        }
    }

    @Override
    public void collectAllDeclarationIdentificationVariables(Map<String, List<IdentificationVariable>> identificationVariables) {
        JPQLQueryContext currentContext = this.queryContext.getCurrentContext();
        while (currentContext != null) {
            this.collectLocalDeclarationIdentificationVariables(currentContext, identificationVariables);
            currentContext = currentContext.getActualParent();
        }
    }

    private void collectLocalDeclarationIdentificationVariables(JPQLQueryContext queryContext, Map<String, List<IdentificationVariable>> identificationVariables) {
        DeclarationResolver declarationResolver = queryContext.getDeclarationResolverImp();
        for (Declaration declaration : declarationResolver.getDeclarations()) {
            IdentificationVariable identificationVariable = declaration.identificationVariable;
            this.addIdentificationVariable(identificationVariable, identificationVariables);
        }
        for (IdentificationVariable identificationVariable : declarationResolver.getResultVariables()) {
            this.addIdentificationVariable(identificationVariable, identificationVariables);
        }
    }

    @Override
    public void collectLocalDeclarationIdentificationVariables(Map<String, List<IdentificationVariable>> identificationVariables) {
        this.collectLocalDeclarationIdentificationVariables(this.queryContext, identificationVariables);
    }

    @Override
    public void disposeSubqueryContext() {
        this.queryContext.disposeSubqueryContext();
    }

    @Override
    public String[] entityNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (ClassDescriptor descriptor : this.queryContext.getSession().getDescriptors().values()) {
            if (descriptor.isAggregateDescriptor()) continue;
            String name = descriptor.getAlias();
            if (ExpressionTools.stringIsEmpty(name)) {
                name = descriptor.getJavaClass().getSimpleName();
            }
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public List<JPQLQueryDeclaration> getAllDeclarations() {
        ArrayList<JPQLQueryDeclaration> declarations = new ArrayList<JPQLQueryDeclaration>();
        JPQLQueryContext context = this.queryContext.getCurrentContext();
        while (context != null) {
            declarations.addAll(context.getDeclarationResolverImp().getDeclarations());
            context = context.getActualParent();
        }
        return declarations;
    }

    @Override
    public Object[] getConstructors(Object type) {
        return type != null ? ((Class)type).getDeclaredConstructors() : ExpressionTools.EMPTY_ARRAY;
    }

    public List getDeclarations() {
        return this.queryContext.getDeclarations();
    }

    @Override
    public ClassDescriptor getEmbeddable(Object type) {
        ClassDescriptor descriptor = this.queryContext.getDescriptor((Class)type);
        if (descriptor != null && descriptor.isAggregateDescriptor()) {
            return descriptor;
        }
        return null;
    }

    @Override
    public ClassDescriptor getEntityNamed(String entityName) {
        return this.queryContext.getDescriptor(entityName);
    }

    @Override
    public String[] getEnumConstants(Object type) {
        Enum[] constants = (Enum[])((Class)type).getEnumConstants();
        String[] names = new String[constants.length];
        int index = constants.length;
        while (--index >= 0) {
            names[index] = constants[index].name();
        }
        return names;
    }

    @Override
    public JPQLGrammar getGrammar() {
        return this.queryContext.getGrammar();
    }

    @Override
    public Object getManagedType(Expression expression) {
        return this.queryContext.resolveDescriptor(expression);
    }

    @Override
    public Object getMappingNamed(Object entity, String name) {
        ClassDescriptor descriptor = (ClassDescriptor)entity;
        Cloneable mapping = descriptor.getObjectBuilder().getMappingForAttributeName(name);
        if (mapping == null) {
            mapping = descriptor.getQueryKeyNamed(name);
        }
        return mapping;
    }

    @Override
    public Class<?> getMappingType(Object mapping) {
        if (mapping == null) {
            return null;
        }
        try {
            return this.queryContext.calculateMappingType((DatabaseMapping)mapping);
        }
        catch (ClassCastException classCastException) {
            return this.queryContext.calculateQueryKeyType((QueryKey)mapping);
        }
    }

    public Type[] getMethodParameterTypeDeclarations(Object constructor) {
        return ((Constructor)constructor).getGenericParameterTypes();
    }

    @Override
    public Class<?> getType(Expression expression) {
        return this.queryContext.getType(expression);
    }

    @Override
    public Object getType(Object typeDeclaration) {
        return null;
    }

    @Override
    public Class<?> getType(String className) {
        return this.queryContext.getType(className);
    }

    @Override
    public Object getTypeDeclaration(Expression expression) {
        return null;
    }

    @Override
    public ITypeHelper getTypeHelper() {
        return null;
    }

    @Override
    public String getTypeName(Object type) {
        return ((Class)type).getName();
    }

    @Override
    public boolean isAssignableTo(Object type1, Object type2) {
        return ((Class)type2).isAssignableFrom((Class)type1);
    }

    @Override
    public boolean isCollectionIdentificationVariable(String variableName) {
        return this.queryContext.isCollectionIdentificationVariable(variableName);
    }

    @Override
    public boolean isCollectionMapping(Object mapping) {
        if (mapping == null) {
            return false;
        }
        try {
            return ((DatabaseMapping)mapping).isCollectionMapping();
        }
        catch (ClassCastException classCastException) {
            return ((QueryKey)mapping).isCollectionQueryKey();
        }
    }

    @Override
    public boolean isEnumType(Object type) {
        return type != null && ((Class)type).isEnum();
    }

    @Override
    public boolean isIdentificationVariableValidInComparison(IdentificationVariable expression) {
        Declaration declaration = this.queryContext.findDeclaration(expression.getVariableName());
        if (declaration == null) {
            return false;
        }
        DatabaseMapping mapping = declaration.getMapping();
        if (mapping == null) {
            return false;
        }
        return mapping.isDirectCollectionMapping() || mapping.isAbstractCompositeDirectCollectionMapping();
    }

    @Override
    public boolean isManagedTypeResolvable(Object managedType) {
        return managedType != null;
    }

    @Override
    public boolean isPropertyMapping(Object mapping) {
        if (mapping == null) {
            return false;
        }
        try {
            return ((DatabaseMapping)mapping).isDirectToFieldMapping();
        }
        catch (ClassCastException classCastException) {
            return ((QueryKey)mapping).isDirectQueryKey();
        }
    }

    @Override
    public boolean isRelationshipMapping(Object mapping) {
        if (mapping == null) {
            return false;
        }
        if (mapping instanceof DatabaseMapping) {
            DatabaseMapping databaseMapping = (DatabaseMapping)mapping;
            return databaseMapping.isForeignReferenceMapping() || databaseMapping.isAbstractCompositeCollectionMapping() || databaseMapping.isAbstractCompositeDirectCollectionMapping();
        }
        return ((QueryKey)mapping).isForeignReferenceQueryKey();
    }

    @Override
    public boolean isResultVariable(String variableName) {
        return this.queryContext.isResultVariable(variableName);
    }

    @Override
    public boolean isTransient(Object mapping) {
        return mapping == null;
    }

    @Override
    public boolean isTypeDeclarationAssignableTo(Object typeDeclaration1, Object typeDeclaration2) {
        return false;
    }

    @Override
    public boolean isTypeResolvable(Object type) {
        return type != null;
    }

    @Override
    public boolean isValidatingPathExpressionAllowed(StateFieldPathExpression expression) {
        Declaration declaration = this.queryContext.findDeclaration(expression.getIdentificationVariable().toActualText());
        if (declaration == null) {
            return true;
        }
        JPQLQueryDeclaration.Type type = declaration.getType();
        return type != JPQLQueryDeclaration.Type.TABLE && type != JPQLQueryDeclaration.Type.SUBQUERY;
    }

    @Override
    public void newSubqueryContext(SimpleSelectStatement expression) {
        this.queryContext.newSubQueryContext(expression, null);
    }

    @Override
    public Object resolveMapping(Expression expression) {
        return this.queryContext.resolveMappingObject(expression);
    }

    @Override
    public Object resolveMapping(String variableName, String name) {
        Declaration declaration = this.queryContext.findDeclaration(variableName);
        if (declaration == null) {
            return null;
        }
        ClassDescriptor descriptor = declaration.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        Cloneable mapping = descriptor.getObjectBuilder().getMappingForAttributeName(name);
        if (mapping == null) {
            mapping = descriptor.getQueryKeyNamed(name);
        }
        return mapping;
    }
}

