/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ModifyQuery;

public class ParameterizedSQLBatchWritingMechanism
extends BatchWritingMechanism {
    protected DatabaseCall previousCall;
    protected ArrayList parameters;
    protected DatabaseCall lastCallAppended;

    public ParameterizedSQLBatchWritingMechanism(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
        this.parameters = new ArrayList(10);
        this.maxBatchSize = this.databaseAccessor.getLogin().getPlatform().getMaxBatchWritingSize();
        if (this.maxBatchSize == 0) {
            this.maxBatchSize = DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE;
        }
    }

    @Override
    public void appendCall(AbstractSession session, DatabaseCall dbCall) {
        if (dbCall != null) {
            this.cacheQueryTimeout(session, dbCall);
        }
        if (dbCall.hasParameters()) {
            if (this.previousCall == null) {
                this.previousCall = dbCall;
                this.parameters.add(dbCall.getParameters());
            } else if (this.previousCall.getSQLString().equals(dbCall.getSQLString()) && this.parameters.size() < this.maxBatchSize) {
                this.parameters.add(dbCall.getParameters());
            } else {
                this.executeBatchedStatements(session);
                this.appendCall(session, dbCall);
            }
            this.lastCallAppended = dbCall;
            if (((ModifyQuery)dbCall.getQuery()).forceBatchStatementExecution()) {
                this.executeBatchedStatements(session);
            }
        } else {
            this.executeBatchedStatements(session);
            this.switchMechanisms(session, dbCall);
        }
    }

    @Override
    public void clear() {
        this.previousCall = null;
        this.parameters.clear();
        this.statementCount = 0;
        this.executionCount = 0;
        this.clearCacheQueryTimeout();
        this.lastCallAppended = null;
    }

    @Override
    public void executeBatchedStatements(AbstractSession session) {
        if (this.parameters.isEmpty()) {
            return;
        }
        try {
            this.databaseAccessor.incrementCallCount(session);
            if (session.shouldLog(3, "sql")) {
                session.log(2, "sql", "begin_batch_statements", null, this.databaseAccessor);
                session.log(3, "sql", this.previousCall.getSQLString(), null, this.databaseAccessor, false);
                Iterator iterator = this.parameters.iterator();
                while (iterator.hasNext()) {
                    StringWriter writer = new StringWriter();
                    DatabaseCall.appendLogParameters((Collection)iterator.next(), this.databaseAccessor, writer, session);
                    session.log(3, "sql", writer.toString(), null, this.databaseAccessor, false);
                }
                session.log(2, "sql", "end_batch_statements", null, this.databaseAccessor);
            }
            PreparedStatement statement = this.prepareBatchStatements(session);
            this.executionCount += this.databaseAccessor.executeJDK12BatchStatement(statement, this.lastCallAppended, session, true);
            ++this.databaseAccessor.writeStatementsCount;
            if (this.previousCall.hasOptimisticLock() && this.executionCount != this.statementCount) {
                throw OptimisticLockException.batchStatementExecutionFailure();
            }
        }
        finally {
            this.clear();
        }
    }

    protected void switchMechanisms(AbstractSession session, DatabaseCall dbCall) {
        this.databaseAccessor.setActiveBatchWritingMechanismToDynamicSQL();
        this.databaseAccessor.getActiveBatchWritingMechanism().appendCall(session, dbCall);
    }

    protected PreparedStatement prepareBatchStatements(AbstractSession session) throws DatabaseException {
        PreparedStatement statement = null;
        try {
            session.startOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            try {
                org.eclipse.persistence.platform.database.DatabasePlatform platform = session.getPlatform();
                boolean shouldUnwrapConnection = platform.usesNativeBatchWriting();
                statement = (PreparedStatement)this.databaseAccessor.prepareStatement(this.previousCall, session, shouldUnwrapConnection);
                platform.prepareBatchStatement(statement, this.maxBatchSize);
                if (this.queryTimeoutCache > 0) {
                    statement.setQueryTimeout(this.queryTimeoutCache);
                }
                int statementSize = this.parameters.size();
                int statementIndex = 0;
                while (statementIndex < statementSize) {
                    List parameterList = (List)this.parameters.get(statementIndex);
                    int size = parameterList.size();
                    int index = 0;
                    while (index < size) {
                        platform.setParameterValueInDatabaseCall(parameterList.get(index), statement, index + 1, session);
                        ++index;
                    }
                    ++this.statementCount;
                    this.executionCount += platform.addBatch(statement);
                    ++statementIndex;
                }
            }
            finally {
                session.endOperationProfile("Timer:SqlPrepare", null, Integer.MAX_VALUE);
            }
        }
        catch (SQLException exception) {
            DatabaseException exceptionToThrow = this.databaseAccessor.processExceptionForCommError(session, exception, this.lastCallAppended);
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException sQLException) {}
            if (exceptionToThrow == null) {
                throw DatabaseException.sqlException(exception, this.databaseAccessor, session, false);
            }
            throw exceptionToThrow;
        }
        catch (RuntimeException exception) {
            try {
                this.databaseAccessor.closeStatement(statement, session, null);
            }
            catch (SQLException sQLException) {}
            throw exception;
        }
        return statement;
    }
}

