/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.rmi.Remote;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

public class RMIIIOPServerImpl
extends RMIServerImpl {
    private final Map env;
    private final AccessControlContext callerACC;

    public RMIIIOPServerImpl(Map map) throws IOException {
        super(map);
        this.env = map == null ? Collections.EMPTY_MAP : map;
        this.callerACC = AccessController.getContext();
    }

    protected void export() throws IOException {
        PortableRemoteObject.exportObject((Remote)this);
    }

    protected String getProtocol() {
        return "iiop";
    }

    public Remote toStub() throws IOException {
        Remote remote = PortableRemoteObject.toStub((Remote)this);
        return remote;
    }

    protected RMIConnection makeClient(String string, Subject subject) throws IOException {
        if (string == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl rMIConnectionImpl = new RMIConnectionImpl(this, string, this.getDefaultClassLoader(), subject, this.env);
        PortableRemoteObject.exportObject((Remote)rMIConnectionImpl);
        return rMIConnectionImpl;
    }

    protected void closeClient(RMIConnection rMIConnection) throws IOException {
        PortableRemoteObject.unexportObject((Remote)rMIConnection);
    }

    protected void closeServer() throws IOException {
        PortableRemoteObject.unexportObject((Remote)this);
    }

    RMIConnection doNewClient(final Object object) throws IOException {
        try {
            return (RMIConnection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return RMIIIOPServerImpl.this.superDoNewClient(object);
                }
            }, this.callerACC);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    RMIConnection superDoNewClient(Object object) throws IOException {
        return super.doNewClient(object);
    }
}

