/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import javax.cache.CacheManager;
import javax.cache.CachingShutdownException;
import javax.cache.OptionalFeature;
import javax.cache.spi.AnnotationProvider;
import javax.cache.spi.CachingProvider;

public final class Caching {
    public static final String DEFAULT_CACHE_MANAGER_NAME = "__default__";

    private Caching() {
    }

    public static CacheManager getCacheManager() {
        return Caching.getCacheManager(DEFAULT_CACHE_MANAGER_NAME);
    }

    public static CacheManager getCacheManager(ClassLoader classLoader) {
        return Caching.getCacheManager(classLoader, DEFAULT_CACHE_MANAGER_NAME);
    }

    public static CacheManager getCacheManager(String name) {
        return CachingSingleton.INSTANCE.getCacheManager(name);
    }

    public static CacheManager getCacheManager(ClassLoader classLoader, String name) {
        return CachingSingleton.INSTANCE.getCacheManager(classLoader, name);
    }

    public static void close() throws CachingShutdownException {
        CachingSingleton.INSTANCE.close();
    }

    public static boolean close(ClassLoader classLoader) throws CachingShutdownException {
        return CachingSingleton.INSTANCE.close(classLoader);
    }

    public static boolean close(ClassLoader classLoader, String name) throws CachingShutdownException {
        return CachingSingleton.INSTANCE.close(classLoader, name);
    }

    public static boolean isSupported(OptionalFeature optionalFeature) {
        switch (optionalFeature) {
            case ANNOTATIONS: {
                AnnotationProvider annotationProvider = ServiceFactoryHolder.INSTANCE.getAnnotationProvider();
                return annotationProvider != null && annotationProvider.isSupported(optionalFeature);
            }
        }
        return ServiceFactoryHolder.INSTANCE.getServiceFactory().isSupported(optionalFeature);
    }

    private static final class CachingSingleton {
        public static final CachingSingleton INSTANCE = new CachingSingleton(ServiceFactoryHolder.INSTANCE.getServiceFactory());
        private final Map<ClassLoader, Map<String, CacheManager>> cacheManagers = new HashMap<ClassLoader, Map<String, CacheManager>>();
        private final CachingProvider cachingProvider;

        private CachingSingleton(CachingProvider cachingProvider) {
            this.cachingProvider = cachingProvider;
        }

        public CacheManager getCacheManager(String name) {
            ClassLoader classLoader = this.cachingProvider.getDefaultClassLoader();
            return this.getCacheManager(classLoader, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CacheManager getCacheManager(ClassLoader classLoader, String name) {
            if (classLoader == null) {
                throw new NullPointerException("classLoader");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            Map<ClassLoader, Map<String, CacheManager>> map = this.cacheManagers;
            synchronized (map) {
                CacheManager cacheManager;
                Map<String, CacheManager> map2 = this.cacheManagers.get(classLoader);
                if (map2 == null) {
                    map2 = new HashMap<String, CacheManager>();
                    this.cacheManagers.put(classLoader, map2);
                }
                if ((cacheManager = map2.get(name)) == null) {
                    cacheManager = this.cachingProvider.createCacheManager(classLoader, name);
                    map2.put(name, cacheManager);
                }
                return cacheManager;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws CachingShutdownException {
            Map<ClassLoader, Map<String, CacheManager>> map = this.cacheManagers;
            synchronized (map) {
                IdentityHashMap<CacheManager, Exception> failures = new IdentityHashMap<CacheManager, Exception>();
                for (Map<String, CacheManager> cacheManagerMap : this.cacheManagers.values()) {
                    try {
                        this.shutdown(cacheManagerMap);
                    }
                    catch (CachingShutdownException e) {
                        failures.putAll(e.getFailures());
                    }
                }
                this.cacheManagers.clear();
                if (!failures.isEmpty()) {
                    throw new CachingShutdownException(failures);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean close(ClassLoader classLoader) throws CachingShutdownException {
            Map<String, CacheManager> cacheManagerMap;
            Map<ClassLoader, Map<String, CacheManager>> map = this.cacheManagers;
            synchronized (map) {
                cacheManagerMap = this.cacheManagers.remove(classLoader);
            }
            if (cacheManagerMap == null) {
                return false;
            }
            this.shutdown(cacheManagerMap);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean close(ClassLoader classLoader, String name) throws CachingShutdownException {
            CacheManager cacheManager;
            Map<ClassLoader, Map<String, CacheManager>> map = this.cacheManagers;
            synchronized (map) {
                Map<String, CacheManager> cacheManagerMap = this.cacheManagers.get(classLoader);
                cacheManager = cacheManagerMap.remove(name);
                if (cacheManagerMap.isEmpty()) {
                    this.cacheManagers.remove(classLoader);
                }
            }
            if (cacheManager == null) {
                return false;
            }
            cacheManager.shutdown();
            return true;
        }

        private void shutdown(Map<String, CacheManager> cacheManagerMap) throws CachingShutdownException {
            IdentityHashMap<CacheManager, Exception> failures = new IdentityHashMap<CacheManager, Exception>();
            for (CacheManager cacheManager : cacheManagerMap.values()) {
                try {
                    cacheManager.shutdown();
                }
                catch (Exception e) {
                    failures.put(cacheManager, e);
                }
            }
            if (!failures.isEmpty()) {
                throw new CachingShutdownException(failures);
            }
        }
    }

    private static enum ServiceFactoryHolder {
        INSTANCE;

        private final CachingProvider serviceFactory = AccessController.doPrivileged(new PrivilegedAction<CachingProvider>(){

            @Override
            public CachingProvider run() {
                ServiceLoader<CachingProvider> serviceLoader = ServiceLoader.load(CachingProvider.class);
                Iterator<CachingProvider> it = serviceLoader.iterator();
                if (it.hasNext()) {
                    return it.next();
                }
                return null;
            }
        });
        private final AnnotationProvider annotationProvider = AccessController.doPrivileged(new PrivilegedAction<AnnotationProvider>(){

            @Override
            public AnnotationProvider run() {
                ServiceLoader<AnnotationProvider> serviceLoader = ServiceLoader.load(AnnotationProvider.class);
                Iterator<AnnotationProvider> it = serviceLoader.iterator();
                if (it.hasNext()) {
                    return it.next();
                }
                return null;
            }
        });

        public CachingProvider getServiceFactory() {
            if (this.serviceFactory == null) {
                throw new IllegalStateException("No CachingProvider found in classpath.");
            }
            return this.serviceFactory;
        }

        public AnnotationProvider getAnnotationProvider() {
            return this.annotationProvider;
        }
    }
}

