/*
 * Decompiled with CFR 0.152.
 */
package javax.cache;

import java.util.concurrent.TimeUnit;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public interface CacheConfiguration {
    public boolean isReadThrough();

    public boolean isWriteThrough();

    public boolean isStoreByValue();

    public boolean isStatisticsEnabled();

    public void setStatisticsEnabled(boolean var1);

    public boolean isTransactionEnabled();

    public IsolationLevel getTransactionIsolationLevel();

    public Mode getTransactionMode();

    public CacheLoader getCacheLoader();

    public CacheWriter getCacheWriter();

    public Duration getExpiry(ExpiryType var1);

    public static enum ExpiryType {
        MODIFIED,
        ACCESSED;

    }

    public static class Duration {
        public static final Duration ETERNAL = new Duration(TimeUnit.SECONDS, 0L);
        private final TimeUnit timeUnit;
        private final long durationAmount;

        public Duration(TimeUnit timeUnit, long durationAmount) {
            if (timeUnit == null) {
                throw new NullPointerException();
            }
            switch (timeUnit) {
                case NANOSECONDS: 
                case MICROSECONDS: {
                    throw new IllegalArgumentException("Must specify a TimeUnit of milliseconds or higher.");
                }
            }
            this.timeUnit = timeUnit;
            if (durationAmount < 0L) {
                throw new IllegalArgumentException("Cannot specify a negative durationAmount.");
            }
            this.durationAmount = durationAmount;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public long getDurationAmount() {
            return this.durationAmount;
        }

        public boolean equals(Object o) {
            long time2;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Duration duration = (Duration)o;
            long time1 = this.timeUnit.toMillis(this.durationAmount);
            return time1 == (time2 = duration.timeUnit.toMillis(duration.durationAmount));
        }

        public int hashCode() {
            return Long.valueOf(this.timeUnit.toMillis(this.durationAmount)).hashCode();
        }
    }
}

