/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter.model;

import gherkin.formatter.Formatter;
import gherkin.formatter.Mappable;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.CommentHolder;
import gherkin.formatter.model.Range;
import java.util.List;

public abstract class BasicStatement
extends Mappable
implements CommentHolder {
    private final List<Comment> comments;
    private final String keyword;
    private final String name;
    private final int line;

    public BasicStatement(List<Comment> comments, String keyword, String name, int line) {
        this.comments = comments;
        this.keyword = keyword;
        this.name = name;
        this.line = line;
    }

    public Range getLineRange() {
        int first = this.getComments().size() > 0 ? this.getComments().get(0).getLine() : this.getFirstNonCommentLine();
        return new Range(first, this.getLine());
    }

    protected int getFirstNonCommentLine() {
        return this.line;
    }

    @Override
    public List<Comment> getComments() {
        return this.comments;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getName() {
        return this.name;
    }

    public int getLine() {
        return this.line;
    }

    public abstract void replay(Formatter var1);
}

