/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import gherkin.formatter.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TagExpression {
    private final Map<String, Integer> limits = new HashMap<String, Integer>();
    private And and = new And();

    public TagExpression(List<String> tagExpressions) {
        for (String tagExpression : tagExpressions) {
            this.add(tagExpression.split("\\s*,\\s*"));
        }
    }

    public boolean eval(Collection<Tag> tags) {
        return this.and.isEmpty() || this.and.eval(tags);
    }

    public Map<String, Integer> limits() {
        return this.limits;
    }

    private void add(String[] tags) {
        Or or = new Or();
        for (String tag : tags) {
            boolean negation;
            if ((tag = tag.trim()).startsWith("~")) {
                tag = tag.substring(1);
                negation = true;
            } else {
                negation = false;
            }
            String[] tagAndLimit = tag.split(":");
            if (tagAndLimit.length == 2) {
                tag = tagAndLimit[0];
                int limit = Integer.parseInt(tagAndLimit[1]);
                if (this.limits.containsKey(tag) && this.limits.get(tag) != limit) {
                    throw new BadTagLimitException(tag, this.limits.get(tag), limit);
                }
                this.limits.put(tag, limit);
            }
            if (negation) {
                or.add(new Not(new TagExp(tag)));
                continue;
            }
            or.add(new TagExp(tag));
        }
        this.and.add(or);
    }

    private class BadTagLimitException
    extends RuntimeException {
        public BadTagLimitException(String tag, int limitA, int limitB) {
            super("Inconsistent tag limits for " + tag + ": " + limitA + " and " + limitB);
        }
    }

    private class BadTagException
    extends RuntimeException {
        public BadTagException(String tagName) {
            super("Bad tag: \"" + tagName + "\"");
        }
    }

    private class TagExp
    implements Expression {
        private final String tagName;

        public TagExp(String tagName) {
            if (!tagName.startsWith("@")) {
                throw new BadTagException(tagName);
            }
            this.tagName = tagName;
        }

        @Override
        public boolean eval(Collection<Tag> tags) {
            for (Tag tag : tags) {
                if (!this.tagName.equals(tag.getName())) continue;
                return true;
            }
            return false;
        }
    }

    private class Or
    implements Expression {
        private List<Expression> expressions = new ArrayList<Expression>();

        private Or() {
        }

        public void add(Expression expression) {
            this.expressions.add(expression);
        }

        @Override
        public boolean eval(Collection<Tag> tags) {
            Expression expression;
            boolean result = false;
            Iterator<Expression> i$ = this.expressions.iterator();
            while (i$.hasNext() && !(result = (expression = i$.next()).eval(tags))) {
            }
            return result;
        }
    }

    private class And
    implements Expression {
        private List<Expression> expressions = new ArrayList<Expression>();

        private And() {
        }

        public void add(Expression expression) {
            this.expressions.add(expression);
        }

        @Override
        public boolean eval(Collection<Tag> tags) {
            Expression expression;
            boolean result = true;
            Iterator<Expression> i$ = this.expressions.iterator();
            while (i$.hasNext() && (result = (expression = i$.next()).eval(tags))) {
            }
            return result;
        }

        public boolean isEmpty() {
            return this.expressions.isEmpty();
        }
    }

    private class Not
    implements Expression {
        private final Expression expression;

        public Not(Expression expression) {
            this.expression = expression;
        }

        @Override
        public boolean eval(Collection<Tag> tags) {
            return !this.expression.eval(tags);
        }
    }

    private static interface Expression {
        public boolean eval(Collection<Tag> var1);
    }
}

