/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import gherkin.formatter.PrettyFormatter;
import gherkin.parser.Parser;
import gherkin.util.FixJava;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class Main {
    private FileFilter featureFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".feature");
        }
    };
    private Parser parser;
    private final Writer out;

    public Main(Writer out) {
        this.out = out;
        PrettyFormatter formatter = new PrettyFormatter(out, false, true);
        this.parser = new Parser(formatter);
    }

    private void scanAll(File file) throws IOException {
        this.walk(file);
        this.out.append('\n');
        this.out.close();
    }

    private void walk(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles(this.featureFilter)) {
                this.walk(child);
            }
        } else {
            this.parse(file);
        }
    }

    private void parse(File file) {
        try {
            String input = FixJava.readReader(new FileReader(file));
            this.parser.parse(input, file.getPath(), 0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void main(String[] args) throws IOException {
        new Main(new OutputStreamWriter((OutputStream)System.out, "UTF-8")).scanAll(new File(args[0]));
    }
}

