/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.CucumberException;
import cucumber.runtime.io.DelegatingResourceIteratorFactory;
import cucumber.runtime.io.FlatteningIterator;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceIteratorFactory;
import cucumber.runtime.io.ZipThenFileResourceIteratorFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;

public class ClasspathResourceIterable
implements Iterable<Resource> {
    private final ResourceIteratorFactory resourceIteratorFactory = new DelegatingResourceIteratorFactory(new ZipThenFileResourceIteratorFactory());
    private final ClassLoader classLoader;
    private final String path;
    private final String suffix;

    public ClasspathResourceIterable(ClassLoader classLoader, String path, String suffix) {
        this.classLoader = classLoader;
        this.path = path;
        this.suffix = suffix;
    }

    @Override
    public Iterator<Resource> iterator() {
        try {
            FlatteningIterator<Resource> iterator = new FlatteningIterator<Resource>();
            Enumeration<URL> resources = this.classLoader.getResources(this.path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Iterator<Resource> resourceIterator = this.resourceIteratorFactory.createIterator(url, this.path, this.suffix);
                iterator.push(resourceIterator);
            }
            return iterator;
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }

    static boolean hasSuffix(String suffix, String name) {
        return suffix == null || name.endsWith(suffix);
    }

    static String getPath(URL url) {
        try {
            return URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CucumberException("Encoding problem", e);
        }
    }
}

