/*
 * Decompiled with CFR 0.152.
 */
package gherkin;

import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.reflect.TypeToken;
import gherkin.formatter.PrettyFormatter;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import gherkin.lexer.Lexer;
import gherkin.lexer.Listener;
import gherkin.util.FixJava;
import gherkin.util.Mapper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public class I18n {
    private static final List<String> FEATURE_ELEMENT_KEYWORD_KEYS = Arrays.asList("feature", "background", "scenario", "scenario_outline", "examples");
    private static final List<String> STEP_KEYWORD_KEYS = Arrays.asList("given", "when", "then", "and", "but");
    private static final List<String> KEYWORD_KEYS = new ArrayList<String>();
    private static final Mapper QUOTE_MAPPER;
    private static final Mapper CODE_KEYWORD_MAPPER;
    private static Map<String, Map<String, String>> I18N;
    private final String isoCode;
    private final Locale locale;
    private final Map<String, List<String>> keywords;

    public static String codeKeywordFor(String keyword) {
        return keyword.replaceAll("[\\s',!]", "");
    }

    public static List<I18n> getAll() throws IOException {
        ArrayList<I18n> result = new ArrayList<I18n>();
        TreeSet<String> isoCodes = new TreeSet<String>(I18N.keySet());
        for (String isoCode : isoCodes) {
            result.add(new I18n(isoCode));
        }
        return result;
    }

    public I18n(String isoCode) {
        this.isoCode = isoCode;
        this.locale = this.localeFor(this.isoCode);
        this.keywords = new HashMap<String, List<String>>();
        Map<String, String> keywordMap = I18N.get(isoCode);
        for (Map.Entry<String, String> entry : keywordMap.entrySet()) {
            List<String> keywordList = Arrays.asList(entry.getValue().split("\\|"));
            if (STEP_KEYWORD_KEYS.contains(entry.getKey())) {
                ArrayList<String> stepKeywords = new ArrayList<String>();
                for (String s : keywordList) {
                    stepKeywords.add((s + " ").replaceFirst("< $", ""));
                }
                keywordList = stepKeywords;
            }
            this.keywords.put(entry.getKey(), Collections.unmodifiableList(keywordList));
        }
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getUnderscoredIsoCode() {
        return this.getIsoCode().replaceAll("[\\s-]", "_").toLowerCase();
    }

    public Lexer lexer(Listener listener) {
        String qualifiedI18nLexerClassName = "gherkin.lexer." + this.capitalize(this.getUnderscoredIsoCode());
        try {
            Class<?> delegateClass = this.getClass().getClassLoader().loadClass(qualifiedI18nLexerClassName);
            return (Lexer)delegateClass.getConstructor(Listener.class).newInstance(listener);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't load lexer class: " + qualifiedI18nLexerClassName, e);
        }
    }

    private String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public List<String> keywords(String key) {
        if (!this.keywords.containsKey(key)) {
            throw new RuntimeException("No such key: " + key + ". Available keys: " + this.keywords.keySet());
        }
        return this.keywords.get(key);
    }

    public List<String> getCodeKeywords() {
        List<String> result = FixJava.map(this.getStepKeywords(), CODE_KEYWORD_MAPPER);
        result.remove("*");
        return result;
    }

    public List<String> getStepKeywords() {
        TreeSet result = new TreeSet();
        for (String keyword : STEP_KEYWORD_KEYS) {
            result.addAll(this.keywords.get(keyword));
        }
        return new ArrayList<String>(result);
    }

    public String getKeywordTable() {
        StringWriter writer = new StringWriter();
        PrettyFormatter pf = new PrettyFormatter(writer, true, false);
        ArrayList<DataTableRow> table = new ArrayList<DataTableRow>();
        for (String key : KEYWORD_KEYS) {
            List<String> cells = Arrays.asList(key, FixJava.join(FixJava.map(this.keywords(key), QUOTE_MAPPER), ", "));
            table.add(new DataTableRow(Collections.<Comment>emptyList(), cells, -1));
        }
        for (String key : STEP_KEYWORD_KEYS) {
            ArrayList codeKeywordList = new ArrayList(this.keywords.get(key));
            codeKeywordList.remove("* ");
            String codeKeywords = FixJava.join(FixJava.map(FixJava.map(codeKeywordList, CODE_KEYWORD_MAPPER), QUOTE_MAPPER), ", ");
            List<String> cells = Arrays.asList(key + " (code)", codeKeywords);
            table.add(new DataTableRow(Collections.<Comment>emptyList(), cells, -1));
        }
        pf.table(table);
        return writer.getBuffer().toString();
    }

    private Locale localeFor(String isoString) {
        String[] languageAndCountry = isoString.split("-");
        if (languageAndCountry.length == 1) {
            return new Locale(isoString);
        }
        return new Locale(languageAndCountry[0], languageAndCountry[1]);
    }

    static {
        KEYWORD_KEYS.addAll(FEATURE_ELEMENT_KEYWORD_KEYS);
        KEYWORD_KEYS.addAll(STEP_KEYWORD_KEYS);
        QUOTE_MAPPER = new Mapper(){

            public String map(Object o) {
                return '\"' + (String)o + '\"';
            }
        };
        CODE_KEYWORD_MAPPER = new Mapper(){

            public String map(Object keyword) {
                return I18n.codeKeywordFor((String)keyword);
            }
        };
        try {
            I18N = (Map)new Gson().fromJson((Reader)new InputStreamReader(I18n.class.getResourceAsStream("/gherkin/i18n.json"), "UTF-8"), new TypeToken<Map<String, Map<String, String>>>(){}.getType());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

