/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.autocomplete;

import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaStepdef {
    private static final Gson GSON = new GsonBuilder().create();
    public final SortedSet<MetaStep> steps = new TreeSet<MetaStep>();
    public String source;
    public String flags;
    private transient Pattern pattern;

    public boolean matches(String text) {
        Pattern p = this.pattern();
        Matcher m = p.matcher(text);
        return m.matches() || m.hitEnd();
    }

    private Pattern pattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.source);
        }
        return this.pattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaStepdef that = (MetaStepdef)o;
        if (!this.flags.equals(that.flags)) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        return this.steps.equals(that.steps);
    }

    public int hashCode() {
        int result = this.steps.hashCode();
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.flags.hashCode();
        return result;
    }

    public String toString() {
        return GSON.toJson(this);
    }

    public static class MetaArgument {
        public int offset;
        public String val;
    }

    public static class MetaStep
    implements Comparable<MetaStep> {
        public String name;
        public final List<MetaArgument> args = new ArrayList<MetaArgument>();

        @Override
        public int compareTo(MetaStep other) {
            return this.name.compareTo(other.name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetaStep metaStep = (MetaStep)o;
            if (!((Object)this.args).equals(metaStep.args)) {
                return false;
            }
            return this.name.equals(metaStep.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + ((Object)this.args).hashCode();
            return result;
        }
    }
}

