/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.PathWithLines;
import cucumber.runtime.Utils;
import cucumber.runtime.formatter.ColorAware;
import cucumber.runtime.formatter.FormatterFactory;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.util.FixJava;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class RuntimeOptions {
    public static final String VERSION = ResourceBundle.getBundle("cucumber.version").getString("cucumber-jvm.version");
    public static final String USAGE = FixJava.readResource("/cucumber/runtime/USAGE.txt");
    public final List<String> glue = new ArrayList<String>();
    public final List<Object> filters = new ArrayList<Object>();
    public final List<Formatter> formatters = new ArrayList<Formatter>();
    public final List<String> featurePaths = new ArrayList<String>();
    private final FormatterFactory formatterFactory = new FormatterFactory();
    public File dotCucumber;
    public boolean dryRun;
    public boolean strict = false;
    public boolean monochrome = false;

    public RuntimeOptions(Properties properties, String ... argv) {
        this.parse(new ArrayList<String>(Arrays.asList(argv)));
        if (properties.containsKey("cucumber.options")) {
            this.parse(new ArrayList<String>(Arrays.asList(properties.getProperty("cucumber.options").split(" "))));
        }
        if (this.formatters.isEmpty()) {
            this.formatters.add(this.formatterFactory.create("progress"));
        }
        for (Formatter formatter : this.formatters) {
            if (!(formatter instanceof ColorAware)) continue;
            ColorAware colorAware = (ColorAware)((Object)formatter);
            colorAware.setMonochrome(this.monochrome);
        }
    }

    private void parse(List<String> args) {
        ArrayList<Object> parsedFilters = new ArrayList<Object>();
        while (!args.isEmpty()) {
            String arg = args.remove(0);
            if (arg.equals("--help") || arg.equals("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            if (arg.equals("--version") || arg.equals("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (arg.equals("--glue") || arg.equals("-g")) {
                String gluePath = args.remove(0);
                this.glue.add(gluePath);
                continue;
            }
            if (arg.equals("--tags") || arg.equals("-t")) {
                parsedFilters.add(args.remove(0));
                continue;
            }
            if (arg.equals("--format") || arg.equals("-f")) {
                this.formatters.add(this.formatterFactory.create(args.remove(0)));
                continue;
            }
            if (arg.equals("--dotcucumber")) {
                this.dotCucumber = new File(args.remove(0));
                continue;
            }
            if (arg.equals("--no-dry-run") || arg.equals("--dry-run") || arg.equals("-d")) {
                this.dryRun = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-strict") || arg.equals("--strict") || arg.equals("-s")) {
                this.strict = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-monochrome") || arg.equals("--monochrome") || arg.equals("-m")) {
                this.monochrome = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--name") || arg.equals("-n")) {
                String nextArg = args.remove(0);
                Pattern patternFilter = Pattern.compile(nextArg);
                parsedFilters.add(patternFilter);
                continue;
            }
            PathWithLines pathWithLines = new PathWithLines(arg);
            this.featurePaths.add(pathWithLines.path);
            parsedFilters.addAll(pathWithLines.lines);
        }
        if (!parsedFilters.isEmpty()) {
            this.filters.clear();
            this.filters.addAll(parsedFilters);
        }
    }

    public List<CucumberFeature> cucumberFeatures(ResourceLoader resourceLoader) {
        return CucumberFeature.load(resourceLoader, this.featurePaths, this.filters);
    }

    public Formatter formatter(ClassLoader classLoader) {
        return (Formatter)Proxy.newProxyInstance(classLoader, new Class[]{Formatter.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Formatter formatter : RuntimeOptions.this.formatters) {
                    Utils.invoke(formatter, method, 0, args);
                }
                return null;
            }
        });
    }

    public Reporter reporter(ClassLoader classLoader) {
        return (Reporter)Proxy.newProxyInstance(classLoader, new Class[]{Reporter.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Formatter formatter : RuntimeOptions.this.formatters) {
                    if (!(formatter instanceof Reporter)) continue;
                    Utils.invoke(formatter, method, 0, args);
                }
                return null;
            }
        });
    }
}

