/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Delimiter;
import cucumber.api.Format;
import cucumber.api.Transform;
import cucumber.api.Transformer;
import cucumber.deps.com.thoughtworks.xstream.annotations.XStreamConverter;
import cucumber.deps.com.thoughtworks.xstream.converters.SingleValueConverter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.xstream.LocalizedXStreams;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ParameterInfo {
    public static final String DEFAULT_DELIMITER = ",\\s?";
    private final Type type;
    private final String format;
    private final String delimiter;
    private final Transformer transformer;

    public static List<ParameterInfo> fromMethod(Method method) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < genericParameterTypes.length; ++i) {
            String dateFormat = null;
            String delimiter = DEFAULT_DELIMITER;
            Transformer transformer = null;
            for (Annotation annotation : annotations[i]) {
                if (annotation instanceof Format) {
                    dateFormat = ((Format)annotation).value();
                }
                if (annotation instanceof Delimiter) {
                    delimiter = ((Delimiter)annotation).value();
                }
                if (!(annotation instanceof Transform)) continue;
                try {
                    transformer = ((Transform)annotation).value().newInstance();
                }
                catch (InstantiationException e) {
                    throw new CucumberException(e);
                }
                catch (IllegalAccessException e) {
                    throw new CucumberException(e);
                }
            }
            result.add(new ParameterInfo(genericParameterTypes[i], dateFormat, delimiter, transformer));
        }
        return result;
    }

    public ParameterInfo(Type type, String format, String delimiter, Transformer transformer) {
        this.type = type;
        this.format = format;
        this.delimiter = delimiter;
        this.transformer = transformer;
    }

    public Class<?> getRawType() {
        return this.getRawType(this.type);
    }

    private Class<?> getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return this.type.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(String value, LocalizedXStreams.LocalizedXStream xStream, Locale locale) {
        try {
            SingleValueConverter converter;
            xStream.setParameterType(this);
            xStream.processAnnotations(this.getRawType());
            if (this.transformer != null) {
                this.transformer.setParameterInfoAndLocale(this, locale);
                converter = this.transformer;
            } else {
                converter = List.class.isAssignableFrom(this.getRawType()) ? this.getListConverter(this.type, xStream, locale) : this.getConverter(this.getRawType(), xStream, locale);
                if (converter == null) {
                    throw new CucumberException(String.format("Don't know how to convert \"%s\" into %s.\nTry writing your own converter:\n\n@%s(%sConverter.class)\npublic class %s {}\n", value, this.getRawType().getName(), XStreamConverter.class.getName(), this.getRawType().getSimpleName(), this.getRawType().getSimpleName()));
                }
            }
            Object object = converter.fromString(value);
            return object;
        }
        finally {
            xStream.unsetParameterInfo();
        }
    }

    private SingleValueConverter getListConverter(Type type, LocalizedXStreams.LocalizedXStream xStream, Locale locale) {
        Class<Object> elementType = type instanceof ParameterizedType ? this.getRawType(((ParameterizedType)type).getActualTypeArguments()[0]) : Object.class;
        SingleValueConverter elementConverter = this.getConverter(elementType, xStream, locale);
        if (elementConverter == null) {
            return null;
        }
        return xStream.createListConverter(this.delimiter, elementConverter);
    }

    private SingleValueConverter getConverter(Class<?> type, LocalizedXStreams.LocalizedXStream xStream, Locale locale) {
        if (type.isEnum()) {
            return xStream.createEnumConverter(locale, type);
        }
        return xStream.getSingleValueConverter(type);
    }

    public String getFormat() {
        return this.format;
    }
}

