/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.util;

import java.io.IOException;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.ExpandableBuffer;

public class SharedOutputBuffer
extends ExpandableBuffer
implements ContentOutputBuffer {
    private static final int READY = 0;
    private static final int STREAMING = 1;
    private static final int CLOSING = 2;
    private static final int CLOSED = 4;
    private final IOControl ioctrl;
    private final Object mutex;
    private volatile boolean shutdown = false;
    private volatile int state;

    public SharedOutputBuffer(int buffersize, IOControl ioctrl) {
        super(buffersize);
        if (ioctrl == null) {
            throw new IllegalArgumentException("I/O content control may not be null");
        }
        this.ioctrl = ioctrl;
        this.mutex = new Object();
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.shutdown) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.clear();
            this.state = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int produceContent(ContentEncoder encoder) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.setOutputMode();
            int bytesWritten = 0;
            if (this.hasData()) {
                bytesWritten = encoder.write(this.buffer);
                if (encoder.isCompleted()) {
                    this.state = 4;
                }
            }
            if (!this.hasData()) {
                if (this.state == 2 && !encoder.isCompleted()) {
                    encoder.complete();
                    this.state = 4;
                } else {
                    this.ioctrl.suspendOutput();
                }
            }
            this.mutex.notifyAll();
            return bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.shutdown || this.state == 2 || this.state == 4) {
                throw new IllegalStateException("Buffer already closed for writing");
            }
            this.state = 1;
            this.setInputMode();
            int remaining = len;
            while (remaining > 0) {
                if (!this.buffer.hasRemaining()) {
                    this.flush();
                    this.setInputMode();
                }
                int chunk = Math.min(remaining, this.buffer.remaining());
                this.buffer.put(b, off, chunk);
                remaining -= chunk;
                off += chunk;
            }
        }
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            return;
        }
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.shutdown || this.state == 2 || this.state == 4) {
                throw new IllegalStateException("Buffer already closed for writing");
            }
            this.state = 1;
            this.setInputMode();
            if (!this.buffer.hasRemaining()) {
                this.flush();
                this.setInputMode();
            }
            this.buffer.put((byte)b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                while (this.hasData() && !this.shutdown) {
                    this.ioctrl.requestOutput();
                    this.mutex.wait();
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Interrupted while flushing the content buffer");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCompleted() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            this.state = 2;
            try {
                while (this.hasData() && this.state != 4 && !this.shutdown) {
                    this.ioctrl.requestOutput();
                    this.mutex.wait();
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Interrupted while closing the content buffer");
            }
        }
    }
}

