/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.protocol.BufferedContent;
import org.apache.http.nio.protocol.ContentOutputStream;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.protocol.HttpRequestExecutionHandler;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.SimpleInputBuffer;
import org.apache.http.nio.util.SimpleOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

public class BufferingHttpClientHandler
implements NHttpClientHandler {
    private static final String CONN_STATE = "http.nio.conn-state";
    private HttpParams params;
    private HttpProcessor httpProcessor;
    private HttpRequestExecutionHandler execHandler;
    private ConnectionReuseStrategy connStrategy;
    private EventListener eventListener;

    public BufferingHttpClientHandler(HttpProcessor httpProcessor, HttpRequestExecutionHandler execHandler, ConnectionReuseStrategy connStrategy, HttpParams params) {
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null.");
        }
        if (execHandler == null) {
            throw new IllegalArgumentException("HTTP request execution handler may not be null.");
        }
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.httpProcessor = httpProcessor;
        this.execHandler = execHandler;
        this.connStrategy = connStrategy;
        this.params = params;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    private void shutdownConnection(HttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void connected(NHttpClientConnection conn, Object attachment) {
        HttpContext context = conn.getContext();
        if (conn instanceof HttpInetConnection) {
            InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
            int port = ((HttpInetConnection)conn).getRemotePort();
            if (address != null) {
                HttpHost host = new HttpHost(address.getHostName(), port);
                context.setAttribute("http.target_host", (Object)host);
            }
        }
        this.initialize(conn, attachment);
        ClientConnState connState = new ClientConnState();
        context.setAttribute(CONN_STATE, (Object)connState);
        if (this.eventListener != null) {
            InetAddress address = null;
            if (conn instanceof HttpInetConnection) {
                address = ((HttpInetConnection)conn).getRemoteAddress();
            }
            this.eventListener.connectionOpen(address);
        }
        this.requestReady(conn);
    }

    public void closed(NHttpClientConnection conn) {
        if (this.eventListener != null) {
            InetAddress address = null;
            if (conn instanceof HttpInetConnection) {
                address = ((HttpInetConnection)conn).getRemoteAddress();
            }
            this.eventListener.connectionClosed(address);
        }
    }

    public void exception(NHttpClientConnection conn, HttpException ex) {
        this.shutdownConnection(conn);
        if (this.eventListener != null) {
            this.eventListener.fatalProtocolException(ex);
        }
    }

    public void exception(NHttpClientConnection conn, IOException ex) {
        this.shutdownConnection(conn);
        if (this.eventListener != null) {
            this.eventListener.fatalIOException(ex);
        }
    }

    public void requestReady(NHttpClientConnection conn) {
        block5: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute(CONN_STATE);
            if (connState.getInputState() != 0) {
                return;
            }
            try {
                this.submitRequest(conn, connState);
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex);
                }
            }
            catch (HttpException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block5;
                this.eventListener.fatalProtocolException(ex);
            }
        }
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        block5: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute(CONN_STATE);
            connState.setInputState(32);
            ContentInputBuffer buffer = connState.getInbuffer();
            try {
                buffer.consumeContent(decoder);
                if (decoder.isCompleted()) {
                    connState.setInputState(64);
                    this.processResponse(conn, connState);
                }
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex);
                }
            }
            catch (HttpException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block5;
                this.eventListener.fatalProtocolException(ex);
            }
        }
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        block4: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute(CONN_STATE);
            if (connState.getOutputState() == 2) {
                conn.suspendOutput();
                return;
            }
            connState.setInputState(4);
            ContentOutputBuffer buffer = connState.getOutbuffer();
            try {
                buffer.produceContent(encoder);
                if (encoder.isCompleted()) {
                    connState.setInputState(8);
                }
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block4;
                this.eventListener.fatalIOException(ex);
            }
        }
    }

    public void responseReceived(NHttpClientConnection conn) {
        block8: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute(CONN_STATE);
            HttpResponse response = conn.getHttpResponse();
            HttpRequest request = connState.getRequest();
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 200) {
                    if (statusCode == 100 && connState.getOutputState() == 2) {
                        this.continueRequest(conn, connState);
                    }
                    return;
                }
                connState.setResponse(response);
                connState.setInputState(16);
                if (connState.getOutputState() == 2) {
                    this.cancelRequest(conn, connState);
                }
                if (!this.canResponseHaveBody(request, response)) {
                    this.processResponse(conn, connState);
                }
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex);
                }
            }
            catch (HttpException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block8;
                this.eventListener.fatalProtocolException(ex);
            }
        }
    }

    public void timeout(NHttpClientConnection conn) {
        block5: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute(CONN_STATE);
            try {
                if (connState.getOutputState() == 2) {
                    this.continueRequest(conn, connState);
                    return;
                }
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block5;
                this.eventListener.fatalIOException(ex);
            }
        }
        this.shutdownConnection(conn);
        if (this.eventListener != null) {
            InetAddress address = null;
            if (conn instanceof HttpInetConnection) {
                address = ((HttpInetConnection)conn).getRemoteAddress();
            }
            this.eventListener.connectionTimeout(address);
        }
    }

    private void initialize(NHttpClientConnection conn, Object attachment) {
        HttpContext context = conn.getContext();
        context.setAttribute("http.connection", (Object)conn);
        this.execHandler.initalizeContext(context, attachment);
    }

    private void submitRequest(NHttpClientConnection conn, ClientConnState connState) throws IOException, HttpException {
        connState.resetOutput();
        HttpContext context = conn.getContext();
        HttpRequest request = this.execHandler.submitRequest(context);
        if (request == null) {
            return;
        }
        request.getParams().setDefaults(this.params);
        context.setAttribute("http.request", (Object)request);
        this.httpProcessor.process(request, context);
        connState.setRequest(request);
        conn.submitRequest(request);
        connState.setOutputState(1);
        if (request instanceof HttpEntityEnclosingRequest) {
            if (((HttpEntityEnclosingRequest)request).expectContinue()) {
                int timeout = conn.getSocketTimeout();
                connState.setTimeout(timeout);
                timeout = this.params.getIntParameter("http.protocol.wait-for-continue", 3000);
                conn.setSocketTimeout(timeout);
                connState.setOutputState(2);
            } else {
                this.prepareRequestBody((HttpEntityEnclosingRequest)request, connState);
            }
        }
    }

    private void continueRequest(NHttpClientConnection conn, ClientConnState connState) throws IOException {
        HttpRequest request = connState.getRequest();
        int timeout = connState.getTimeout();
        conn.setSocketTimeout(timeout);
        this.prepareRequestBody((HttpEntityEnclosingRequest)request, connState);
        conn.requestOutput();
        connState.setOutputState(1);
    }

    private void cancelRequest(NHttpClientConnection conn, ClientConnState connState) throws IOException {
        int timeout = connState.getTimeout();
        conn.setSocketTimeout(timeout);
        conn.cancelRequest();
        connState.resetOutput();
    }

    private void prepareRequestBody(HttpEntityEnclosingRequest request, ClientConnState connState) throws IOException {
        HttpEntity entity = request.getEntity();
        if (entity != null) {
            ContentOutputStream outstream = new ContentOutputStream(connState.getOutbuffer());
            entity.writeTo((OutputStream)outstream);
            ((OutputStream)outstream).flush();
            ((OutputStream)outstream).close();
        }
    }

    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if (request != null && "HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    private void processResponse(NHttpClientConnection conn, ClientConnState connState) throws IOException, HttpException {
        HttpContext context = conn.getContext();
        HttpResponse response = connState.getResponse();
        if (response.getEntity() != null) {
            response.setEntity((HttpEntity)new BufferedContent(response.getEntity(), connState.getInbuffer()));
        }
        context.setAttribute("http.response", (Object)response);
        this.httpProcessor.process(response, context);
        this.execHandler.handleResponse(response, context);
        if (!this.connStrategy.keepAlive(response, context)) {
            conn.close();
        } else {
            connState.resetInput();
            conn.requestOutput();
        }
    }

    static class ClientConnState {
        public static final int READY = 0;
        public static final int REQUEST_SENT = 1;
        public static final int EXPECT_CONTINUE = 2;
        public static final int REQUEST_BODY_STREAM = 4;
        public static final int REQUEST_BODY_DONE = 8;
        public static final int RESPONSE_RECEIVED = 16;
        public static final int RESPONSE_BODY_STREAM = 32;
        public static final int RESPONSE_BODY_DONE = 64;
        private SimpleInputBuffer inbuffer;
        private ContentOutputBuffer outbuffer;
        private int inputState;
        private int outputState;
        private HttpRequest request;
        private HttpResponse response;
        private int timeout;

        public ContentInputBuffer getInbuffer() {
            if (this.inbuffer == null) {
                this.inbuffer = new SimpleInputBuffer(2048);
            }
            return this.inbuffer;
        }

        public ContentOutputBuffer getOutbuffer() {
            if (this.outbuffer == null) {
                this.outbuffer = new SimpleOutputBuffer(2048);
            }
            return this.outbuffer;
        }

        public int getInputState() {
            return this.inputState;
        }

        public void setInputState(int inputState) {
            this.inputState = inputState;
        }

        public int getOutputState() {
            return this.outputState;
        }

        public void setOutputState(int outputState) {
            this.outputState = outputState;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void resetInput() {
            this.inbuffer = null;
            this.response = null;
            this.inputState = 0;
        }

        public void resetOutput() {
            this.outbuffer = null;
            this.request = null;
            this.outputState = 0;
        }
    }
}

