/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.InterruptedIOException;
import org.apache.http.impl.nio.reactor.BaseIOReactor;
import org.apache.http.impl.nio.reactor.ChannelEntry;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.util.concurrent.ThreadFactory;

public abstract class AbstractMultiworkerIOReactor
implements IOReactor {
    private final int workerCount;
    private final ThreadFactory threadFactory;
    private final BaseIOReactor[] ioReactors;
    private final Worker[] workers;
    private final Thread[] threads;
    private volatile boolean shutdown;
    private int currentWorker = 0;

    public AbstractMultiworkerIOReactor(long selectTimeout, int workerCount, ThreadFactory threadFactory) throws IOReactorException {
        if (workerCount <= 0) {
            throw new IllegalArgumentException("Worker count may not be negative or zero");
        }
        this.workerCount = workerCount;
        this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory();
        this.ioReactors = new BaseIOReactor[workerCount];
        for (int i = 0; i < this.ioReactors.length; ++i) {
            this.ioReactors[i] = new BaseIOReactor(selectTimeout);
        }
        this.workers = new Worker[workerCount];
        this.threads = new Thread[workerCount];
    }

    protected void startWorkers(IOEventDispatch eventDispatch) {
        int i;
        for (i = 0; i < this.workerCount; ++i) {
            BaseIOReactor ioReactor = this.ioReactors[i];
            this.workers[i] = new Worker(ioReactor, eventDispatch);
            this.threads[i] = this.threadFactory.newThread((Runnable)this.workers[i]);
        }
        for (i = 0; i < this.workerCount; ++i) {
            if (this.shutdown) {
                return;
            }
            this.threads[i].start();
        }
    }

    protected void stopWorkers(int millis) throws InterruptedIOException, IOReactorException {
        int i;
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        for (i = 0; i < this.workerCount; ++i) {
            BaseIOReactor reactor = this.ioReactors[i];
            if (reactor == null) continue;
            reactor.shutdown();
        }
        for (i = 0; i < this.workerCount; ++i) {
            try {
                Thread t = this.threads[i];
                if (t == null) continue;
                t.join(millis);
                continue;
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException(ex.getMessage());
            }
        }
    }

    protected void verifyWorkers() throws InterruptedIOException, IOReactorException {
        if (this.shutdown) {
            return;
        }
        for (int i = 0; i < this.workerCount; ++i) {
            Worker worker = this.workers[i];
            Thread thread = this.threads[i];
            if (thread.isAlive()) continue;
            if (worker.getReactorException() != null) {
                throw worker.getReactorException();
            }
            if (worker.getInterruptedException() == null) continue;
            throw worker.getInterruptedException();
        }
    }

    protected void addChannel(ChannelEntry entry) {
        this.ioReactors[this.currentWorker++ % this.workerCount].addChannel(entry);
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private static int COUNT = 0;

        DefaultThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            return new Thread(r, "I/O reactor worker thread " + ++COUNT);
        }
    }

    static class Worker
    implements Runnable {
        final BaseIOReactor ioReactor;
        final IOEventDispatch eventDispatch;
        private volatile IOReactorException reactorException;
        private volatile InterruptedIOException interruptedException;

        public Worker(BaseIOReactor ioReactor, IOEventDispatch eventDispatch) {
            this.ioReactor = ioReactor;
            this.eventDispatch = eventDispatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.ioReactor.execute(this.eventDispatch);
            }
            catch (InterruptedIOException ex) {
                this.interruptedException = ex;
            }
            catch (IOReactorException ex) {
                this.reactorException = ex;
            }
            finally {
                block16: {
                    try {
                        this.ioReactor.shutdown();
                    }
                    catch (IOReactorException ex2) {
                        if (this.reactorException != null) break block16;
                        this.reactorException = ex2;
                    }
                }
            }
        }

        public IOReactorException getReactorException() {
            return this.reactorException;
        }

        public InterruptedIOException getInterruptedException() {
            return this.interruptedException;
        }
    }
}

