/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.hibernate.validator.Size;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeValidator
implements Validator<Size> {
    private int max;
    private int min;

    @Override
    public void initialize(Size parameters) {
        this.max = parameters.max();
        this.min = parameters.min();
    }

    @Override
    public boolean isValid(Object value) {
        int length;
        if (value == null) {
            return true;
        }
        if (value.getClass().isArray()) {
            length = Array.getLength(value);
        } else if (value instanceof Collection) {
            length = ((Collection)value).size();
        } else if (value instanceof Map) {
            length = ((Map)value).size();
        } else {
            return false;
        }
        return length >= this.min && length <= this.max;
    }
}

