/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.hibernate.MappingException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.PersistentClassConstraint;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Validator;
import org.hibernate.validator.ValidatorClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassValidator<T> {
    private final Class<T> beanClass;
    private final List<Validator> beanValidators = new ArrayList<Validator>();
    private final List<Validator> propertyValidators = new ArrayList<Validator>();
    private final List<Method> propertyGetters = new ArrayList<Method>();
    private final Map<Validator, String> messages = new HashMap<Validator, String>();
    private final ResourceBundle messageBundle;

    public ClassValidator(Class<T> beanClass) {
        this(beanClass, null);
    }

    public ClassValidator(Class<T> beanClass, ResourceBundle resourceBundle) {
        this.beanClass = beanClass;
        this.messageBundle = resourceBundle;
        Annotation[] classAnnotations = beanClass.getAnnotations();
        for (int i = 0; i < classAnnotations.length; ++i) {
            Annotation classAnnotation = classAnnotations[i];
            Validator beanValidator = this.createValidator(classAnnotation);
            if (beanValidator == null) continue;
            this.beanValidators.add(beanValidator);
        }
        Method[] methods = beanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Annotation[] methodAnnotations = method.getAnnotations();
            for (int j = 0; j < methodAnnotations.length; ++j) {
                Annotation methodAnnotation = methodAnnotations[j];
                Validator propertyValidator = this.createValidator(methodAnnotation);
                if (propertyValidator == null) continue;
                this.propertyValidators.add(propertyValidator);
                this.propertyGetters.add(method);
            }
        }
    }

    private Validator createValidator(Annotation annotation) {
        try {
            ValidatorClass validatorClass = annotation.annotationType().getAnnotation(ValidatorClass.class);
            if (validatorClass == null) {
                return null;
            }
            Validator beanValidator = validatorClass.value().newInstance();
            beanValidator.initialize(annotation);
            String messageTemplate = (String)annotation.getClass().getMethod("message", null).invoke((Object)annotation, new Object[0]);
            String message = this.replace(messageTemplate, annotation);
            this.messages.put(beanValidator, message);
            return beanValidator;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not instantiate ClassValidator", e);
        }
    }

    public InvalidValue[] getInvalidValues(T bean) {
        int i;
        if (!this.beanClass.isInstance(bean)) {
            throw new IllegalArgumentException("not an instance of: " + bean.getClass());
        }
        ArrayList<InvalidValue> results = new ArrayList<InvalidValue>();
        for (i = 0; i < this.beanValidators.size(); ++i) {
            Validator validator = this.beanValidators.get(i);
            if (validator.isValid(bean)) continue;
            results.add(new InvalidValue(this.messages.get(validator), this.beanClass, null, bean, bean));
        }
        for (i = 0; i < this.propertyValidators.size(); ++i) {
            Object value;
            Method getter = this.propertyGetters.get(i);
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not get property value", e);
            }
            Validator validator = this.propertyValidators.get(i);
            if (validator.isValid(value)) continue;
            String propertyName = ClassValidator.getPropertyName(getter);
            results.add(new InvalidValue(this.messages.get(validator), this.beanClass, propertyName, value, bean));
        }
        return results.toArray(new InvalidValue[results.size()]);
    }

    private static String getPropertyName(Method getter) {
        String name = getter.getName();
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("get")) {
            name = name.substring(3);
        }
        String propertyName = Introspector.decapitalize(name);
        return propertyName;
    }

    private String replace(String message, Annotation parameters) {
        StringTokenizer tokens = new StringTokenizer(message, "{}", true);
        StringBuffer buf = new StringBuffer();
        boolean escaped = false;
        while (tokens.hasMoreTokens()) {
            String string;
            Method member;
            String token = tokens.nextToken();
            if ("{".equals(token)) {
                escaped = true;
                continue;
            }
            if ("}".equals(token)) {
                escaped = false;
                continue;
            }
            if (!escaped) {
                buf.append(token);
                continue;
            }
            try {
                member = parameters.getClass().getMethod(token, null);
            }
            catch (NoSuchMethodException nsfme) {
                member = null;
            }
            if (member != null) {
                try {
                    buf.append(member.invoke((Object)parameters, new Object[0]));
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("could not render message", e);
                }
            }
            if (this.messageBundle == null || (string = this.messageBundle.getString(token)) == null) continue;
            buf.append(string);
        }
        return buf.toString();
    }

    public void apply(PersistentClass persistentClass) {
        for (Validator validator : this.beanValidators) {
            if (!(validator instanceof PersistentClassConstraint)) continue;
            ((PersistentClassConstraint)((Object)validator)).apply(persistentClass);
        }
        Iterator<Validator> validators = this.propertyValidators.iterator();
        Iterator<Method> getters = this.propertyGetters.iterator();
        while (validators.hasNext()) {
            Validator validator = validators.next();
            String propertyName = ClassValidator.getPropertyName(getters.next());
            if (!(validator instanceof PropertyConstraint)) continue;
            try {
                Property property = persistentClass.getProperty(propertyName);
                ((PropertyConstraint)((Object)validator)).apply(property);
            }
            catch (MappingException pnfe) {}
        }
    }
}

