/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.type.Type;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class EnumType
implements UserType,
ParameterizedType {
    private static Log log = LogFactory.getLog(EnumType.class);
    private static final boolean IS_TRACE_ENABLED = LogFactory.getLog((String)StringHelper.qualifier((String)Type.class.getName())).isTraceEnabled();
    public static final String ENUM = "enumClass";
    public static final String SCHEMA = "schema";
    public static final String CATALOG = "catalog";
    public static final String TABLE = "table";
    public static final String COLUMN = "column";
    private static Map<Class, Object[]> enumValues = new HashMap<Class, Object[]>();
    private Class<? extends Enum> enumClass;
    private String column;
    private String table;
    private String catalog;
    private String schema;
    private boolean guessed = false;
    private int sqlType = 4;

    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    public Class returnedClass() {
        return this.enumClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Object object = rs.getObject(names[0]);
        if (rs.wasNull()) {
            if (IS_TRACE_ENABLED) {
                log.debug((Object)("Returning null as column " + names[0]));
            }
            return null;
        }
        if (object instanceof Number) {
            int ordinal;
            Object[] values = enumValues.get(this.enumClass);
            if (values == null) {
                try {
                    Method method = null;
                    method = this.enumClass.getDeclaredMethod("values", new Class[0]);
                    values = (Object[])method.invoke(null, new Object[0]);
                    enumValues.put(this.enumClass, values);
                }
                catch (Exception e) {
                    throw new HibernateException("Error while accessing enum.values(): " + this.enumClass, (Throwable)e);
                }
            }
            if ((ordinal = ((Number)object).intValue()) < 0 || ordinal >= values.length) {
                throw new IllegalArgumentException("Unknown ordinal value for enum " + this.enumClass + ": " + ordinal);
            }
            if (IS_TRACE_ENABLED) {
                log.debug((Object)("Returning '" + ordinal + "' as column " + names[0]));
            }
            return values[ordinal];
        }
        String name = (String)object;
        if (IS_TRACE_ENABLED) {
            log.debug((Object)("Returning '" + name + "' as column " + names[0]));
        }
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unknown name value for enum " + this.enumClass + ": " + name, iae);
        }
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        boolean isOrdinal;
        if (!this.guessed) {
            this.guessType(st, index);
        }
        if (value == null) {
            if (IS_TRACE_ENABLED) {
                log.debug((Object)("Binding null to parameter: " + index));
            }
            st.setNull(index, this.sqlType);
        }
        if (isOrdinal = this.isOrdinal(this.sqlType)) {
            int ordinal = ((Enum)value).ordinal();
            if (IS_TRACE_ENABLED) {
                log.debug((Object)("Binding '" + ordinal + "' to parameter: " + index));
            }
            st.setObject(index, (Object)new Integer(ordinal), this.sqlType);
        } else {
            String enumString = ((Enum)value).name();
            if (IS_TRACE_ENABLED) {
                log.debug((Object)("Binding '" + enumString + "' to parameter: " + index));
            }
            st.setObject(index, (Object)enumString, this.sqlType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guessType(PreparedStatement statement, int index) {
        ResultSet rs = null;
        if (!this.guessed) {
            try {
                rs = statement.getConnection().getMetaData().getColumns(this.catalog, this.schema, this.table, this.column);
                if (!rs.next()) {
                    throw new HibernateException("column not found: " + this.column);
                }
                int guessedType = rs.getInt("DATA_TYPE");
                if (rs.wasNull()) {
                    throw new HibernateException("column wo type: " + this.column);
                }
                if (rs.next()) {
                    throw new HibernateException("several columns matching: " + this.column);
                }
                this.sqlType = guessedType;
                this.guessed = true;
            }
            catch (SQLException e) {
                this.guessTypeByParameter(statement, index, e);
            }
            catch (HibernateException e) {
                this.guessTypeByParameter(statement, index, (Exception)((Object)e));
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {}
            }
        }
    }

    private void guessTypeByParameter(PreparedStatement statement, int index, Exception e) {
        log.debug((Object)("Unable to guess the column type for enum through conn.getMetadata(): " + e.getMessage()));
        try {
            this.sqlType = statement.getParameterMetaData().getParameterType(index);
        }
        catch (SQLException ee) {
            this.sqlType = 4;
            log.warn((Object)"Unable to guess enum type, default to INTEGER", (Throwable)ee);
        }
        this.guessed = true;
    }

    private boolean isOrdinal(int paramType) {
        switch (paramType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
            case -1: 
            case 1: 
            case 12: {
                return false;
            }
        }
        throw new HibernateException("Unable to persist an Enum in a column of SQL Type: " + paramType);
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public void setParameterValues(Properties parameters) {
        String enumClassName = parameters.getProperty(ENUM);
        try {
            this.enumClass = ReflectHelper.classForName((String)enumClassName).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException exception) {
            throw new HibernateException("Enum class not found", (Throwable)exception);
        }
        this.schema = parameters.getProperty(SCHEMA);
        if ("".equals(this.schema)) {
            this.schema = null;
        }
        this.catalog = parameters.getProperty(CATALOG);
        if ("".equals(this.catalog)) {
            this.catalog = null;
        }
        this.table = parameters.getProperty(TABLE);
        this.column = parameters.getProperty(COLUMN);
    }
}

