/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.Index;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableBinder {
    private static Log log = LogFactory.getLog(TableBinder.class);

    public static Table fillTable(String schema, String catalog, String realTableName, boolean isAbstract, List uniqueConstraints, String constraints, Table denormalizedSuperTable, ExtendedMappings mappings) {
        schema = AnnotationBinder.isDefault(schema) ? (schema = mappings.getSchemaName()) : schema;
        catalog = AnnotationBinder.isDefault(catalog) ? (catalog = mappings.getCatalogName()) : catalog;
        Table table = denormalizedSuperTable != null ? mappings.addDenormalizedTable(schema, catalog, realTableName, isAbstract, null, denormalizedSuperTable) : mappings.addTable(schema, catalog, realTableName, null, isAbstract);
        if (uniqueConstraints != null && uniqueConstraints.size() > 0) {
            mappings.addUniqueConstraints(table, uniqueConstraints);
        }
        if (constraints != null) {
            table.addCheckConstraint(constraints);
        }
        return table;
    }

    public static void bindManytoManyInverseFk(PersistentClass referencedEntity, Ejb3JoinColumn[] columns, SimpleValue value, boolean unique, ExtendedMappings mappings) {
        if (!StringHelper.isEmpty((String)columns[0].getMappedBy())) {
            Property property = referencedEntity.getProperty(columns[0].getMappedBy());
            Iterator mappedByColumns = ((Collection)property.getValue()).getKey().getColumnIterator();
            while (mappedByColumns.hasNext()) {
                Column column = (Column)mappedByColumns.next();
                columns[0].linkValueUsingAColumnCopy(column, value);
            }
            value.createForeignKey();
        } else {
            TableBinder.bindFk(referencedEntity, null, columns, value, unique);
        }
    }

    public static void bindFk(PersistentClass referencedEntity, PersistentClass destinationEntity, Ejb3JoinColumn[] columns, SimpleValue value, boolean unique) {
        PersistentClass associatedClass = destinationEntity != null ? destinationEntity : (columns[0].getPropertyHolder() == null ? null : columns[0].getPropertyHolder().getPersistentClass());
        String mappedByProperty = columns[0].getMappedBy();
        if (!StringHelper.isEmpty((String)mappedByProperty)) {
            Property property;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieving property " + associatedClass.getEntityName() + "." + mappedByProperty));
            }
            Iterator mappedByColumns = (property = associatedClass.getProperty(columns[0].getMappedBy())).getValue() instanceof Collection ? ((Collection)property.getValue()).getElement().getColumnIterator() : property.getValue().getColumnIterator();
            while (mappedByColumns.hasNext()) {
                Column column = (Column)mappedByColumns.next();
                columns[0].linkValueUsingAColumnCopy(column, value);
            }
        } else if (columns[0].isImplicit()) {
            Iterator idColumns = referencedEntity.getIdentifier().getColumnIterator();
            while (idColumns.hasNext()) {
                Column column = (Column)idColumns.next();
                columns[0].linkValueUsingDefaultColumnNaming(column, value);
            }
        } else {
            int fkEnum = Ejb3JoinColumn.checkReferencedColumnsType(columns, referencedEntity);
            if (2 == fkEnum) {
                String referencedPropertyName;
                if (value instanceof ToOne) {
                    referencedPropertyName = ((ToOne)value).getReferencedPropertyName();
                } else if (value instanceof DependantValue) {
                    Collection collection = (Collection)referencedEntity.getProperty(columns[0].getPropertyName()).getValue();
                    referencedPropertyName = collection.getReferencedPropertyName();
                } else {
                    throw new AssertionFailure("Do a property ref on an unexpected Value type: " + value.getClass().getName());
                }
                if (referencedPropertyName == null) {
                    throw new AssertionFailure("No property ref found while expected");
                }
                Property synthProp = referencedEntity.getProperty(referencedPropertyName);
                if (synthProp == null) {
                    throw new AssertionFailure("Cannot find synthProp: " + referencedEntity.getEntityName() + "." + referencedPropertyName);
                }
                TableBinder.linkColumnWithValueOverridingNameIfImplicit(synthProp.getColumnIterator(), columns, value);
            } else if (0 == fkEnum) {
                if (columns.length != referencedEntity.getIdentifier().getColumnSpan()) {
                    throw new AnnotationException("A Foreign key refering " + referencedEntity.getEntityName() + " has the wrong number of column. should be " + referencedEntity.getIdentifier().getColumnSpan());
                }
                TableBinder.linkColumnWithValueOverridingNameIfImplicit(referencedEntity.getIdentifier().getColumnIterator(), columns, value);
            } else {
                Iterator idColItr = referencedEntity.getIdentifier().getColumnIterator();
                if (!idColItr.hasNext()) {
                    log.debug((Object)"No column in the identifier!");
                }
                while (idColItr.hasNext()) {
                    boolean match = false;
                    Column col = (Column)idColItr.next();
                    for (Ejb3JoinColumn joinCol : columns) {
                        if (!joinCol.getReferencedColumn().equals(col.getName())) continue;
                        if (joinCol.isNameDeferred()) {
                            joinCol.redefineColumnName(joinCol.getPropertyName() + "_" + joinCol.getReferencedColumn());
                        }
                        joinCol.linkWithValue(value);
                        match = true;
                        break;
                    }
                    if (match) continue;
                    throw new AnnotationException("Column name " + col.getName() + " of " + referencedEntity.getEntityName() + " not found in JoinColumns.referencedColumnName");
                }
            }
        }
        value.createForeignKey();
        if (unique) {
            TableBinder.createUniqueConstraint((Value)value);
        }
    }

    private static void linkColumnWithValueOverridingNameIfImplicit(Iterator columnIterator, Ejb3JoinColumn[] columns, SimpleValue value) {
        for (Ejb3JoinColumn joinCol : columns) {
            Column synthCol = (Column)columnIterator.next();
            if (joinCol.isNameDeferred()) {
                joinCol.redefineColumnName(joinCol.getPropertyName() + "_" + synthCol.getName());
            }
            joinCol.linkWithValue(value);
        }
    }

    public static void createUniqueConstraint(Value value) {
        Iterator iter = value.getColumnIterator();
        ArrayList cols = new ArrayList();
        while (iter.hasNext()) {
            cols.add(iter.next());
        }
        value.getTable().createUniqueKey(cols);
    }

    private static List<Property> findPropertiesByColumns(PersistentClass referencedEntity, Ejb3JoinColumn[] columns) {
        HashMap columnsToProperty = new HashMap();
        ArrayList<Column> orderedColumns = new ArrayList<Column>();
        for (int index = 0; index < columns.length; ++index) {
            Column column = new Column(columns[index].getReferencedColumn());
            orderedColumns.add(column);
            columnsToProperty.put(column, new HashSet());
        }
        Iterator it = referencedEntity.getPropertyIterator();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            Iterator columnIt = property.getColumnIterator();
            while (columnIt.hasNext()) {
                Column column = (Column)columnIt.next();
                if (!columnsToProperty.containsKey(column)) continue;
                ((Set)columnsToProperty.get(column)).add(property);
            }
        }
        ArrayList<Property> orderedProperties = new ArrayList<Property>();
        for (Column column : orderedColumns) {
            boolean found = false;
            for (Property property : (Set)columnsToProperty.get(column)) {
                if (property.getColumnSpan() != 1) continue;
                orderedProperties.add(property);
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return orderedProperties;
    }

    public static void addIndexes(Table hibTable, Index[] indexes) {
        for (Index index : indexes) {
            String indexName = index.name();
            for (String columnName : index.columnNames()) {
                Column column = hibTable.getColumn(new Column(columnName));
                if (column == null) {
                    throw new AnnotationException("@Index references a unknown column: " + columnName);
                }
                hibTable.getOrCreateIndex(indexName).addColumn(column);
            }
        }
    }
}

