/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinderHelper {
    private BinderHelper() {
    }

    public static Property shallowCopy(Property property) {
        Property clone = new Property();
        clone.setCascade(property.getCascade());
        clone.setInsertable(property.isInsertable());
        clone.setLazy(property.isLazy());
        clone.setName(property.getName());
        clone.setNaturalIdentifier(property.isNaturalIdentifier());
        clone.setOptimisticLocked(property.isOptimisticLocked());
        clone.setOptional(property.isOptional());
        clone.setPersistentClass(property.getPersistentClass());
        clone.setPropertyAccessorName(property.getPropertyAccessorName());
        clone.setSelectable(property.isSelectable());
        clone.setUpdateable(property.isUpdateable());
        clone.setValue(property.getValue());
        return clone;
    }

    public static void createSyntheticPropertyReference(Ejb3JoinColumn[] columns, PersistentClass referencedEntity, Value value, ExtendedMappings mappings) {
        PersistentClass associatedClass;
        if (columns[0].isImplicit() || StringHelper.isNotEmpty((String)columns[0].getMappedBy())) {
            return;
        }
        int fkEnum = Ejb3JoinColumn.checkReferencedColumnsType(columns, referencedEntity);
        PersistentClass persistentClass = associatedClass = columns[0].getPropertyHolder() == null ? null : columns[0].getPropertyHolder().getPersistentClass();
        if (2 == fkEnum) {
            Component embeddedComp;
            String syntheticPropertyName = new StringBuffer("_").append(referencedEntity.getEntityName().replace('.', '_')).append("_").append(columns[0].getPropertyName()).toString();
            List<Property> properties = BinderHelper.findPropertiesByColumns(referencedEntity, columns);
            Property synthProp = null;
            if (properties != null) {
                embeddedComp = new Component(referencedEntity);
                embeddedComp.setEmbedded(true);
                embeddedComp.setComponentClassName(embeddedComp.getOwner().getClassName());
                for (Property property : properties) {
                    Property clone = BinderHelper.shallowCopy(property);
                    clone.setInsertable(false);
                    clone.setUpdateable(false);
                    clone.setNaturalIdentifier(false);
                    embeddedComp.addProperty(clone);
                }
            } else {
                StringBuffer columnsList = new StringBuffer();
                for (Ejb3JoinColumn column : columns) {
                    columnsList.append(column.getReferencedColumn()).append(", ");
                }
                throw new AnnotationException("referencedColumnName not mapped to a property is not supported: " + columnsList.toString());
            }
            synthProp = new Property();
            synthProp.setName(syntheticPropertyName);
            synthProp.setPersistentClass(referencedEntity);
            synthProp.setUpdateable(false);
            synthProp.setInsertable(false);
            synthProp.setValue((Value)embeddedComp);
            synthProp.setPropertyAccessorName("embedded");
            referencedEntity.addProperty(synthProp);
            TableBinder.createUniqueConstraint((Value)embeddedComp);
            if (value instanceof ToOne) {
                ((ToOne)value).setReferencedPropertyName(syntheticPropertyName);
                mappings.addUniquePropertyReference(referencedEntity.getEntityName(), syntheticPropertyName);
            } else if (value instanceof Collection) {
                ((Collection)value).setReferencedPropertyName(syntheticPropertyName);
                mappings.addPropertyReference(referencedEntity.getEntityName(), syntheticPropertyName);
            } else {
                throw new AssertionFailure("Do a property ref on an unexpected Value type: " + value.getClass().getName());
            }
            mappings.addPropertyReferencedAssociation(associatedClass.getEntityName(), columns[0].getPropertyName(), syntheticPropertyName);
        }
    }

    private static List<Property> findPropertiesByColumns(PersistentClass referencedEntity, Ejb3JoinColumn[] columns) {
        HashMap columnsToProperty = new HashMap();
        ArrayList<Column> orderedColumns = new ArrayList<Column>();
        for (int index = 0; index < columns.length; ++index) {
            Column column = new Column(columns[index].getReferencedColumn());
            orderedColumns.add(column);
            columnsToProperty.put(column, new HashSet());
        }
        Iterator it = referencedEntity.getPropertyIterator();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            Iterator columnIt = property.getColumnIterator();
            while (columnIt.hasNext()) {
                Column column = (Column)columnIt.next();
                if (!columnsToProperty.containsKey(column)) continue;
                ((Set)columnsToProperty.get(column)).add(property);
            }
        }
        ArrayList<Property> orderedProperties = new ArrayList<Property>();
        for (Column column : orderedColumns) {
            boolean found = false;
            for (Property property : (Set)columnsToProperty.get(column)) {
                if (property.getColumnSpan() != 1) continue;
                orderedProperties.add(property);
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return orderedProperties;
    }

    public static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty != null ? idProperty.getName() : null;
        try {
            if (propertyName == null || propertyName.equals("") || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            return null;
        }
        return property;
    }
}

