/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedIdTable;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.LobType;
import javax.persistence.ManyToMany;
import javax.persistence.MapKey;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3DiscriminatorColumn;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.QueryBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.type.ByteArrayBlobType;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.EnumType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.PrimitiveByteArrayBlobType;
import org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.StringClobType;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.validator.ClassValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationBinder {
    private static final String GENERATOR_TABLE_NAME_PARAM = "generatorTableName";
    public static final String ANNOTATION_STRING_DEFAULT = "";
    private static final Log log = LogFactory.getLog(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindPackage(String packageName, ExtendedMappings mappings) {
        IdGenerator idGen;
        Object ann;
        Package pckg = null;
        try {
            pckg = ReflectHelper.classForName((String)(packageName + ".package-info")).getPackage();
        }
        catch (ClassNotFoundException cnf) {
            log.warn((Object)("Package not found or wo package-info.java: " + packageName));
            return;
        }
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            ann = pckg.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann);
            mappings.addGenerator(idGen);
            log.debug((Object)("Add sequence generator with name: " + idGen.getName()));
        }
        if (pckg.isAnnotationPresent(TableGenerator.class)) {
            ann = pckg.getAnnotation(TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann);
            mappings.addGenerator(idGen);
        }
        if (pckg.isAnnotationPresent(GeneratedIdTable.class)) {
            ann = pckg.getAnnotation(GeneratedIdTable.class);
            Properties params = AnnotationBinder.buildPropertiesFromGeneratorTable((GeneratedIdTable)ann);
            mappings.addGeneratorTable(ann.name(), params);
        }
        if (pckg.isAnnotationPresent(GenericGenerator.class)) {
            ann = pckg.getAnnotation(GenericGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann);
            mappings.addGenerator(idGen);
        }
        AnnotationBinder.bindQueries(pckg, mappings);
        AnnotationBinder.bindFilterDefs(pckg, mappings);
        AnnotationBinder.bindTypeDefs(pckg, mappings);
    }

    private static void bindQueries(AnnotatedElement annotatedElement, ExtendedMappings mappings) {
        SqlResultSetMapping ann = annotatedElement.getAnnotation(SqlResultSetMapping.class);
        QueryBinder.bindSqlResultsetMapping(ann, mappings);
        ann = annotatedElement.getAnnotation(NamedQuery.class);
        QueryBinder.bindQuery((NamedQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(NamedQueries.class);
        QueryBinder.bindQueries((NamedQueries)ann, mappings);
        ann = annotatedElement.getAnnotation(NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((NamedNativeQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((NamedNativeQueries)ann, mappings);
    }

    private static Properties buildPropertiesFromGeneratorTable(GeneratedIdTable ann) {
        Properties params = new Properties();
        if (!AnnotationBinder.isDefault(ann.pkColumnName())) {
            params.setProperty("primary_key_column", ann.pkColumnName());
        }
        if (!AnnotationBinder.isDefault(ann.valueColumnName())) {
            params.setProperty("value_column", ann.valueColumnName());
        }
        if (ann.table().specified()) {
            Table table = ann.table();
            if (!AnnotationBinder.isDefault(table.name())) {
                params.setProperty("table", table.name());
            }
            if (!AnnotationBinder.isDefault(table.catalog())) {
                params.setProperty("catalog", table.catalog());
            }
            if (!AnnotationBinder.isDefault(table.schema())) {
                params.setProperty("schema", table.schema());
            }
        } else {
            params.setProperty("table", ann.name());
        }
        return params;
    }

    private static IdGenerator buildIdGenerator(Annotation ann) {
        IdGenerator idGen = new IdGenerator();
        if (ann == null) {
            idGen = null;
        } else if (ann instanceof TableGenerator) {
            TableGenerator tabGen = (TableGenerator)ann;
            idGen.setName(tabGen.name());
            idGen.setIdentifierGeneratorStrategy(MultipleHiLoPerTableGenerator.class.getName());
            if (!AnnotationBinder.isDefault(tabGen.tableName())) {
                idGen.addParam(GENERATOR_TABLE_NAME_PARAM, tabGen.tableName());
            }
            if (!AnnotationBinder.isDefault(tabGen.pkColumnValue())) {
                idGen.addParam("primary_key_value", tabGen.pkColumnValue());
            }
            idGen.addParam("max_lo", String.valueOf(tabGen.allocationSize()));
            log.debug((Object)("Add table generator with name: " + idGen.getName()));
        } else if (ann instanceof SequenceGenerator) {
            SequenceGenerator seqGen = (SequenceGenerator)ann;
            idGen.setName(seqGen.name());
            idGen.setIdentifierGeneratorStrategy("sequence");
            if (!AnnotationBinder.isDefault(seqGen.sequenceName())) {
                idGen.addParam("sequence", seqGen.sequenceName());
            }
            if (seqGen.initialValue() != 0 || seqGen.allocationSize() != 50) {
                log.warn((Object)"Hibernate does not support SequenceGenerator.initialValue() nor SequenceGenerator.allocationSize()");
            }
            log.debug((Object)("Add sequence generator with name: " + idGen.getName()));
        } else if (ann instanceof GenericGenerator) {
            Parameter[] params;
            GenericGenerator genGen = (GenericGenerator)ann;
            idGen.setName(genGen.name());
            idGen.setIdentifierGeneratorStrategy(genGen.strategy());
            for (Parameter parameter : params = genGen.parameters()) {
                idGen.addParam(parameter.name(), parameter.value());
            }
            log.debug((Object)("Add generic generator with name: " + idGen.getName()));
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + ann);
        }
        return idGen;
    }

    public static void bindClass(Class clazzToProcess, Map<Class, InheritanceState> inheritanceStatePerClass, ExtendedMappings mappings) throws MappingException {
        boolean subclassAndSingleTableStrategy;
        Filters filtersAnn;
        RootClass persistentClass;
        boolean hasJoinedColumns;
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        AnnotatedClassType classType = mappings.getClassType(clazzToProcess);
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)classType)) {
            return;
        }
        if (AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
            return;
        }
        if (!classType.equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have a @javax.persistence.Entity, @javax.persistence.Embeddable or @javax.persistence.EmbeddedSuperclass annotation: " + clazzToProcess.getName());
        }
        Class annotatedClass = clazzToProcess;
        AnnotationBinder.bindQueries(annotatedClass, mappings);
        AnnotationBinder.bindFilterDefs(annotatedClass, mappings);
        AnnotationBinder.bindTypeDefs(annotatedClass, mappings);
        Class superClass = clazzToProcess.getSuperclass();
        PersistentClass superEntity = mappings.getClass(superClass.getName());
        if (superEntity == null && inheritanceState.hasParents) {
            throw new AnnotationException("Subclass has to be binded after it's mother class: " + superClass.getName());
        }
        String schema = ANNOTATION_STRING_DEFAULT;
        String table = ANNOTATION_STRING_DEFAULT;
        String catalog = ANNOTATION_STRING_DEFAULT;
        String discrimValue = null;
        ArrayList<String[]> uniqueConstraints = new ArrayList<String[]>();
        Ejb3DiscriminatorColumn discriminatorColumn = null;
        Ejb3JoinColumn[] inheritanceJoinedColumns = null;
        if (annotatedClass.isAnnotationPresent(Table.class)) {
            Table tabAnn = annotatedClass.getAnnotation(Table.class);
            table = tabAnn.name();
            schema = tabAnn.schema();
            catalog = tabAnn.catalog();
            if (tabAnn.uniqueConstraints().length != 0) {
                for (UniqueConstraint uc : tabAnn.uniqueConstraints()) {
                    uniqueConstraints.add(uc.columnNames());
                }
            }
        }
        boolean bl = hasJoinedColumns = InheritanceType.JOINED.equals((Object)inheritanceState.type) && inheritanceState.hasParents;
        if (hasJoinedColumns) {
            boolean explicitInheritanceJoinedColumns;
            PrimaryKeyJoinColumns jcsAnn = annotatedClass.getAnnotation(PrimaryKeyJoinColumns.class);
            boolean bl2 = explicitInheritanceJoinedColumns = jcsAnn != null && jcsAnn.value().length != 0;
            if (explicitInheritanceJoinedColumns) {
                int nbrOfInhJoinedColumns = jcsAnn.value().length;
                inheritanceJoinedColumns = new Ejb3JoinColumn[nbrOfInhJoinedColumns];
                for (int colIndex = 0; colIndex < nbrOfInhJoinedColumns; ++colIndex) {
                    PrimaryKeyJoinColumn jcAnn = jcsAnn.value()[colIndex];
                    inheritanceJoinedColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings);
                }
            } else {
                PrimaryKeyJoinColumn jcAnn = annotatedClass.getAnnotation(PrimaryKeyJoinColumn.class);
                inheritanceJoinedColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings)};
            }
            log.debug((Object)"Joined column(s) created");
        } else if (annotatedClass.isAnnotationPresent(PrimaryKeyJoinColumns.class) || annotatedClass.isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
            log.warn((Object)"Root entity should not hold an InheritanceJoinColum(s), will be ignored");
        }
        if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            Inheritance inhAnn = annotatedClass.getAnnotation(Inheritance.class);
            DiscriminatorType discriminatorType = inhAnn == null ? DiscriminatorType.STRING : inhAnn.discriminatorType();
            DiscriminatorColumn discAnn = annotatedClass.getAnnotation(DiscriminatorColumn.class);
            DiscriminatorFormula discFormulaAnn = annotatedClass.getAnnotation(DiscriminatorFormula.class);
            if (!inheritanceState.hasParents) {
                discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(discriminatorType, discAnn, discFormulaAnn, mappings);
            }
            if (discAnn != null && inheritanceState.hasParents) {
                log.warn((Object)("Discriminator column has to be defined in the root entity, it will be ignored in subclass: " + clazzToProcess.getName()));
            }
            String string = discrimValue = inhAnn == null ? null : inhAnn.discriminatorValue();
        }
        if (!inheritanceState.hasParents) {
            persistentClass = new RootClass();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            persistentClass = new Subclass(superEntity);
        } else if (InheritanceType.JOINED.equals((Object)inheritanceState.type)) {
            persistentClass = new JoinedSubclass(superEntity);
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.type)) {
            persistentClass = new UnionSubclass(superEntity);
        } else {
            throw new AssertionFailure("Unknown inheritance type: " + inheritanceState.type);
        }
        Proxy proxyAnn = annotatedClass.getAnnotation(Proxy.class);
        BatchSize sizeAnn = annotatedClass.getAnnotation(BatchSize.class);
        Where whereAnn = annotatedClass.getAnnotation(Where.class);
        Entity entityAnn = annotatedClass.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity hibEntityAnn = annotatedClass.getAnnotation(org.hibernate.annotations.Entity.class);
        Cache cacheAnn = annotatedClass.getAnnotation(Cache.class);
        EntityBinder entityBinder = new EntityBinder(entityAnn, hibEntityAnn, clazzToProcess, (PersistentClass)persistentClass, mappings);
        entityBinder.setDiscriminatorValue(discrimValue);
        entityBinder.setBatchSize(sizeAnn);
        entityBinder.setProxy(proxyAnn);
        entityBinder.setWhere(whereAnn);
        entityBinder.setCache(cacheAnn);
        entityBinder.setInheritanceState(inheritanceState);
        Filter filterAnn = annotatedClass.getAnnotation(Filter.class);
        if (filterAnn != null) {
            entityBinder.addFilter(filterAnn.name(), filterAnn.condition());
        }
        if ((filtersAnn = annotatedClass.getAnnotation(Filters.class)) != null) {
            for (Filter filter : filtersAnn.value()) {
                entityBinder.addFilter(filter.name(), filter.condition());
            }
        }
        entityBinder.bindEntity();
        if (inheritanceState.hasTable()) {
            Check checkAnn = annotatedClass.getAnnotation(Check.class);
            String constraints = checkAnn == null ? null : checkAnn.constraints();
            entityBinder.bindTable(schema, catalog, table, uniqueConstraints, constraints, inheritanceState.hasDenormalizedTable() ? superEntity.getTable() : null);
        }
        Map<String, javax.persistence.Column[]> columnOverride = PropertyHolderBuilder.buildColumnOverride(annotatedClass);
        PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder((PersistentClass)persistentClass, columnOverride);
        SecondaryTable secTabAnn = annotatedClass.getAnnotation(SecondaryTable.class);
        SecondaryTables secTabsAnn = annotatedClass.getAnnotation(SecondaryTables.class);
        JoinColumn joinColAnn = annotatedClass.getAnnotation(JoinColumn.class);
        JoinColumns joinColsAnn = annotatedClass.getAnnotation(JoinColumns.class);
        entityBinder.firstLevelSecondaryTablesBinding(secTabAnn, secTabsAnn, joinColAnn, joinColsAnn);
        OnDelete onDeleteAnn = annotatedClass.getAnnotation(OnDelete.class);
        boolean onDeleteAppropriate = false;
        if (InheritanceType.JOINED.equals((Object)inheritanceState.type) && inheritanceState.hasParents) {
            onDeleteAppropriate = true;
            JoinedSubclass jsc = (JoinedSubclass)persistentClass;
            if (persistentClass.getEntityPersisterClass() == null) {
                persistentClass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
            }
            DependantValue key = new DependantValue(jsc.getTable(), jsc.getIdentifier());
            jsc.setKey((KeyValue)key);
            if (onDeleteAnn != null) {
                key.setCascadeDeleteEnabled(OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action()));
            } else {
                key.setCascadeDeleteEnabled(false);
            }
            TableBinder.bindFk((PersistentClass)jsc, null, inheritanceJoinedColumns, (SimpleValue)key, false);
            jsc.createPrimaryKey();
            jsc.createForeignKey();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            if (inheritanceState.hasParents) {
                if (persistentClass.getEntityPersisterClass() == null) {
                    persistentClass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
                }
            } else if (inheritanceState.hasSons || !discriminatorColumn.isImplicit()) {
                AnnotationBinder.bindDiscriminatorToPersistentClass(persistentClass, discriminatorColumn, entityBinder.getSecondaryTables(), propertyHolder);
            }
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.type) && inheritanceState.hasParents && persistentClass.getEntityPersisterClass() == null) {
            persistentClass.getRootClass().setEntityPersisterClass(UnionSubclassEntityPersister.class);
        }
        if (onDeleteAnn != null && !onDeleteAppropriate) {
            log.warn((Object)("Inapropriate use of @OnDelete on entity, annotation ignored: " + propertyHolder.getEntityName()));
        }
        HashMap<String, IdGenerator> classGenerators = AnnotationBinder.buildLocalGenerators(annotatedClass);
        HashMap<String, Properties> classGeneratorTables = AnnotationBinder.buildLocalGeneratorTable(annotatedClass);
        HashSet<String> idProperties = new HashSet<String>();
        if (annotatedClass.isAnnotationPresent(IdClass.class)) {
            IdClass idClass = annotatedClass.getAnnotation(IdClass.class);
            Class compositeClass = idClass.value();
            Embeddable embeddableAnn = compositeClass.getAnnotation(Embeddable.class);
            boolean isComponent = true;
            boolean propertyAccess = true;
            if (embeddableAnn != null && embeddableAnn.access() == AccessType.FIELD) {
                propertyAccess = false;
            }
            String generatorType = "assigned";
            String generator = ANNOTATION_STRING_DEFAULT;
            PropertyInferredData inferredData = new PropertyInferredData(propertyAccess ? "property" : "field", "id", compositeClass);
            HashMap<String, IdGenerator> localGenerators = new HashMap<String, IdGenerator>();
            HashMap<String, Properties> localGeneratorTables = new HashMap<String, Properties>();
            AnnotationBinder.bindId(generatorType, generator, inferredData, null, propertyHolder, localGenerators, localGeneratorTables, isComponent, columnOverride, propertyAccess, entityBinder, null, true, mappings);
            inferredData = new PropertyInferredData(propertyAccess ? "property" : "field", "_identifierMapper", compositeClass);
            Component mapper = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAccess, false, entityBinder, true, columnOverride, mappings);
            mapper.setEmbedded(true);
            persistentClass.setIdentifierMapper(mapper);
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setNodeName("id");
            property.setUpdateable(false);
            property.setInsertable(false);
            property.setValue((Value)mapper);
            property.setPropertyAccessorName("embedded");
            persistentClass.addProperty(property);
            entityBinder.setIgnoreIdAnnotations(true);
            Iterator properties = mapper.getPropertyIterator();
            while (properties.hasNext()) {
                idProperties.add(((Property)properties.next()).getName());
            }
        }
        List<Class> classesToProcess = AnnotationBinder.orderClassesToBeProcessed(clazzToProcess, inheritanceStatePerClass, inheritanceState);
        int deep = classesToProcess.size();
        ArrayList<PropertyAnnotatedElement> elements = new ArrayList<PropertyAnnotatedElement>();
        boolean hasIdentifier = false;
        for (int index = 0; index < deep; ++index) {
            Class clazz = classesToProcess.get(index);
            InheritanceState state = inheritanceStatePerClass.get(clazz);
            boolean isPropertyAccess = state.isEmbeddableSuperclass ? state.accessType == AccessType.PROPERTY : entityBinder.isPropertyAccess();
            boolean currentHasIdentifier = AnnotationBinder.addElementsOfAClass(elements, propertyHolder, isPropertyAccess, clazz);
            hasIdentifier = hasIdentifier || currentHasIdentifier;
        }
        boolean rootEntityWoId = !entityBinder.isIgnoreIdAnnotations() && !hasIdentifier && !inheritanceState.hasParents;
        boolean bl3 = subclassAndSingleTableStrategy = inheritanceState.type == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents;
        if (rootEntityWoId) {
            throw new AnnotationException("No identifier specified for entity: " + propertyHolder.getEntityName());
        }
        HashSet missingIdProperties = new HashSet(idProperties);
        for (PropertyAnnotatedElement propertyAnnotatedElement : elements) {
            String propertyName = propertyAnnotatedElement.inferredData.getPropertyName();
            if (!idProperties.contains(propertyName)) {
                AnnotationBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement.element, propertyAnnotatedElement.inferredData, classGenerators, classGeneratorTables, entityBinder, false, mappings);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (missingIdProperties.size() != 0) {
            StringBuffer missings = new StringBuffer();
            for (String property : missingIdProperties) {
                missings.append(property).append(", ");
            }
            throw new AnnotationException("Unable to find properties (" + missings.substring(0, missings.length() - 2) + ") in entity annotated with @IdClass:" + persistentClass.getEntityName());
        }
        if (!inheritanceState.hasParents) {
            persistentClass.createPrimaryKey();
        } else {
            superEntity.addSubclass((Subclass)persistentClass);
        }
        mappings.addClass((PersistentClass)persistentClass);
        entityBinder.finalSecondaryTableBinding(propertyHolder);
        entityBinder.addIndexes(annotatedClass.getAnnotation(org.hibernate.annotations.Table.class));
        entityBinder.addIndexes(annotatedClass.getAnnotation(Tables.class));
        ResourceBundle rb = null;
        new ClassValidator(clazzToProcess, rb).apply((PersistentClass)persistentClass);
    }

    private static List<Class> orderClassesToBeProcessed(Class annotatedClass, Map<Class, InheritanceState> inheritanceStatePerClass, InheritanceState inheritanceState) {
        InheritanceState superclassState;
        ArrayList<Class> classesToProcess = new ArrayList<Class>();
        Class currentClassInHierarchy = annotatedClass;
        do {
            classesToProcess.add(0, currentClassInHierarchy);
            currentClassInHierarchy = currentClassInHierarchy.getSuperclass();
            superclassState = inheritanceStatePerClass.get(currentClassInHierarchy);
        } while (!inheritanceState.hasParents && superclassState != null);
        return classesToProcess;
    }

    private static void bindFilterDefs(AnnotatedElement annotatedElement, ExtendedMappings mappings) {
        FilterDef defAnn = annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs defsAnn = annotatedElement.getAnnotation(FilterDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindFilterDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (FilterDef def : defsAnn.value()) {
                AnnotationBinder.bindFilterDef(def, mappings);
            }
        }
    }

    private static void bindFilterDef(FilterDef defAnn, ExtendedMappings mappings) {
        FilterDefinition def = new FilterDefinition(defAnn.name());
        for (ParamDef param : defAnn.parameters()) {
            TypeFactory.heuristicType((String)param.type());
            def.addParameterType(param.name(), TypeFactory.heuristicType((String)param.type()));
        }
        mappings.addFilterDefinition(def);
    }

    private static void bindTypeDefs(AnnotatedElement annotatedElement, ExtendedMappings mappings) {
        TypeDef defAnn = annotatedElement.getAnnotation(TypeDef.class);
        TypeDefs defsAnn = annotatedElement.getAnnotation(TypeDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindTypeDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (TypeDef def : defsAnn.value()) {
                AnnotationBinder.bindTypeDef(def, mappings);
            }
        }
    }

    private static void bindTypeDef(TypeDef defAnn, ExtendedMappings mappings) {
        Properties params = new Properties();
        for (Parameter param : defAnn.parameters()) {
            params.setProperty(param.name(), param.value());
        }
        mappings.addTypeDef(defAnn.name(), defAnn.typeClass().getName(), params);
    }

    private static HashMap<String, Properties> buildLocalGeneratorTable(AnnotatedElement annotatedClass) {
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        GeneratedIdTable ann = annotatedClass.getAnnotation(GeneratedIdTable.class);
        if (ann != null) {
            result.put(ann.name(), AnnotationBinder.buildPropertiesFromGeneratorTable(ann));
        }
        return result;
    }

    private static void bindDiscriminatorToPersistentClass(RootClass rootClass, Ejb3DiscriminatorColumn discriminatorColumn, Map<String, Join> secondaryTables, PropertyHolder propertyHolder) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            discriminatorColumn.setJoins(secondaryTables);
            discriminatorColumn.setPropertyHolder(propertyHolder);
            SimpleValue discrim = new SimpleValue(rootClass.getTable());
            rootClass.setDiscriminator((Value)discrim);
            discriminatorColumn.linkWithValue(discrim);
            discrim.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            log.debug((Object)("Setting discriminator for entity " + rootClass.getEntityName()));
        }
    }

    private static boolean addElementsOfAClass(List<PropertyAnnotatedElement> elements, PropertyHolder propertyHolder, boolean propertyAccess, Class annotatedClass) {
        boolean hasIdentifier = false;
        if (propertyAccess) {
            log.debug((Object)("Processing " + propertyHolder.getEntityName() + " per property access"));
            Method[] methods = annotatedClass.getDeclaredMethods();
            for (int index = 0; index < methods.length; ++index) {
                Method currentElt = methods[index];
                boolean currentHasIdentifier = AnnotationBinder.addAnnotatedElement(currentElt, elements);
                hasIdentifier = hasIdentifier || currentHasIdentifier;
            }
        } else {
            log.debug((Object)("Processing " + propertyHolder.getEntityName() + " per field access"));
            Field[] fields = annotatedClass.getDeclaredFields();
            for (int index = 0; index < fields.length; ++index) {
                Field currentElt = fields[index];
                boolean currentHasIdentifier = AnnotationBinder.addAnnotatedElement(currentElt, elements);
                hasIdentifier = hasIdentifier || currentHasIdentifier;
            }
        }
        return hasIdentifier;
    }

    private static boolean addAnnotatedElement(AnnotatedElement elt, List<PropertyAnnotatedElement> annElts) {
        boolean hasIdentifier = false;
        PropertyAnnotatedElement propertyAnnotatedElement = new PropertyAnnotatedElement(elt);
        if (!propertyAnnotatedElement.inferredData.skip()) {
            AnnotatedElement element = propertyAnnotatedElement.element;
            if (element.isAnnotationPresent(Id.class) || element.isAnnotationPresent(EmbeddedId.class)) {
                annElts.add(0, propertyAnnotatedElement);
                hasIdentifier = true;
            } else {
                annElts.add(propertyAnnotatedElement);
                hasIdentifier = false;
            }
        }
        return hasIdentifier;
    }

    private static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, AnnotatedElement annotatedElt, PropertyInferredData inferredData, HashMap<String, IdGenerator> classGenerators, HashMap<String, Properties> classGeneratorTables, EntityBinder entityBinder, boolean isIdentifierMapper, ExtendedMappings mappings) throws MappingException {
        javax.persistence.Column ann;
        Ejb3Column[] columns = null;
        if (annotatedElt.isAnnotationPresent(Transient.class)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing annotations of " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName()));
        }
        if (annotatedElt.isAnnotationPresent(javax.persistence.Column.class) || annotatedElt.isAnnotationPresent(Formula.class)) {
            ann = annotatedElt.getAnnotation(javax.persistence.Column.class);
            Formula formulaAnn = annotatedElt.getAnnotation(Formula.class);
            columns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{ann}, formulaAnn, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
            columns[0].addIndex(annotatedElt.getAnnotation(Index.class));
        } else if (annotatedElt.isAnnotationPresent(Columns.class)) {
            Columns anns = annotatedElt.getAnnotation(Columns.class);
            columns = Ejb3Column.buildColumnFromAnnotation(anns.columns(), null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        } else if (annotatedElt.isAnnotationPresent(JoinColumn.class)) {
            ann = annotatedElt.getAnnotation(JoinColumn.class);
            columns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)ann, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings)};
        } else if (annotatedElt.isAnnotationPresent(JoinColumns.class)) {
            ann = annotatedElt.getAnnotation(JoinColumns.class);
            JoinColumn[] annColumns = ann.value();
            int length = annColumns.length;
            if (length == 0) {
                throw new AnnotationException("Cannot bind an empty @JoinColumns");
            }
            columns = new Ejb3JoinColumn[length];
            for (int index = 0; index < length; ++index) {
                columns[index] = Ejb3JoinColumn.buildJoinColumn(annColumns[index], entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
            }
        } else if (annotatedElt.isAnnotationPresent(javax.persistence.ManyToOne.class) || annotatedElt.isAnnotationPresent(OneToOne.class)) {
            columns = new Ejb3JoinColumn[1];
            if (annotatedElt.isAnnotationPresent(JoinTable.class)) {
                JoinTable assocTable = annotatedElt.getAnnotation(JoinTable.class);
                throw new NotYetImplementedException("association table on a single ended association is not yet supported");
            }
            columns[0] = Ejb3JoinColumn.buildImplicitJoinColumn(null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
        } else if (annotatedElt.isAnnotationPresent(OneToMany.class)) {
            columns = new Ejb3JoinColumn[1];
            String mappedBy = annotatedElt.getAnnotation(OneToMany.class).mappedBy();
            columns[0] = Ejb3JoinColumn.buildImplicitJoinColumn(mappedBy, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
        } else {
            columns = Ejb3Column.buildColumnFromAnnotation(null, null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        }
        if (nullability == Nullability.FORCED_NOT_NULL) {
            for (Ejb3Column col : columns) {
                col.forceNotNull();
            }
        }
        Class returnedClass = inferredData.getReturnedClassOrElement();
        if (!entityBinder.isIgnoreIdAnnotations() && (annotatedElt.isAnnotationPresent(Id.class) || annotatedElt.isAnnotationPresent(EmbeddedId.class))) {
            if (isIdentifierMapper) {
                throw new AnnotationException("@IdClass class should not have @Id nor @EmbeddedId proeperties");
            }
            log.debug((Object)(inferredData.getPropertyName() + " is an id"));
            Id idAnn = annotatedElt.getAnnotation(Id.class);
            EmbeddedId embeddedId = annotatedElt.getAnnotation(EmbeddedId.class);
            HashMap localGenerators = (HashMap)classGenerators.clone();
            HashMap localGeneratorTables = (HashMap)classGeneratorTables.clone();
            localGenerators.putAll(AnnotationBinder.buildLocalGenerators(annotatedElt));
            localGeneratorTables.putAll(AnnotationBinder.buildLocalGeneratorTable(annotatedElt));
            Embeddable embeddableAnn = returnedClass.getAnnotation(Embeddable.class);
            Map<String, javax.persistence.Column[]> columnOverride = PropertyHolderBuilder.buildColumnOverride(annotatedElt);
            boolean isComponent = embeddableAnn != null || embeddedId != null;
            boolean propertyAccess = true;
            if (isComponent && embeddableAnn != null && embeddableAnn.access() == AccessType.FIELD) {
                propertyAccess = false;
            }
            String generatorType = idAnn != null ? AnnotationBinder.generatorType(idAnn.generate()) : "assigned";
            String generator = idAnn != null ? idAnn.generator() : ANNOTATION_STRING_DEFAULT;
            Type typeAnn = annotatedElt.getAnnotation(Type.class);
            AnnotationBinder.bindId(generatorType, generator, inferredData, columns[0], propertyHolder, localGenerators, localGeneratorTables, isComponent, columnOverride, propertyAccess, entityBinder, typeAnn, false, mappings);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bind " + (isComponent ? "@Id" : "@EmbeddedId") + " on " + inferredData.getPropertyName()));
            }
        } else if (annotatedElt.isAnnotationPresent(Version.class)) {
            if (isIdentifierMapper) {
                throw new AnnotationException("@IdClass class should not have @Version proeperty");
            }
            if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
                throw new AnnotationException("Unable to define/override @Version on a subclass: " + propertyHolder.getEntityName());
            }
            log.debug((Object)(inferredData.getPropertyName() + " is a version property"));
            RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
            boolean lazy = false;
            Type annType = annotatedElt.getAnnotation(Type.class);
            PropertyBinder propBinder = new PropertyBinder();
            propBinder.setName(inferredData.getPropertyName());
            propBinder.setReturnedClassName(inferredData.getReturnedClassName());
            propBinder.setLazy(lazy);
            propBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
            propBinder.setColumns(columns);
            propBinder.setHolder(propertyHolder);
            propBinder.setExplicitType(annType);
            propBinder.setMappings(mappings);
            Property prop = propBinder.bind();
            rootClass.setVersion(prop);
            SimpleValue simpleValue = (SimpleValue)prop.getValue();
            if (!simpleValue.isTypeSpecified()) {
                simpleValue.setTypeName("integer");
            }
            simpleValue.setNullValue("undefined");
            rootClass.setOptimisticLockMode(0);
            log.debug((Object)("Version name: " + rootClass.getVersion().getName() + ", unsavedValue: " + ((SimpleValue)rootClass.getVersion().getValue()).getNullValue()));
        } else if (annotatedElt.isAnnotationPresent(javax.persistence.ManyToOne.class)) {
            javax.persistence.ManyToOne ann2 = annotatedElt.getAnnotation(javax.persistence.ManyToOne.class);
            Cascade hibernateCascade = annotatedElt.getAnnotation(Cascade.class);
            Ejb3JoinColumn.checkIfJoinColumn(columns, propertyHolder, inferredData);
            AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann2.cascade(), hibernateCascade), (Ejb3JoinColumn[])columns, ann2.optional(), AnnotationBinder.getFetchMode(ann2.fetch()), inferredData.getPropertyName(), inferredData.getReturnedClassOrElementName(), ann2.targetEntity(), inferredData.getDefaultAccess(), propertyHolder, false, isIdentifierMapper, mappings);
        } else if (annotatedElt.isAnnotationPresent(OneToOne.class)) {
            OneToOne ann3 = annotatedElt.getAnnotation(OneToOne.class);
            boolean trueOneToOne = annotatedElt.isAnnotationPresent(PrimaryKeyJoinColumn.class);
            Cascade hibernateCascade = annotatedElt.getAnnotation(Cascade.class);
            Ejb3JoinColumn.checkIfJoinColumn(columns, propertyHolder, inferredData);
            AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(ann3.cascade(), hibernateCascade), (Ejb3JoinColumn[])columns, ann3.optional(), AnnotationBinder.getFetchMode(ann3.fetch()), inferredData.getPropertyName(), inferredData.getReturnedClassName(), ann3.targetEntity(), inferredData.getDefaultAccess(), propertyHolder, ann3.mappedBy(), trueOneToOne, isIdentifierMapper, mappings);
        } else if (annotatedElt.isAnnotationPresent(OneToMany.class) || annotatedElt.isAnnotationPresent(ManyToMany.class)) {
            Filters filtersAnn;
            OneToMany oneToManyAnn = annotatedElt.getAnnotation(OneToMany.class);
            ManyToMany manyToManyAnn = annotatedElt.getAnnotation(ManyToMany.class);
            org.hibernate.annotations.IndexColumn indexAnn = annotatedElt.getAnnotation(org.hibernate.annotations.IndexColumn.class);
            JoinTable assocTable = annotatedElt.getAnnotation(JoinTable.class);
            boolean isForeignKey = oneToManyAnn != null && assocTable == null && (columns[0].isImplicit() && !AnnotationBinder.isDefault(oneToManyAnn.mappedBy()) || !columns[0].isImplicit());
            IndexColumn indexColumn = IndexColumn.buildColumnFromAnnotation(indexAnn, propertyHolder, inferredData, mappings);
            CollectionBinder collectionBinder = CollectionBinder.getCollectionBinder(propertyHolder.getEntityName(), inferredData, !indexColumn.isImplicit());
            collectionBinder.setIndexColumn(indexColumn);
            MapKey mapKeyAnn = annotatedElt.getAnnotation(MapKey.class);
            collectionBinder.setMapKey(mapKeyAnn);
            collectionBinder.setPropertyName(inferredData.getPropertyName());
            BatchSize batchAnn = annotatedElt.getAnnotation(BatchSize.class);
            collectionBinder.setBatchSize(batchAnn);
            OrderBy ejb3OrderByAnn = annotatedElt.getAnnotation(OrderBy.class);
            org.hibernate.annotations.OrderBy orderByAnn = annotatedElt.getAnnotation(org.hibernate.annotations.OrderBy.class);
            collectionBinder.setEjb3OrderBy(ejb3OrderByAnn);
            collectionBinder.setSqlOrderBy(orderByAnn);
            Sort sortAnn = annotatedElt.getAnnotation(Sort.class);
            collectionBinder.setSort(sortAnn);
            Cache cachAnn = annotatedElt.getAnnotation(Cache.class);
            collectionBinder.setCache(cachAnn);
            Filter filterAnn = annotatedElt.getAnnotation(Filter.class);
            if (filterAnn != null) {
                collectionBinder.addFilter(filterAnn.name(), filterAnn.condition());
            }
            if ((filtersAnn = annotatedElt.getAnnotation(Filters.class)) != null) {
                for (Filter filter : filtersAnn.value()) {
                    collectionBinder.addFilter(filter.name(), filter.condition());
                }
            }
            collectionBinder.setPropertyHolder(propertyHolder);
            Where whereAnn = annotatedElt.getAnnotation(Where.class);
            collectionBinder.setWhere(whereAnn);
            Cascade hibernateCascade = annotatedElt.getAnnotation(Cascade.class);
            collectionBinder.setCollectionType(inferredData.getCollectionType());
            collectionBinder.setMappings(mappings);
            collectionBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
            if (oneToManyAnn != null && manyToManyAnn != null) {
                throw new AnnotationException("@OneToMany and @ManyToMany on the same property is not allowed: " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName());
            }
            String mappedBy = null;
            if (oneToManyAnn != null) {
                Ejb3JoinColumn.checkIfJoinColumn(columns, propertyHolder, inferredData);
                for (Ejb3JoinColumn column : (Ejb3JoinColumn[])columns) {
                    if (!column.isSecondary()) continue;
                    throw new NotYetImplementedException("Collections having FK in secondary table");
                }
                collectionBinder.setJoinColumns((Ejb3JoinColumn[])columns);
                mappedBy = oneToManyAnn.mappedBy();
                collectionBinder.setUnique(true);
                collectionBinder.setTargetEntity(oneToManyAnn.targetEntity());
                collectionBinder.setFetchType(oneToManyAnn.fetch());
                collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(oneToManyAnn.cascade(), hibernateCascade));
            } else if (manyToManyAnn != null) {
                mappedBy = manyToManyAnn.mappedBy();
                collectionBinder.setUnique(false);
                collectionBinder.setTargetEntity(manyToManyAnn.targetEntity());
                collectionBinder.setFetchType(manyToManyAnn.fetch());
                collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(manyToManyAnn.cascade(), hibernateCascade));
            }
            collectionBinder.setMappedBy(mappedBy);
            if (isForeignKey) {
                for (Ejb3JoinColumn column : (Ejb3JoinColumn[])columns) {
                    if (!column.isSecondary()) continue;
                    throw new NotYetImplementedException("Collections having FK in secondary table");
                }
                collectionBinder.setOneToMany(true);
            } else {
                collectionBinder.setOneToMany(false);
                AnnotationBinder.bindJoinedTableAssociation(assocTable, mappings, entityBinder, collectionBinder, propertyHolder, inferredData, mappedBy);
            }
            OnDelete onDeleteAnn = annotatedElt.getAnnotation(OnDelete.class);
            boolean onDeleteCascade = onDeleteAnn != null ? OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action()) : false;
            collectionBinder.setCascadeDeleteEnabled(onDeleteCascade);
            if (isIdentifierMapper) {
                collectionBinder.setInsertable(false);
                collectionBinder.setUpdatable(false);
            }
            collectionBinder.bind();
        } else {
            boolean isComponent = false;
            Embeddable embeddableAnn = returnedClass.getAnnotation(Embeddable.class);
            Embedded embeddedAnn = annotatedElt.getAnnotation(Embedded.class);
            if (embeddedAnn != null || embeddableAnn != null) {
                isComponent = true;
            }
            if (isComponent) {
                boolean propertyAccess = true;
                if (embeddableAnn != null && embeddableAnn.access() == AccessType.FIELD) {
                    propertyAccess = false;
                }
                Map<String, javax.persistence.Column[]> columnOverride = PropertyHolderBuilder.buildColumnOverride(annotatedElt);
                AnnotationBinder.bindComponent(inferredData, propertyHolder, propertyAccess, entityBinder, isIdentifierMapper, columnOverride, mappings);
            } else {
                Properties typeParameters = null;
                boolean lazy = false;
                String type = ANNOTATION_STRING_DEFAULT;
                if (annotatedElt.isAnnotationPresent(Basic.class)) {
                    Basic ann4 = annotatedElt.getAnnotation(Basic.class);
                    if (!ann4.optional() && nullability != Nullability.FORCED_NULL) {
                        for (Ejb3Column col : columns) {
                            col.forceNotNull();
                        }
                    }
                    lazy = ann4.fetch() == FetchType.LAZY;
                    switch (ann4.temporalType()) {
                        case DATE: {
                            type = "date";
                            break;
                        }
                        case TIME: {
                            type = "time";
                            break;
                        }
                        case TIMESTAMP: {
                            type = "timestamp";
                            break;
                        }
                        case NONE: {
                            break;
                        }
                        default: {
                            throw new AssertionFailure("Unknown temporal tyme: " + ann4.temporalType());
                        }
                    }
                } else if (annotatedElt.isAnnotationPresent(Lob.class)) {
                    Lob lob = annotatedElt.getAnnotation(Lob.class);
                    if (!lob.optional() && nullability != Nullability.FORCED_NULL) {
                        for (Ejb3Column col : columns) {
                            col.forceNotNull();
                        }
                    }
                    lazy = lob.fetch() == FetchType.LAZY;
                    LobType lobType = lob.type();
                    if (LobType.CLOB.equals((Object)lobType)) {
                        type = String.class.equals((Object)returnedClass) ? StringClobType.class.getName() : (Character.class.equals((Object)returnedClass) && inferredData.isArray() ? CharacterArrayClobType.class.getName() : (Character.TYPE.equals(returnedClass) && inferredData.isArray() ? PrimitiveCharacterArrayClobType.class.getName() : "clob"));
                    }
                    if (LobType.BLOB.equals((Object)lobType)) {
                        if (Byte.class.equals((Object)returnedClass) && inferredData.isArray()) {
                            type = ByteArrayBlobType.class.getName();
                        } else if (Byte.TYPE.equals(returnedClass) && inferredData.isArray()) {
                            type = PrimitiveByteArrayBlobType.class.getName();
                        } else if (returnedClass instanceof Serializable) {
                            type = SerializableToBlobType.class.getName();
                            typeParameters = new Properties();
                            typeParameters.setProperty("classname", returnedClass.getName());
                        } else {
                            type = "blob";
                        }
                    }
                } else if (Clob.class.equals((Object)returnedClass)) {
                    type = "clob";
                } else if (Blob.class.equals((Object)returnedClass)) {
                    type = "blob";
                }
                if (ANNOTATION_STRING_DEFAULT.equals(type) && returnedClass.isEnum()) {
                    type = EnumType.class.getName();
                    typeParameters = new Properties();
                    typeParameters.setProperty("enumClass", returnedClass.getName());
                    String schema = columns[0].getTable().getSchema();
                    schema = schema == null ? ANNOTATION_STRING_DEFAULT : schema;
                    String catalog = columns[0].getTable().getCatalog();
                    catalog = catalog == null ? ANNOTATION_STRING_DEFAULT : catalog;
                    typeParameters.setProperty("schema", schema);
                    typeParameters.setProperty("catalog", catalog);
                    typeParameters.setProperty("table", columns[0].getTable().getName());
                    typeParameters.setProperty("column", columns[0].getName());
                }
                Type annType = annotatedElt.getAnnotation(Type.class);
                PropertyBinder propBinder = new PropertyBinder();
                propBinder.setName(inferredData.getPropertyName());
                propBinder.setReturnedClassName(inferredData.getReturnedClassName());
                propBinder.setLazy(lazy);
                propBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
                propBinder.setColumns(columns);
                propBinder.setHolder(propertyHolder);
                propBinder.setExplicitType(annType);
                propBinder.setExplicitType(type);
                propBinder.setTypeParameters(typeParameters);
                propBinder.setMappings(mappings);
                if (isIdentifierMapper) {
                    propBinder.setInsertable(false);
                    propBinder.setUpdatable(false);
                }
                propBinder.bind();
            }
        }
    }

    private static void bindJoinedTableAssociation(JoinTable joinTableAnn, ExtendedMappings mappings, EntityBinder entityBinder, CollectionBinder collectionBinder, PropertyHolder propertyHolder, PropertyInferredData inferredData, String mappedBy) {
        JoinColumn[] annInverseJoins;
        JoinColumn[] annJoins;
        org.hibernate.mapping.Table assocTable;
        if (joinTableAnn != null) {
            assocTable = !joinTableAnn.table().specified() ? null : TableBinder.fillTable(joinTableAnn.table().schema(), joinTableAnn.table().catalog(), mappings.getNamingStrategy().tableName(joinTableAnn.table().name()), false, new ArrayList(), null, null, mappings);
            JoinColumn[] joins = joinTableAnn.joinColumns();
            annJoins = joins.length == 0 ? null : joins;
            JoinColumn[] inverseJoins = joinTableAnn.inverseJoinColumns();
            annInverseJoins = inverseJoins.length == 0 ? null : inverseJoins;
        } else {
            assocTable = null;
            annJoins = null;
            annInverseJoins = null;
        }
        Ejb3JoinColumn[] joinColumns = AnnotationBinder.buildJoinTableJoinColumns(annJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        Ejb3JoinColumn[] inverseJoinColumns = AnnotationBinder.buildJoinTableJoinColumns(annInverseJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        collectionBinder.setTable(assocTable);
        collectionBinder.setJoinColumns(joinColumns);
        collectionBinder.setInverseJoinColumns(inverseJoinColumns);
    }

    private static Ejb3JoinColumn[] buildJoinTableJoinColumns(JoinColumn[] annJoins, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, String propertyName, String mappedBy, ExtendedMappings mappings) {
        Ejb3JoinColumn[] joinColumns;
        if (annJoins == null) {
            Ejb3JoinColumn currentJoinColumn = new Ejb3JoinColumn();
            currentJoinColumn.setImplicit(true);
            currentJoinColumn.setNullable(false);
            currentJoinColumn.setPropertyHolder(propertyHolder);
            currentJoinColumn.setJoins(secondaryTables);
            currentJoinColumn.setMappings(mappings);
            currentJoinColumn.setPropertyName(propertyName);
            currentJoinColumn.setMappedBy(mappedBy);
            currentJoinColumn.bind();
            joinColumns = new Ejb3JoinColumn[]{currentJoinColumn};
        } else {
            joinColumns = new Ejb3JoinColumn[annJoins.length];
            for (JoinColumn annJoin : annJoins) {
                Ejb3JoinColumn currentJoinColumn = new Ejb3JoinColumn();
                currentJoinColumn.setImplicit(true);
                currentJoinColumn.setPropertyHolder(propertyHolder);
                currentJoinColumn.setJoins(secondaryTables);
                currentJoinColumn.setMappings(mappings);
                currentJoinColumn.setPropertyName(propertyName);
                currentJoinColumn.setMappedBy(mappedBy);
                currentJoinColumn.setJoinAnnotation(annJoin, propertyName);
                currentJoinColumn.setNullable(false);
                currentJoinColumn.bind();
                joinColumns[index] = currentJoinColumn;
            }
        }
        return joinColumns;
    }

    private static void bindComponent(PropertyInferredData inferredData, PropertyHolder propertyHolder, boolean propertyAccess, EntityBinder entityBinder, boolean isIdentifierMapper, Map<String, javax.persistence.Column[]> columnOverride, ExtendedMappings mappings) {
        Component comp = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAccess, true, entityBinder, isIdentifierMapper, columnOverride, mappings);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue((Value)comp);
        binder.setPropertyAccessorName(inferredData.getDefaultAccess());
        Property prop = binder.make();
        propertyHolder.addProperty(prop);
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyInferredData inferredData, boolean propertyAccess, boolean isNullable, EntityBinder entityBinder, boolean isIdentifierMapper, Map<String, javax.persistence.Column[]> columnOverride, ExtendedMappings mappings) {
        Component comp = new Component(propertyHolder.getPersistentClass());
        if (!isIdentifierMapper) {
            comp.setComponentClassName(inferredData.getReturnedClassName());
        } else {
            comp.setComponentClassName(comp.getOwner().getClassName());
        }
        String subpath = StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName());
        log.debug((Object)("Binding component with path: " + subpath));
        Map<String, javax.persistence.Column[]> localColumnOverride = propertyHolder.mergeOverridenColumns(columnOverride);
        PropertyHolder subHolder = PropertyHolderBuilder.buildPropertyHolder(comp, subpath, localColumnOverride);
        ArrayList<PropertyAnnotatedElement> classElements = new ArrayList<PropertyAnnotatedElement>();
        AnnotationBinder.addElementsOfAClass(classElements, subHolder, propertyAccess, inferredData.getReturnedClass());
        for (PropertyAnnotatedElement propertyAnnotatedElement : classElements) {
            AnnotationBinder.processElementAnnotations(subHolder, isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL, propertyAnnotatedElement.element, propertyAnnotatedElement.inferredData, new HashMap<String, IdGenerator>(), new HashMap<String, Properties>(), entityBinder, isIdentifierMapper, mappings);
        }
        return comp;
    }

    private static void bindId(String generatorType, String generatorName, PropertyInferredData inferredData, Ejb3Column column, PropertyHolder propertyHolder, Map<String, IdGenerator> localGenerators, HashMap<String, Properties> localGeneratorTables, boolean isComposite, Map<String, javax.persistence.Column[]> columnOverride, boolean isPropertyAccess, EntityBinder entityBinder, Type typeAnn, boolean isEmbedded, ExtendedMappings mappings) {
        Component id;
        String persistentClassName;
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Unable to define/override @Id(s) on a subclass: " + propertyHolder.getEntityName());
        }
        RootClass rootClass = (RootClass)persistentClass;
        String string = persistentClassName = rootClass == null ? null : rootClass.getClassName();
        if (isComposite) {
            id = AnnotationBinder.fillComponent(propertyHolder, inferredData, isPropertyAccess, false, entityBinder, false, columnOverride, mappings);
            id.setKey(true);
        } else {
            column.forceNotNull();
            SimpleValueBinder value = new SimpleValueBinder();
            value.setPropertyName(inferredData.getPropertyName());
            value.setReturnedClassName(inferredData.getReturnedClassName());
            value.setColumns(new Ejb3Column[]{column});
            value.setPersistentClassName(persistentClassName);
            value.setMappings(mappings);
            value.setExplicitType(typeAnn);
            id = value.make();
        }
        rootClass.setIdentifier((KeyValue)id);
        org.hibernate.mapping.Table table = id.getTable();
        table.setIdentifierValue((KeyValue)id);
        id.setIdentifierGeneratorStrategy(generatorType);
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        params.setProperty("target_column", ((Column)id.getColumnIterator().next()).getName());
        if (!AnnotationBinder.isDefault(generatorName)) {
            boolean overrideType;
            IdGenerator gen = mappings.getGenerator(generatorName, localGenerators);
            if (gen == null) {
                throw new AnnotationException("Unknown Id.generator: " + generatorName);
            }
            boolean bl = overrideType = !AnnotationBinder.generatorType(GeneratorType.AUTO).equals(generatorType);
            if (overrideType) {
                id.setIdentifierGeneratorStrategy(gen.getIdentifierGeneratorStrategy());
            }
            for (Map.Entry<Object, Object> elt : gen.getParams().entrySet()) {
                params.setProperty((String)elt.getKey(), (String)elt.getValue());
            }
            if (MultipleHiLoPerTableGenerator.class.getName().equals(generatorType)) {
                AnnotationBinder.fillGeneratorWithGeneratorTableParams(params, localGeneratorTables, generatorName, mappings);
            }
        }
        if (generatorType == "assigned") {
            id.setNullValue("undefined");
        }
        id.setIdentifierGeneratorProperties(params);
        if (isEmbedded) {
            rootClass.setEmbeddedIdentifier(inferredData.getReturnedClass() == null);
        } else {
            PropertyBinder binder = new PropertyBinder();
            binder.setName(inferredData.getPropertyName());
            binder.setValue((Value)id);
            binder.setPropertyAccessorName(inferredData.getDefaultAccess());
            Property prop = binder.make();
            rootClass.setIdentifierProperty(prop);
        }
    }

    private static void checkIfMatchingGenerator(IdGenerator gen, String generatorType, String generatorName) {
        boolean matchingGenerator = gen.getIdentifierGeneratorStrategy().equals(generatorType);
        boolean defaultGenerator = AnnotationBinder.generatorType(GeneratorType.AUTO).equals(generatorType);
        if (!matchingGenerator && !defaultGenerator) {
            throw new AnnotationException("Incompatible generator between Id.generate and its named generator: " + generatorType + "!=" + generatorName);
        }
    }

    private static void fillGeneratorWithGeneratorTableParams(Properties params, HashMap<String, Properties> localGeneratorTables, String generatorName, ExtendedMappings mappings) {
        String generatorTableName = params.getProperty(GENERATOR_TABLE_NAME_PARAM);
        Properties props = mappings.getGeneratorTableProperties(generatorTableName, localGeneratorTables);
        if (props == null) {
            if ("hibernate_sequences".equals(generatorTableName)) {
                return;
            }
            throw new AnnotationException("Unable to find a @GeneratedIdTable for table name in " + generatorName + ": " + generatorTableName);
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            params.setProperty((String)property.getKey(), (String)property.getValue());
        }
    }

    private static void bindManyToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, String propertyName, String returnedClassName, Class targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, boolean unique, boolean isIdentifierMapper, ExtendedMappings mappings) {
        ManyToOne value = new ManyToOne(columns[0].getTable());
        if (AnnotationBinder.isDefault(targetEntity)) {
            value.setReferencedEntityName(returnedClassName);
        } else {
            value.setReferencedEntityName(targetEntity.getName());
        }
        value.setFetchMode(fetchMode);
        value.setLazy(fetchMode != FetchMode.JOIN);
        if (!optional) {
            for (Ejb3JoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        value.setTypeName(returnedClassName);
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        String propertyRef = value.getReferencedPropertyName();
        mappings.addSecondPass(new FkSecondPass((Value)value, columns, unique, mappings));
        Ejb3Column.checkPropertyConsistency(columns, propertyHolder.getEntityName() + propertyName);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setValue((Value)value);
        binder.setCascade(cascadeStrategy);
        if (isIdentifierMapper) {
            binder.setInsertable(false);
            binder.setInsertable(false);
        } else {
            binder.setInsertable(columns[0].isInsertable());
            binder.setUpdatable(columns[0].isUpdatable());
        }
        binder.setPropertyAccessorName(propertyAccessorName);
        binder.setCascade(cascadeStrategy);
        Property prop = binder.make();
        columns[0].addPropertyToMappingContainer(prop);
    }

    public static void bindFkSecondPass(ManyToOne manyToOne, Ejb3JoinColumn[] columns, Map persistentClasses, boolean unique, ExtendedMappings mappings) {
        PersistentClass ref = (PersistentClass)persistentClasses.get(manyToOne.getReferencedEntityName());
        if (ref == null) {
            throw new AnnotationException("Unable to find entity " + manyToOne.getReferencedEntityName());
        }
        BinderHelper.createSyntheticPropertyReference(columns, ref, (Value)manyToOne, mappings);
        TableBinder.bindFk(ref, null, columns, (SimpleValue)manyToOne, unique);
    }

    private static void bindOneToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, String propertyName, String returnedClassName, Class targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, String mappedBy, boolean trueOneToOne, boolean isIdentifierMapper, ExtendedMappings mappings) {
        log.debug((Object)("Fetching " + propertyName + " with " + fetchMode));
        boolean mapToPK = true;
        if (!trueOneToOne) {
            Iterator idColumns = propertyHolder.getIdentifier().getColumnIterator();
            ArrayList<String> idColumnNames = new ArrayList<String>();
            while (idColumns.hasNext()) {
                Column currentColumn = (Column)idColumns.next();
                idColumnNames.add(currentColumn.getName());
            }
            for (Ejb3JoinColumn col : columns) {
                if (idColumnNames.contains(col.getMappingColumn().getName())) continue;
                mapToPK = false;
                break;
            }
        }
        if (trueOneToOne || mapToPK || !AnnotationBinder.isDefault(mappedBy)) {
            String propertyRef;
            org.hibernate.mapping.OneToOne value = new org.hibernate.mapping.OneToOne(propertyHolder.getTable(), propertyHolder.getPersistentClass());
            value.setPropertyName(propertyName);
            if (AnnotationBinder.isDefault(targetEntity)) {
                value.setReferencedEntityName(returnedClassName);
            } else {
                value.setReferencedEntityName(targetEntity.getName());
            }
            value.setFetchMode(fetchMode);
            value.setLazy(fetchMode != FetchMode.JOIN);
            if (!optional) {
                value.setConstrained(true);
            }
            value.setForeignKeyType(value.isConstrained() ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
            if (!AnnotationBinder.isDefault(mappedBy)) {
                value.setReferencedPropertyName(mappedBy);
            }
            if ((propertyRef = value.getReferencedPropertyName()) != null) {
                mappings.addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
            }
            PropertyBinder binder = new PropertyBinder();
            binder.setName(propertyName);
            binder.setValue((Value)value);
            binder.setCascade(cascadeStrategy);
            binder.setPropertyAccessorName(propertyAccessorName);
            Property prop = binder.make();
            prop.setCascade(cascadeStrategy);
            propertyHolder.addProperty(prop);
        } else {
            AnnotationBinder.bindManyToOne(cascadeStrategy, columns, optional, fetchMode, propertyName, returnedClassName, targetEntity, propertyAccessorName, propertyHolder, true, isIdentifierMapper, mappings);
        }
    }

    private static String generatorType(GeneratorType generatorEnum) {
        switch (generatorEnum) {
            case NONE: {
                return "assigned";
            }
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return "native";
            }
            case TABLE: {
                return MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return "sequence";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + generatorEnum);
    }

    private static EnumSet<org.hibernate.annotations.CascadeType> convertToHibernateCascadeType(CascadeType[] ejbCascades) {
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = EnumSet.noneOf(org.hibernate.annotations.CascadeType.class);
        if (ejbCascades != null && ejbCascades.length > 0) {
            block7: for (CascadeType cascade : ejbCascades) {
                switch (cascade) {
                    case ALL: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.ALL);
                        continue block7;
                    }
                    case PERSIST: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.PERSIST);
                        continue block7;
                    }
                    case MERGE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.MERGE);
                        continue block7;
                    }
                    case REMOVE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REMOVE);
                        continue block7;
                    }
                    case REFRESH: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REFRESH);
                    }
                }
            }
        }
        return hibernateCascadeSet;
    }

    private static String getCascadeStrategy(CascadeType[] ejbCascades, Cascade hibernateCascadeAnnotation) {
        org.hibernate.annotations.CascadeType[] hibernateCascades;
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = AnnotationBinder.convertToHibernateCascadeType(ejbCascades);
        org.hibernate.annotations.CascadeType[] cascadeTypeArray = hibernateCascades = hibernateCascadeAnnotation == null ? null : hibernateCascadeAnnotation.value();
        if (hibernateCascades != null && hibernateCascades.length > 0) {
            for (org.hibernate.annotations.CascadeType cascadeType : hibernateCascades) {
                hibernateCascadeSet.add(cascadeType);
            }
        }
        StringBuffer cascade = new StringBuffer();
        Iterator cascadeType = hibernateCascadeSet.iterator();
        while (cascadeType.hasNext()) {
            switch ((org.hibernate.annotations.CascadeType)((Object)cascadeType.next())) {
                case ALL: {
                    cascade.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    cascade.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    cascade.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    cascade.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    cascade.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    cascade.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    cascade.append(",").append("replicate");
                    break;
                }
                case EVICT: {
                    cascade.append(",").append("evict");
                    break;
                }
                case DELETE: {
                    cascade.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    cascade.append(",").append("delete-orphan");
                    break;
                }
                case REMOVE: {
                    cascade.append(",").append("delete");
                }
            }
        }
        return cascade.length() > 0 ? cascade.substring(1) : "none";
    }

    private static FetchMode getFetchMode(FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    private static HashMap<String, IdGenerator> buildLocalGenerators(AnnotatedElement annElt) {
        IdGenerator idGen;
        HashMap<String, IdGenerator> generators = new HashMap<String, IdGenerator>();
        TableGenerator tabGen = annElt.getAnnotation(TableGenerator.class);
        SequenceGenerator seqGen = annElt.getAnnotation(SequenceGenerator.class);
        GenericGenerator genGen = annElt.getAnnotation(GenericGenerator.class);
        if (tabGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)tabGen);
            generators.put(idGen.getName(), idGen);
        }
        if (seqGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)seqGen);
            generators.put(idGen.getName(), idGen);
        }
        if (genGen != null) {
            idGen = AnnotationBinder.buildIdGenerator(genGen);
            generators.put(idGen.getName(), idGen);
        }
        return generators;
    }

    public static boolean isDefault(String annotationString) {
        return ANNOTATION_STRING_DEFAULT.equals(annotationString);
    }

    public static boolean isDefault(Class clazz) {
        return Void.TYPE.equals(clazz);
    }

    public static Map<Class, InheritanceState> buildInheritanceStates(List<Class> orderedClasses) {
        HashMap<Class, InheritanceState> inheritanceStatePerClass = new HashMap<Class, InheritanceState>(orderedClasses.size());
        for (Class clazz : orderedClasses) {
            Class superClazz = clazz.getSuperclass();
            InheritanceState state = new InheritanceState();
            state.setInheritanceType(clazz);
            if (orderedClasses.contains(superClazz)) {
                boolean nonDefault;
                InheritanceState superState = (InheritanceState)inheritanceStatePerClass.get(superClazz);
                superState.hasSons = true;
                if (superState.isEmbeddableSuperclass) {
                    state.hasParents = false;
                    state.hasEmbeddedSuperclass = true;
                } else {
                    state.hasParents = true;
                    state.hasEmbeddedSuperclass = false;
                }
                boolean bl = nonDefault = !InheritanceType.SINGLE_TABLE.equals((Object)state.type);
                if (superState.type != null) {
                    boolean mixingStrategy;
                    boolean bl2 = mixingStrategy = !state.type.equals((Object)superState.type);
                    if (nonDefault && mixingStrategy) {
                        log.warn((Object)("Mixing inheritance strategy in a entity hierarchy is not allowed, ignoring sub strategy in: " + clazz.getName()));
                    }
                    state.type = superState.type;
                }
            }
            inheritanceStatePerClass.put(clazz, state);
        }
        return inheritanceStatePerClass;
    }

    private static class PropertyAnnotatedElement {
        public AnnotatedElement element;
        public PropertyInferredData inferredData;

        public PropertyAnnotatedElement(AnnotatedElement elt) {
            this.element = elt;
            this.inferredData = new PropertyInferredData(this.element);
        }
    }
}

