/*
 * Decompiled with CFR 0.152.
 */
package org.aim42.htmlsanitycheck.check;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.aim42.htmlsanitycheck.Configuration;
import org.aim42.htmlsanitycheck.check.Checker;
import org.aim42.htmlsanitycheck.collect.SingleCheckResults;
import org.aim42.htmlsanitycheck.html.HtmlPage;
import org.aim42.htmlsanitycheck.html.URLUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingLocalResourcesChecker
extends Checker {
    public static final String MLRC_MESSAGE_PREFIX = "local resource";
    public static final String MLRC_MESSAGE_MISSING = "missing";
    public static final String MLRC_REFCOUNT = ", reference count: ";
    private List<String> localResourcesList;
    private Set<String> localResourcesSet;
    private File baseDir;
    private File currentDir;
    private boolean requireFiles;
    private static final Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MissingLocalResourcesChecker(Configuration pConfig) {
        boolean bl;
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        super(pConfig);
        this.requireFiles = bl = false;
        Object object = callSiteArray[0].call((Object)pConfig, callSiteArray[1].callGetProperty(Configuration.class));
        this.baseDir = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
    }

    @Override
    protected void initCheckingResultsDescription() {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        String string = "Missing Local Resources Check";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, MissingLocalResourcesChecker.class, (GroovyObject)callSiteArray[2].callGroovyObjectGetProperty((Object)this), (String)"whatIsChecked");
        String string2 = "anchor tag href attribute";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, MissingLocalResourcesChecker.class, (GroovyObject)callSiteArray[3].callGroovyObjectGetProperty((Object)this), (String)"sourceItemName");
        String string3 = "missing local resources";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string3, MissingLocalResourcesChecker.class, (GroovyObject)callSiteArray[4].callGroovyObjectGetProperty((Object)this), (String)"targetItemName");
    }

    @Override
    protected SingleCheckResults check(HtmlPage pageToCheck) {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        List allHrefs = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call((Object)pageToCheck), List.class);
        public class _check_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _check_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _check_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _check_closure1.$getCallSiteArray();
                return callSiteArray[0].call(URLUtil.class, it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _check_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _check_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "isLocalResource";
                return new CallSiteArray(_check_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _check_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = callSiteArray[6].call((Object)allHrefs, (Object)new _check_closure1(this, this));
        this.localResourcesList = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        Object object2 = callSiteArray[7].call(this.localResourcesList);
        this.localResourcesSet = (Set)ScriptBytecodeAdapter.castToType((Object)object2, Set.class);
        callSiteArray[8].call((Object)logger, (Object)new GStringImpl(new Object[]{this.localResourcesSet}, new String[]{"local resources set: ", ""}));
        Object object3 = callSiteArray[9].callGetPropertySafe(callSiteArray[10].callGroovyObjectGetProperty((Object)pageToCheck));
        Object object4 = DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : this.baseDir;
        this.currentDir = (File)ScriptBytecodeAdapter.castToType((Object)object4, File.class);
        callSiteArray[11].callCurrent((GroovyObject)this, this.localResourcesSet);
        return (SingleCheckResults)ScriptBytecodeAdapter.castToType((Object)callSiteArray[12].callGroovyObjectGetProperty((Object)this), SingleCheckResults.class);
    }

    private void checkAllLocalResources(Set<String> localResources) {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        public class _checkAllLocalResources_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _checkAllLocalResources_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _checkAllLocalResources_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object localResource) {
                CallSite[] callSiteArray = _checkAllLocalResources_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, localResource);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkAllLocalResources_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "checkSingleLocalResource";
                return new CallSiteArray(_checkAllLocalResources_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _checkAllLocalResources_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[13].call(localResources, (Object)new _checkAllLocalResources_closure2(this, this));
    }

    private void checkSingleLocalResource(String localResource) {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        callSiteArray[14].call((Object)logger, (Object)new GStringImpl(new Object[]{localResource}, new String[]{"single resource to be checked: + ", ""}));
        callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty((Object)this));
        String localResourcePath = ShortTypeHandling.castToString((Object)callSiteArray[17].call(callSiteArray[18].callConstructor(URI.class, (Object)localResource)));
        if (ScriptBytecodeAdapter.compareEqual((Object)localResourcePath, null)) {
            return;
        }
        File parentDir = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].callSafe((Object)localResourcePath, (Object)"/")) ? this.baseDir : this.currentDir;
        File localFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callConstructor(File.class, (Object)parentDir, (Object)localResourcePath), File.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call((Object)localFile)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].call((Object)localFile))) {
                callSiteArray[23].callCurrent((GroovyObject)this, (Object)localResource);
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call((Object)localFile)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call((Object)localFile))) {
            this.handleNonexistingLocalResource(localResource);
        }
    }

    private Object handleNonexistingLocalResource(String nonExistingLocalResource) {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        String findingText = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{MLRC_MESSAGE_PREFIX, nonExistingLocalResource, MLRC_MESSAGE_MISSING}, new String[]{"", " \"", "\" ", ""}));
        int nrOfOccurrences = DefaultTypeTransformation.intUnbox((Object)callSiteArray[26].call(this.localResourcesList, (Object)nonExistingLocalResource));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (nrOfOccurrences > 1) {
                findingText = ShortTypeHandling.castToString((Object)callSiteArray[27].call((Object)findingText, callSiteArray[28].call((Object)MLRC_REFCOUNT, (Object)nrOfOccurrences)));
            }
        } else if (nrOfOccurrences > 1) {
            findingText = ShortTypeHandling.castToString((Object)callSiteArray[29].call((Object)findingText, callSiteArray[30].call((Object)MLRC_REFCOUNT, (Object)nrOfOccurrences)));
        }
        return callSiteArray[31].call(callSiteArray[32].callGroovyObjectGetProperty((Object)this), (Object)findingText, (Object)nrOfOccurrences);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MissingLocalResourcesChecker.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object = MissingLocalResourcesChecker.$getCallSiteArray()[33].call(LoggerFactory.class, MissingLocalResourcesChecker.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getConfigItemByName";
        stringArray[1] = "ITEM_NAME_sourceDir";
        stringArray[2] = "checkingResults";
        stringArray[3] = "checkingResults";
        stringArray[4] = "checkingResults";
        stringArray[5] = "getAllHrefStrings";
        stringArray[6] = "findAll";
        stringArray[7] = "toSet";
        stringArray[8] = "debug";
        stringArray[9] = "parentFile";
        stringArray[10] = "file";
        stringArray[11] = "checkAllLocalResources";
        stringArray[12] = "checkingResults";
        stringArray[13] = "each";
        stringArray[14] = "debug";
        stringArray[15] = "incNrOfChecks";
        stringArray[16] = "checkingResults";
        stringArray[17] = "getPath";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "startsWith";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "exists";
        stringArray[22] = "isFile";
        stringArray[23] = "handleNonexistingLocalResource";
        stringArray[24] = "exists";
        stringArray[25] = "isFile";
        stringArray[26] = "count";
        stringArray[27] = "plus";
        stringArray[28] = "plus";
        stringArray[29] = "plus";
        stringArray[30] = "plus";
        stringArray[31] = "newFinding";
        stringArray[32] = "checkingResults";
        stringArray[33] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[34];
        MissingLocalResourcesChecker.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MissingLocalResourcesChecker.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MissingLocalResourcesChecker.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

