/*
 * Decompiled with CFR 0.152.
 */
package org.aim42.htmlsanitycheck.check;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.aim42.htmlsanitycheck.Configuration;
import org.aim42.htmlsanitycheck.check.SuggestingChecker;
import org.aim42.htmlsanitycheck.collect.SingleCheckResults;
import org.aim42.htmlsanitycheck.html.HtmlPage;
import org.aim42.htmlsanitycheck.html.URLUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class BrokenCrossReferencesChecker
extends SuggestingChecker {
    private List<String> listOfIds;
    private List<String> hrefList;
    private Set<String> hrefSet;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public BrokenCrossReferencesChecker(Configuration pConfig) {
        CallSite[] callSiteArray = BrokenCrossReferencesChecker.$getCallSiteArray();
        super(pConfig);
    }

    @Override
    protected void initCheckingResultsDescription() {
        CallSite[] callSiteArray = BrokenCrossReferencesChecker.$getCallSiteArray();
        String string = "Broken Internal Links Check";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, BrokenCrossReferencesChecker.class, (GroovyObject)callSiteArray[0].callGroovyObjectGetProperty((Object)this), (String)"whatIsChecked");
        String string2 = "href";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, BrokenCrossReferencesChecker.class, (GroovyObject)callSiteArray[1].callGroovyObjectGetProperty((Object)this), (String)"sourceItemName");
        String string3 = "missing id";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string3, BrokenCrossReferencesChecker.class, (GroovyObject)callSiteArray[2].callGroovyObjectGetProperty((Object)this), (String)"targetItemName");
    }

    @Override
    protected void setValidPossibilities() {
        CallSite[] callSiteArray = BrokenCrossReferencesChecker.$getCallSiteArray();
        List<String> list = this.listOfIds;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((ArrayList)ScriptBytecodeAdapter.castToType(list, ArrayList.class)), BrokenCrossReferencesChecker.class, (GroovyObject)this, (String)"validPossibilities");
    }

    @Override
    protected SingleCheckResults check(HtmlPage pageToCheck) {
        CallSite[] callSiteArray = BrokenCrossReferencesChecker.$getCallSiteArray();
        Object object = callSiteArray[3].call((Object)pageToCheck);
        this.hrefList = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        Object object2 = callSiteArray[4].call(this.hrefList);
        this.hrefSet = (Set)ScriptBytecodeAdapter.castToType((Object)object2, Set.class);
        Object object3 = callSiteArray[5].call((Object)pageToCheck);
        this.listOfIds = (List)ScriptBytecodeAdapter.castToType((Object)object3, List.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[6].callCurrent((GroovyObject)this);
        } else {
            this.checkAllInternalLinks();
        }
        return (SingleCheckResults)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callGroovyObjectGetProperty((Object)this), SingleCheckResults.class);
    }

    private void checkAllInternalLinks() {
        CallSite[] callSiteArray = BrokenCrossReferencesChecker.$getCallSiteArray();
        public class _checkAllInternalLinks_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _checkAllInternalLinks_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _checkAllInternalLinks_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object href) {
                CallSite[] callSiteArray = _checkAllInternalLinks_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, href);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkAllInternalLinks_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "checkSingleInternalLink";
                return new CallSiteArray(_checkAllInternalLinks_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _checkAllInternalLinks_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[8].call(this.hrefSet, (Object)new _checkAllInternalLinks_closure1(this, this));
    }

    private void checkSingleInternalLink(String href) {
        CallSite[] callSiteArray = BrokenCrossReferencesChecker.$getCallSiteArray();
        callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty((Object)this));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(URLUtil.class, (Object)href))) {
            String findingText = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{href}, new String[]{"link \"", "\" contains illegal characters"}));
            int nrOfReferences = 0;
            if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[12].callCurrent((GroovyObject)this, (Object)href);
                nrOfReferences = DefaultTypeTransformation.intUnbox((Object)object);
            } else {
                int n;
                nrOfReferences = n = this.countNrOfReferences(href);
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (nrOfReferences > 1) {
                    findingText = ShortTypeHandling.castToString((Object)callSiteArray[13].call((Object)findingText, (Object)new GStringImpl(new Object[]{nrOfReferences}, new String[]{", reference count: ", ""})));
                }
            } else if (nrOfReferences > 1) {
                findingText = ShortTypeHandling.castToString((Object)callSiteArray[14].call((Object)findingText, (Object)new GStringImpl(new Object[]{nrOfReferences}, new String[]{", reference count: ", ""})));
            }
            callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty((Object)this), (Object)findingText, (Object)nrOfReferences);
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call(URLUtil.class, (Object)href))) {
            callSiteArray[18].call(callSiteArray[19].callGroovyObjectGetProperty((Object)this));
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                callSiteArray[20].callCurrent((GroovyObject)this, (Object)href);
            } else {
                this.doesLinkTargetExist(href);
            }
        }
    }

    private void doesLinkTargetExist(String href) {
        CallSite[] callSiteArray = BrokenCrossReferencesChecker.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)href, (Object)"#")) {
            return;
        }
        String linkTarget = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call((Object)href, (Object)"#")) ? callSiteArray[22].call((Object)href, (Object)ScriptBytecodeAdapter.createRange((Object)1, (Object)-1, (boolean)true)) : href));
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call(this.listOfIds, (Object)linkTarget))) {
                callSiteArray[24].callCurrent((GroovyObject)this, (Object)linkTarget, (Object)href);
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[25].call(this.listOfIds, (Object)linkTarget))) {
            this.addBrokenLinkToResults(linkTarget, href);
        }
    }

    private void addBrokenLinkToResults(String linkTarget, String href) {
        CallSite[] callSiteArray = BrokenCrossReferencesChecker.$getCallSiteArray();
        String findingText = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{linkTarget}, new String[]{"link target \"", "\" missing"}));
        int nrOfReferences = 0;
        if (!BytecodeInterface8.isOrigInt() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[26].callCurrent((GroovyObject)this, (Object)href);
            nrOfReferences = DefaultTypeTransformation.intUnbox((Object)object);
        } else {
            int n;
            nrOfReferences = n = this.countNrOfReferences(href);
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (nrOfReferences > 1) {
                findingText = ShortTypeHandling.castToString((Object)callSiteArray[27].call((Object)findingText, (Object)new GStringImpl(new Object[]{nrOfReferences}, new String[]{", reference count: ", ""})));
            }
        } else if (nrOfReferences > 1) {
            findingText = ShortTypeHandling.castToString((Object)callSiteArray[28].call((Object)findingText, (Object)new GStringImpl(new Object[]{nrOfReferences}, new String[]{", reference count: ", ""})));
        }
        callSiteArray[29].call(callSiteArray[30].callGroovyObjectGetProperty((Object)this), (Object)findingText, (Object)nrOfReferences);
    }

    private int countNrOfReferences(String href) {
        Reference href2 = new Reference((Object)href);
        CallSite[] callSiteArray = BrokenCrossReferencesChecker.$getCallSiteArray();
        public class _countNrOfReferences_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference href;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _countNrOfReferences_closure2(Object _outerInstance, Object _thisObject, Reference href) {
                Reference reference;
                CallSite[] callSiteArray = _countNrOfReferences_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.href = reference = href;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _countNrOfReferences_closure2.$getCallSiteArray();
                return ScriptBytecodeAdapter.compareEqual((Object)it, (Object)this.href.get());
            }

            public String getHref() {
                CallSite[] callSiteArray = _countNrOfReferences_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.href.get());
            }

            public Object doCall() {
                CallSite[] callSiteArray = _countNrOfReferences_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _countNrOfReferences_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_countNrOfReferences_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _countNrOfReferences_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        int nrOfReferences = DefaultTypeTransformation.intUnbox((Object)callSiteArray[31].call(callSiteArray[32].call(this.hrefList, (Object)new _countNrOfReferences_closure2(this, this, href2))));
        return nrOfReferences;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BrokenCrossReferencesChecker.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "checkingResults";
        stringArray[1] = "checkingResults";
        stringArray[2] = "checkingResults";
        stringArray[3] = "getAllHrefStrings";
        stringArray[4] = "toSet";
        stringArray[5] = "getAllIdStrings";
        stringArray[6] = "checkAllInternalLinks";
        stringArray[7] = "checkingResults";
        stringArray[8] = "each";
        stringArray[9] = "incNrOfChecks";
        stringArray[10] = "checkingResults";
        stringArray[11] = "containsInvalidChars";
        stringArray[12] = "countNrOfReferences";
        stringArray[13] = "plus";
        stringArray[14] = "plus";
        stringArray[15] = "newFinding";
        stringArray[16] = "checkingResults";
        stringArray[17] = "isCrossReference";
        stringArray[18] = "incNrOfChecks";
        stringArray[19] = "checkingResults";
        stringArray[20] = "doesLinkTargetExist";
        stringArray[21] = "startsWith";
        stringArray[22] = "getAt";
        stringArray[23] = "contains";
        stringArray[24] = "addBrokenLinkToResults";
        stringArray[25] = "contains";
        stringArray[26] = "countNrOfReferences";
        stringArray[27] = "plus";
        stringArray[28] = "plus";
        stringArray[29] = "newFinding";
        stringArray[30] = "checkingResults";
        stringArray[31] = "size";
        stringArray[32] = "findAll";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[33];
        BrokenCrossReferencesChecker.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(BrokenCrossReferencesChecker.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = BrokenCrossReferencesChecker.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

