/*
 * Decompiled with CFR 0.152.
 */
package org.aim42.htmlsanitycheck.check;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.aim42.htmlsanitycheck.check.Checker;
import org.aim42.htmlsanitycheck.collect.SingleCheckResults;
import org.aim42.htmlsanitycheck.html.HtmlPage;
import org.aim42.htmlsanitycheck.html.URLUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingLocalResourcesChecker
extends Checker {
    public static final String MLRC_MESSAGE_PREFIX = "local resource";
    public static final String MLRC_MESSAGE_MISSING = "missing";
    public static final String MLRC_REFCOUNT = ", reference count: ";
    private List<String> localResourcesList;
    private Set<String> localResourcesSet;
    private String baseDirPath;
    private boolean requireFiles;
    private static Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MissingLocalResourcesChecker() {
        MetaClass metaClass;
        boolean bl;
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        this.requireFiles = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    protected void initCheckingResultsDescription() {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        String string = "Missing Local Resources Check";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, MissingLocalResourcesChecker.class, (GroovyObject)callSiteArray[0].callGroovyObjectGetProperty((Object)this), (String)"whatIsChecked");
        String string2 = "anchor tag href attribute";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, MissingLocalResourcesChecker.class, (GroovyObject)callSiteArray[1].callGroovyObjectGetProperty((Object)this), (String)"sourceItemName");
        String string3 = "missing local resources";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string3, MissingLocalResourcesChecker.class, (GroovyObject)callSiteArray[2].callGroovyObjectGetProperty((Object)this), (String)"targetItemName");
    }

    @Override
    protected SingleCheckResults check(HtmlPage pageToCheck) {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        List allHrefs = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call((Object)pageToCheck), List.class);
        public class _check_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _check_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _check_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _check_closure1.$getCallSiteArray();
                return callSiteArray[0].call(URLUtil.class, it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _check_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _check_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "isLocalResource";
                return new CallSiteArray(_check_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _check_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = callSiteArray[4].call((Object)allHrefs, (Object)new _check_closure1(this, this));
        this.localResourcesList = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        Object object2 = callSiteArray[5].call(this.localResourcesList);
        this.localResourcesSet = (Set)ScriptBytecodeAdapter.castToType((Object)object2, Set.class);
        callSiteArray[6].call((Object)logger, (Object)new GStringImpl(new Object[]{this.localResourcesSet}, new String[]{"local resources set: ", ""}));
        if (ScriptBytecodeAdapter.compareEqual((Object)this.baseDirPath, null)) {
            String string;
            callSiteArray[7].call((Object)logger, (Object)"no baseDir given, set to empty string.");
            this.baseDirPath = string = "";
        }
        callSiteArray[8].callCurrent((GroovyObject)this, this.localResourcesSet);
        return (SingleCheckResults)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callGroovyObjectGetProperty((Object)this), SingleCheckResults.class);
    }

    private void checkAllLocalResources(Set<String> localResources) {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        public class _checkAllLocalResources_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _checkAllLocalResources_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _checkAllLocalResources_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object localResource) {
                CallSite[] callSiteArray = _checkAllLocalResources_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, localResource);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _checkAllLocalResources_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "checkSingleLocalResource";
                return new CallSiteArray(_checkAllLocalResources_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _checkAllLocalResources_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[10].call(localResources, (Object)new _checkAllLocalResources_closure2(this, this));
    }

    private void checkSingleLocalResource(String localResource) {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        callSiteArray[11].call((Object)logger, (Object)new GStringImpl(new Object[]{localResource}, new String[]{"single resource to be checked: + ", ""}));
        callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)this));
        String localResourcePath = ShortTypeHandling.castToString((Object)callSiteArray[14].call(callSiteArray[15].callConstructor(URI.class, (Object)localResource)));
        File localFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callConstructor(File.class, (Object)this.baseDirPath, (Object)localResourcePath), File.class);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)localFile)) || this.requireFiles && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].call((Object)localFile))) {
                callSiteArray[19].callCurrent((GroovyObject)this, (Object)localResource);
            }
        } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].call((Object)localFile)) || this.requireFiles && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call((Object)localFile))) {
            this.handleNonexistingLocalResource(localResource);
        }
    }

    private Object handleNonexistingLocalResource(String nonExistingLocalResource) {
        CallSite[] callSiteArray = MissingLocalResourcesChecker.$getCallSiteArray();
        String findingText = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{MLRC_MESSAGE_PREFIX, nonExistingLocalResource, MLRC_MESSAGE_MISSING}, new String[]{"", " \"", "\" ", ""}));
        int nrOfOccurrences = DefaultTypeTransformation.intUnbox((Object)callSiteArray[22].call(this.localResourcesList, (Object)nonExistingLocalResource));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (nrOfOccurrences > 1) {
                findingText = ShortTypeHandling.castToString((Object)callSiteArray[23].call((Object)findingText, callSiteArray[24].call((Object)MLRC_REFCOUNT, (Object)nrOfOccurrences)));
            }
        } else if (nrOfOccurrences > 1) {
            findingText = ShortTypeHandling.castToString((Object)callSiteArray[25].call((Object)findingText, callSiteArray[26].call((Object)MLRC_REFCOUNT, (Object)nrOfOccurrences)));
        }
        return callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty((Object)this), (Object)findingText, (Object)nrOfOccurrences);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MissingLocalResourcesChecker.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object = MissingLocalResourcesChecker.$getCallSiteArray()[29].call(LoggerFactory.class, MissingLocalResourcesChecker.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "checkingResults";
        stringArray[1] = "checkingResults";
        stringArray[2] = "checkingResults";
        stringArray[3] = "getAllHrefStrings";
        stringArray[4] = "findAll";
        stringArray[5] = "toSet";
        stringArray[6] = "debug";
        stringArray[7] = "info";
        stringArray[8] = "checkAllLocalResources";
        stringArray[9] = "checkingResults";
        stringArray[10] = "each";
        stringArray[11] = "debug";
        stringArray[12] = "incNrOfChecks";
        stringArray[13] = "checkingResults";
        stringArray[14] = "getPath";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "exists";
        stringArray[18] = "isFile";
        stringArray[19] = "handleNonexistingLocalResource";
        stringArray[20] = "exists";
        stringArray[21] = "isFile";
        stringArray[22] = "count";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "plus";
        stringArray[26] = "plus";
        stringArray[27] = "newFinding";
        stringArray[28] = "checkingResults";
        stringArray[29] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[30];
        MissingLocalResourcesChecker.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MissingLocalResourcesChecker.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MissingLocalResourcesChecker.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

