/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.plugins.check_updates;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import name.remal.gradle_plugins.dsl.BuildTask;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Retrofit;
import name.remal.gradle_plugins.plugins.check_updates.services_gradle_org.GradleOrgServices;
import name.remal.gradle_plugins.plugins.check_updates.services_gradle_org.VersionInfo;
import name.remal.gradle_plugins.utils.NewJsonRetrofitBuilderKt;
import name.remal.gradle_plugins.utils.Retrofit2_Retrofit_BuilderKt;
import org.gradle.StartParameter;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;

@BuildTask
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lname/remal/gradle_plugins/plugins/check_updates/CheckGradleUpdates;", "Lorg/gradle/api/DefaultTask;", "()V", "gradleOrgServices", "Lname/remal/gradle_plugins/plugins/check_updates/services_gradle_org/GradleOrgServices;", "doCheckGradleUpdates", "", "gradle-plugins"})
public class CheckGradleUpdates
extends DefaultTask {
    private final GradleOrgServices gradleOrgServices;

    @TaskAction
    public void doCheckGradleUpdates() {
        try {
            GradleVersion currentVersion = GradleVersion.current();
            Logger logger = this.getLogger();
            GradleVersion gradleVersion = currentVersion;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"currentVersion");
            logger.info("Current Gradle version: {}", (Object)gradleVersion.getVersion());
            VersionInfo info = this.gradleOrgServices.getCurrentVersion();
            this.getLogger().info("Latest Gradle version: {}", (Object)info.getVersion());
            if (currentVersion.compareTo(GradleVersion.version((String)info.getVersion())) < 0) {
                this.getLogger().lifecycle("New Gradle version is available: {} (downloadUrl: {})", new Object[]{info.getVersion(), info.getDownloadUrl()});
            }
            this.setDidWork(true);
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    public CheckGradleUpdates() {
        this.setGroup("help");
        this.setDescription("Displays a message if there is newer version of Gradle");
        this.onlyIf((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                Project project = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                Gradle gradle = project.getGradle();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
                StartParameter startParameter = gradle.getStartParameter();
                Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.gradle.startParameter");
                return !startParameter.isOffline();
            }
        });
        Retrofit.Builder builder = NewJsonRetrofitBuilderKt.newJsonRetrofitBuilder().baseUrl("https://services.gradle.org/");
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"newJsonRetrofitBuilder()\u2026://services.gradle.org/\")");
        this.gradleOrgServices = Retrofit2_Retrofit_BuilderKt.create(builder, GradleOrgServices.class);
    }
}

