/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.retrofit2.converter.jackson;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JavaType;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ObjectMapper;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ObjectReader;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ObjectWriter;
import name.remal.gradle_plugins.internal._relocated.okhttp3.RequestBody;
import name.remal.gradle_plugins.internal._relocated.okhttp3.ResponseBody;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Converter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.Retrofit;
import name.remal.gradle_plugins.internal._relocated.retrofit2.converter.jackson.JacksonRequestBodyConverter;
import name.remal.gradle_plugins.internal._relocated.retrofit2.converter.jackson.JacksonResponseBodyConverter;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public final class JacksonConverterFactory
extends Converter.Factory {
    private final ObjectMapper mapper;

    public static JacksonConverterFactory create() {
        return JacksonConverterFactory.create(new ObjectMapper());
    }

    public static JacksonConverterFactory create(ObjectMapper mapper) {
        if (mapper == null) {
            throw new NullPointerException("mapper == null");
        }
        return new JacksonConverterFactory(mapper);
    }

    private JacksonConverterFactory(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations2, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectReader reader = this.mapper.readerFor(javaType);
        return new JacksonResponseBodyConverter(reader);
    }

    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JavaType javaType = this.mapper.getTypeFactory().constructType(type);
        ObjectWriter writer = this.mapper.writerFor(javaType);
        return new JacksonRequestBodyConverter(writer);
    }
}

