/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.name.remal.json.data_format;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonFactory;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.ObjectMapper;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializationFeature;
import name.remal.gradle_plugins.internal._relocated.name.remal.json.api.DataFormat;
import name.remal.gradle_plugins.internal._relocated.name.remal.json.data_format.CustomJSONPrettyPrinter;
import name.remal.gradle_plugins.internal._relocated.name.remal.json.internal.Utils;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;
import org.jetbrains.annotations.NotNull;

@RelocatedClass
public class DataFormatJSON
implements DataFormat {
    @NotNull
    public static final DataFormat JSON_DATA_FORMAT = new DataFormatJSON();
    @NotNull
    private static final JsonFactory JSON_FACTORY = Utils.configure(new JsonFactory());
    @NotNull
    private static final ObjectMapper OBJECT_MAPPER = Utils.configure(new ObjectMapper(JSON_FACTORY));
    @NotNull
    private static final @NotNull List<@NotNull String> MIME_TYPES;
    @NotNull
    private static final @NotNull List<@NotNull String> FILE_EXTENSIONS;

    @Override
    @NotNull
    public ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    @Override
    @NotNull
    public DataFormat withIndention() {
        final ObjectMapper objectMapper = this.getObjectMapper().copy();
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        return new DataFormat(){

            @Override
            @NotNull
            public ObjectMapper getObjectMapper() {
                return objectMapper;
            }

            @Override
            @NotNull
            public DataFormat withIndention() {
                return this;
            }

            @Override
            @NotNull
            public DataFormat withFailOnUnknownProperties() {
                return this;
            }

            @Override
            @NotNull
            public @NotNull List<@NotNull String> getSupportedMimeTypes() {
                return DataFormatJSON.this.getSupportedMimeTypes();
            }

            @Override
            @NotNull
            public @NotNull List<@NotNull String> getSupportedFileExtensions() {
                return DataFormatJSON.this.getSupportedFileExtensions();
            }
        };
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull String> getSupportedMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull String> getSupportedFileExtensions() {
        return FILE_EXTENSIONS;
    }

    static {
        OBJECT_MAPPER.setDefaultPrettyPrinter(new CustomJSONPrettyPrinter());
        MIME_TYPES = Collections.unmodifiableList(Arrays.asList("application/json", "application/x-json", "application/javascript", "application/x-javascript", "text/json", "text/x-json", "text/javascript", "text/x-javascript"));
        FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("json", "js"));
    }
}

