/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.name.remal.json.data_format;

import java.io.IOException;
import java.io.Serializable;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonGenerator;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.PrettyPrinter;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.util.Instantiatable;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;
import org.jetbrains.annotations.NotNull;

@RelocatedClass
class CustomJSONPrettyPrinter
implements PrettyPrinter,
Instantiatable<CustomJSONPrettyPrinter>,
Serializable {
    private static final String INDENT = "    ";
    private transient int depth;

    CustomJSONPrettyPrinter() {
    }

    @Override
    @NotNull
    public CustomJSONPrettyPrinter createInstance() {
        return new CustomJSONPrettyPrinter();
    }

    private void writeIndent(@NotNull JsonGenerator gen) throws IOException {
        for (int i = 0; i < this.depth; ++i) {
            gen.writeRaw(INDENT);
        }
    }

    @Override
    public void writeRootValueSeparator(@NotNull JsonGenerator gen) throws IOException {
        gen.writeRaw("\n");
    }

    @Override
    public void writeStartObject(@NotNull JsonGenerator gen) throws IOException {
        gen.writeRaw("{");
        ++this.depth;
    }

    @Override
    public void beforeObjectEntries(@NotNull JsonGenerator gen) throws IOException {
        gen.writeRaw("\n");
        this.writeIndent(gen);
    }

    @Override
    public void writeObjectFieldValueSeparator(@NotNull JsonGenerator gen) throws IOException {
        gen.writeRaw(": ");
    }

    @Override
    public void writeObjectEntrySeparator(@NotNull JsonGenerator gen) throws IOException {
        gen.writeRaw(",\n");
        this.writeIndent(gen);
    }

    @Override
    public void writeEndObject(@NotNull JsonGenerator gen, int nrOfEntries) throws IOException {
        --this.depth;
        if (1 <= nrOfEntries) {
            gen.writeRaw("\n");
            this.writeIndent(gen);
        }
        gen.writeRaw("}");
    }

    @Override
    public void writeStartArray(@NotNull JsonGenerator gen) throws IOException {
        gen.writeRaw("[");
        ++this.depth;
    }

    @Override
    public void beforeArrayValues(@NotNull JsonGenerator gen) throws IOException {
        gen.writeRaw("\n");
        this.writeIndent(gen);
    }

    @Override
    public void writeArrayValueSeparator(@NotNull JsonGenerator gen) throws IOException {
        gen.writeRaw(",\n");
        this.writeIndent(gen);
    }

    @Override
    public void writeEndArray(@NotNull JsonGenerator gen, int nrOfValues) throws IOException {
        --this.depth;
        if (1 <= nrOfValues) {
            gen.writeRaw("\n");
            this.writeIndent(gen);
        }
        gen.writeRaw("]");
    }
}

