/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class AdditionOrderedSet<T>
implements Iterable<T> {
    private final HashSet<T> set;
    private final ArrayList<T> list;

    public boolean add(T elt) {
        if (this.set.add(elt)) {
            this.list.add(elt);
            return true;
        }
        return false;
    }

    public boolean addAll(Iterable<T> items) {
        boolean changed = false;
        for (T item : items) {
            changed |= this.add(item);
        }
        return changed;
    }

    public boolean contains(T elt) {
        return this.set.contains(elt);
    }

    public List<T> toList() {
        return this.list;
    }

    public AdditionOrderedSet() {
        this(16);
    }

    public AdditionOrderedSet(int initialSize) {
        this.set = new HashSet(initialSize);
        this.list = new ArrayList(initialSize);
    }

    public AdditionOrderedSet(List<T> elts) {
        this(elts.size());
        for (T elt : elts) {
            this.add(elt);
        }
    }

    public AdditionOrderedSet(T[] elts) {
        this(elts.length);
        for (T elt : elts) {
            this.add(elt);
        }
    }

    public static <T> List<T> dedup(List<T> list) {
        return new AdditionOrderedSet<T>(list).toList();
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }
}

