/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.ClassRefTypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.HierarchicalTypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.TypeParameter;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.TypeVariableSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.utils.AdditionOrderedSet;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class ClassTypeSignature
extends HierarchicalTypeSignature {
    final List<TypeParameter> typeParameters;
    private final ClassRefTypeSignature superclassSignature;
    private final List<ClassRefTypeSignature> superinterfaceSignatures;

    public ClassTypeSignature(List<TypeParameter> typeParameters, ClassRefTypeSignature superclassSignature, List<ClassRefTypeSignature> superinterfaceSignatures) {
        this.typeParameters = typeParameters;
        this.superclassSignature = superclassSignature;
        this.superinterfaceSignatures = superinterfaceSignatures;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public ClassRefTypeSignature getSuperclassSignature() {
        return this.superclassSignature;
    }

    public List<ClassRefTypeSignature> getSuperinterfaceSignatures() {
        return this.superinterfaceSignatures;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        for (TypeParameter typeParameter : this.typeParameters) {
            typeParameter.getAllReferencedClassNames(classNameListOut);
        }
        if (this.superclassSignature != null) {
            this.superclassSignature.getAllReferencedClassNames(classNameListOut);
        }
        for (ClassRefTypeSignature typeSignature : this.superinterfaceSignatures) {
            typeSignature.getAllReferencedClassNames(classNameListOut);
        }
    }

    public int hashCode() {
        return this.typeParameters.hashCode() + this.superclassSignature.hashCode() * 7 + this.superinterfaceSignatures.hashCode() * 15;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassTypeSignature)) {
            return false;
        }
        ClassTypeSignature o = (ClassTypeSignature)obj;
        return o.typeParameters.equals(this.typeParameters) && o.superclassSignature.equals(this.superclassSignature) && o.superinterfaceSignatures.equals(this.superinterfaceSignatures);
    }

    public String toString(int modifiers, boolean isAnnotation, boolean isInterface, String className) {
        String superSig;
        int i;
        StringBuilder buf = new StringBuilder();
        if (modifiers != 0) {
            TypeUtils.modifiersToString(modifiers, false, buf);
        }
        if (!this.typeParameters.isEmpty()) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append('<');
            for (i = 0; i < this.typeParameters.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.typeParameters.get(i).toString());
            }
            buf.append('>');
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(isAnnotation ? "@interface" : (isInterface ? "interface" : ((modifiers & 0x4000) != 0 ? "enum" : "class")));
        if (className != null) {
            buf.append(' ');
            buf.append(className);
        }
        if (this.superclassSignature != null && !(superSig = this.superclassSignature.toString()).equals("java.lang.Object")) {
            buf.append(" extends ");
            buf.append(superSig);
        }
        if (!this.superinterfaceSignatures.isEmpty()) {
            buf.append(" implements");
            for (i = 0; i < this.superinterfaceSignatures.size(); ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(' ');
                buf.append(this.superinterfaceSignatures.get(i).toString());
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(0, false, false, null);
    }

    public static ClassTypeSignature merge(ClassTypeSignature classSignature0, ClassTypeSignature classSignature1) {
        List<TypeParameter> allTypeParams;
        List<ClassRefTypeSignature> allSuperinterfaces;
        ClassRefTypeSignature superclassSig;
        if (classSignature0.superclassSignature == null || classSignature0.superclassSignature.className.equals("java.lang.Object")) {
            superclassSig = classSignature1.superclassSignature;
        } else if (classSignature1.superclassSignature == null || classSignature1.superclassSignature.className.equals("java.lang.Object")) {
            superclassSig = classSignature0.superclassSignature;
        } else {
            throw new IllegalArgumentException("A class and its auxiliary class have different superclasses: " + classSignature0 + " ; " + classSignature1);
        }
        if (classSignature0.superinterfaceSignatures.isEmpty()) {
            allSuperinterfaces = classSignature1.superinterfaceSignatures;
        } else if (classSignature1.superinterfaceSignatures.isEmpty()) {
            allSuperinterfaces = classSignature0.superinterfaceSignatures;
        } else {
            AdditionOrderedSet<ClassRefTypeSignature> superinterfacesUniq = new AdditionOrderedSet<ClassRefTypeSignature>(classSignature0.superinterfaceSignatures);
            superinterfacesUniq.addAll(classSignature1.superinterfaceSignatures);
            allSuperinterfaces = superinterfacesUniq.toList();
        }
        if (classSignature0.typeParameters.isEmpty()) {
            allTypeParams = classSignature1.typeParameters;
        } else if (classSignature1.typeParameters.isEmpty()) {
            allTypeParams = classSignature0.typeParameters;
        } else {
            AdditionOrderedSet<TypeParameter> typeParamsUniq = new AdditionOrderedSet<TypeParameter>(classSignature0.typeParameters);
            typeParamsUniq.addAll(classSignature1.typeParameters);
            allTypeParams = typeParamsUniq.toList();
        }
        return new ClassTypeSignature(allTypeParams, superclassSig, allSuperinterfaces);
    }

    public static ClassTypeSignature parse(String typeDescriptor) {
        TypeUtils.ParseState parseState = new TypeUtils.ParseState(typeDescriptor);
        try {
            List<ClassRefTypeSignature> superinterfaceSignatures;
            List<TypeParameter> typeParameters = TypeParameter.parseList(parseState);
            ClassRefTypeSignature superclassSignature = ClassRefTypeSignature.parse(parseState);
            if (parseState.hasMore()) {
                superinterfaceSignatures = new ArrayList();
                while (parseState.hasMore()) {
                    ClassRefTypeSignature superinterfaceSignature = ClassRefTypeSignature.parse(parseState);
                    if (superinterfaceSignature == null) {
                        throw new TypeUtils.ParseException();
                    }
                    superinterfaceSignatures.add(superinterfaceSignature);
                }
            } else {
                superinterfaceSignatures = Collections.emptyList();
            }
            if (parseState.hasMore()) {
                throw new IllegalArgumentException("Extra characters at end of type descriptor: " + parseState);
            }
            ClassTypeSignature classSignature = new ClassTypeSignature(typeParameters, superclassSignature, superinterfaceSignatures);
            for (TypeVariableSignature typeVariableSignature : parseState.getTypeVariableSignatures()) {
                typeVariableSignature.containingClassSignature = classSignature;
            }
            return classSignature;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Type signature could not be parsed: " + parseState, e);
        }
    }
}

