/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature;

import java.lang.reflect.Array;
import java.util.Set;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.ReferenceTypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.TypeSignature;
import name.remal.gradle_plugins.internal._relocated.io.github.lukehutch.fastclasspathscanner.typesignature.TypeUtils;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class ArrayTypeSignature
extends ReferenceTypeSignature {
    final TypeSignature elementTypeSignature;
    final int numArrayDims;

    public ArrayTypeSignature(TypeSignature elementTypeSignature, int numArrayDims) {
        this.elementTypeSignature = elementTypeSignature;
        this.numArrayDims = numArrayDims;
    }

    public TypeSignature getElementTypeSignature() {
        return this.elementTypeSignature;
    }

    public int getNumArrayDims() {
        return this.numArrayDims;
    }

    @Override
    public void getAllReferencedClassNames(Set<String> classNameListOut) {
        this.elementTypeSignature.getAllReferencedClassNames(classNameListOut);
    }

    private static Class<?> arrayify(Class<?> cls, int arrayDims) {
        if (arrayDims == 0) {
            return cls;
        }
        int[] zeroes = (int[])Array.newInstance(Integer.TYPE, arrayDims);
        return Array.newInstance(cls, zeroes).getClass();
    }

    @Override
    public Class<?> instantiate(ScanResult scanResult) {
        Class<?> elementClassRef = this.elementTypeSignature.instantiate(scanResult);
        return ArrayTypeSignature.arrayify(elementClassRef, this.numArrayDims);
    }

    public int hashCode() {
        return this.elementTypeSignature.hashCode() + this.numArrayDims * 15;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ArrayTypeSignature)) {
            return false;
        }
        ArrayTypeSignature o = (ArrayTypeSignature)obj;
        return o.elementTypeSignature.equals(this.elementTypeSignature) && o.numArrayDims == this.numArrayDims;
    }

    @Override
    public boolean equalsIgnoringTypeParams(TypeSignature other) {
        if (!(other instanceof ArrayTypeSignature)) {
            return false;
        }
        ArrayTypeSignature o = (ArrayTypeSignature)other;
        return o.elementTypeSignature.equalsIgnoringTypeParams(this.elementTypeSignature) && o.numArrayDims == this.numArrayDims;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.elementTypeSignature.toString());
        for (int i = 0; i < this.numArrayDims; ++i) {
            buf.append("[]");
        }
        return buf.toString();
    }

    static ArrayTypeSignature parse(TypeUtils.ParseState parseState) throws TypeUtils.ParseException {
        int numArrayDims = 0;
        while (parseState.peek() == '[') {
            ++numArrayDims;
            parseState.next();
        }
        if (numArrayDims > 0) {
            TypeSignature elementTypeSignature = TypeSignature.parse(parseState);
            if (elementTypeSignature == null) {
                throw new TypeUtils.ParseException();
            }
            return new ArrayTypeSignature(elementTypeSignature, numArrayDims);
        }
        return null;
    }
}

