/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.datatype.jsr310.ser;

import java.io.IOException;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.annotation.JsonFormat;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonGenerator;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonParser;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonToken;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JavaType;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.JsonMappingException;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializationFeature;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.SerializerProvider;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class DurationSerializer
extends JSR310FormattedSerializerBase<Duration> {
    private static final long serialVersionUID = 1L;
    public static final DurationSerializer INSTANCE = new DurationSerializer();

    private DurationSerializer() {
        super(Duration.class);
    }

    protected DurationSerializer(DurationSerializer base, Boolean useTimestamp, DateTimeFormatter dtf) {
        super(base, useTimestamp, dtf, null);
    }

    protected DurationSerializer withFormat(Boolean useTimestamp, DateTimeFormatter dtf, JsonFormat.Shape shape) {
        return new DurationSerializer(this, useTimestamp, dtf);
    }

    @Override
    public void serialize(Duration duration, JsonGenerator generator, SerializerProvider provider) throws IOException {
        if (this.useTimestamp(provider)) {
            if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                generator.writeNumber(DecimalUtils.toBigDecimal(duration.getSeconds(), duration.getNano()));
            } else {
                generator.writeNumber(duration.toMillis());
            }
        } else {
            generator.writeString(duration.toString());
        }
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor2.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
            SerializerProvider provider = visitor2.getProvider();
            if (provider == null || !provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                v2.format(JsonValueFormat.UTC_MILLISEC);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider) {
        if (this.useTimestamp(provider)) {
            if (provider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                return JsonToken.VALUE_NUMBER_FLOAT;
            }
            return JsonToken.VALUE_NUMBER_INT;
        }
        return JsonToken.VALUE_STRING;
    }
}

