/*
 * Decompiled with CFR 0.152.
 */
package name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonParser;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.core.JsonToken;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.databind.DeserializationContext;
import name.remal.gradle_plugins.internal._relocated.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import name.remal.gradle_plugins.plugins.classes_relocation.RelocatedClass;

@RelocatedClass
public class YearDeserializer
extends JSR310DeserializerBase<Year> {
    private static final long serialVersionUID = 1L;
    public static final YearDeserializer INSTANCE = new YearDeserializer();
    private final DateTimeFormatter _formatter;

    private YearDeserializer() {
        this((DateTimeFormatter)null);
    }

    public YearDeserializer(DateTimeFormatter formatter) {
        super(Year.class);
        this._formatter = formatter;
    }

    @Override
    public Year deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken t = parser.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String string = parser.getValueAsString().trim();
            try {
                if (this._formatter == null) {
                    return Year.parse(string);
                }
                return Year.parse(string, this._formatter);
            }
            catch (DateTimeException e) {
                this._rethrowDateTimeException(parser, context, e, string);
            }
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return Year.of(parser.getIntValue());
        }
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (Year)parser.getEmbeddedObject();
        }
        if (parser.hasToken(JsonToken.START_ARRAY)) {
            return (Year)this._deserializeFromArray(parser, context);
        }
        return (Year)this._reportWrongToken(parser, context, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT);
    }
}

